/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.configurationClasses;

import com.nxp.swtools.asr.configurationClasses.ConfigClassXmlElement;
import com.nxp.swtools.asr.configurationClasses.DepdententNodesXmlElement;
import com.nxp.swtools.asr.configurationClasses.DummyConfigTimeSupportXmlElement;
import com.nxp.swtools.asr.configurationClasses.VariantLocationXmlElement;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config_time_support", strict=false)
public class ConfigTimeSupportXmlElement {
    private static final Logger LOGGER = LogManager.getLogger(ConfigTimeSupportXmlElement.class);
    public static final String DEFAULT_FILE_NAME = "configTimeSupport.xml";
    @ElementList(name="config_classes", entry="config_class", empty=false)
    private List<ConfigClassXmlElement> configClasses;
    @Element(name="variant_location", required=false)
    @Nullable
    private @Element(name="variant_location", required=false) @Nullable VariantLocationXmlElement variantLocation;
    @Element(name="dependent_nodes", required=false)
    @Nullable
    private @Element(name="dependent_nodes", required=false) @Nullable DepdententNodesXmlElement dependentNodesOption;

    @Deprecated
    protected ConfigTimeSupportXmlElement() {
        this(new ArrayList<ConfigClassXmlElement>(), null, null);
    }

    public ConfigTimeSupportXmlElement(List<ConfigClassXmlElement> configClasses, @Nullable VariantLocationXmlElement variantLocation, @Nullable DepdententNodesXmlElement dependentNodesOption) {
        this.configClasses = configClasses;
        this.variantLocation = variantLocation;
        this.dependentNodesOption = dependentNodesOption;
    }

    public List<ConfigClassXmlElement> getConfigClasses() {
        return CollectionsUtils.unmodifiableList(this.configClasses);
    }

    public @Nullable String getVariantLocation() {
        if (this.variantLocation != null) {
            return this.variantLocation.getVariantLocation();
        }
        return null;
    }

    public @Nullable String getDependentNodesOption() {
        if (this.dependentNodesOption != null) {
            return this.dependentNodesOption.getDependentNodesOption();
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.configClasses, this.variantLocation, this.dependentNodesOption);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigTimeSupportXmlElement other = (ConfigTimeSupportXmlElement)obj;
        return Objects.equals(this.configClasses, other.configClasses) && Objects.equals(this.variantLocation, other.variantLocation) && Objects.equals(this.dependentNodesOption, other.dependentNodesOption);
    }

    public @Nullable String getConfigurationClassValueForSettingType(String type) {
        for (ConfigClassXmlElement cfgClass : this.configClasses) {
            if (!cfgClass.getId().equals(type)) continue;
            return cfgClass.getValue();
        }
        return null;
    }

    public static ConfigTimeSupportXmlElement loadConfigClassesFromFile(File source) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream configClassesInStr = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                ConfigTimeSupportXmlElement result = (ConfigTimeSupportXmlElement)serializer.read(ConfigTimeSupportXmlElement.class, configClassesInStr);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error loading configuration classes file " + source.getAbsolutePath(), e);
            return new DummyConfigTimeSupportXmlElement();
        }
    }
}

