/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.indexer.core;

import com.nxp.s32ds.cle.cdt.indexer.core.IndexerService;
import com.nxp.s32ds.cle.cdt.indexer.core.internal.IndexerInstallerActivator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerProcessingRunner
extends ProcessRunner {
    private static final String PROJECT_NAME = "projectName";

    public void process(TemplateCore core, ProcessArgument[] processArguments, String string, IProgressMonitor monitor) throws ProcessFailureException {
        IndexerService indexerService = IndexerInstallerActivator.getInstance().getIndexerService();
        HashMap<String, String> preferencesMap = new HashMap<String, String>();
        String projectName = null;
        ProcessArgument[] processArgumentArray = processArguments;
        int n = processArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if (PROJECT_NAME.equals(name)) {
                    projectName = pa.getSimpleValue();
                } else if (indexerService.getIndexerKeys().contains(name)) {
                    this.readPreferencies(preferencesMap, pa);
                }
            }
            ++n2;
        }
        if (projectName == null) {
            return;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        indexerService.applayIndexerPreferences(preferencesMap, proj);
    }

    private void readPreferencies(Map<String, String> preferencesMap, ProcessArgument pa) {
        preferencesMap.put(pa.getName(), pa.getSimpleValue());
    }
}

