/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.consts.SdkConsts;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceBase;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.w3c.dom.Element;

public class SdkSourceFile
extends SdkSourceBase {
    @NonNull
    private final String type;
    @Nullable
    private final String targetPath;
    @NonNull
    private final String variant;
    @NonNull
    private final String compilerId;
    @Deprecated
    @NonNull
    private final String coreType;
    @Nullable
    private final Collection<@NonNull String> deviceCoreIds;
    @Nullable
    private final Collection<@NonNull String> toolchains;
    private final boolean excluded;
    @NonNull
    private final Collection<String> conditionComponents;
    private boolean generatedDuringBuild;
    private boolean configFile;
    private boolean templateFile;

    public SdkSourceFile(@NonNull String path, @Nullable String targetPath, @NonNull String fileMask, @NonNull String type, @Nullable String variant, @Nullable String compilerId, @Nullable String coreType, @Nullable Collection<@NonNull String> deviceCoreIds, @Nullable Collection<@NonNull String> toolchains, boolean excluded, @NonNull Collection<String> condition, boolean generatedDuringBuild, boolean configFile, boolean templateFile) {
        super(path, fileMask);
        this.type = type;
        this.targetPath = targetPath;
        this.variant = UtilsText.safeString((String)variant);
        this.compilerId = UtilsText.safeString((String)compilerId);
        this.coreType = UtilsText.safeString((String)coreType);
        this.deviceCoreIds = deviceCoreIds != null ? CollectionsUtils.unmodifiableCollection(deviceCoreIds) : null;
        Collection collection = this.toolchains = toolchains != null ? CollectionsUtils.unmodifiableCollection(toolchains) : null;
        if (toolchains != null) {
            toolchains.forEach(t -> {
                if (!ManifestLoaderUtils.isKnownToolchain(t)) {
                    LOGGER.severe("Unsupported toolchain ID in `source` XML element: " + t);
                }
            });
        }
        this.excluded = excluded;
        this.conditionComponents = CollectionsUtils.unmodifiableCollection(condition);
        this.generatedDuringBuild = generatedDuringBuild;
        this.configFile = configFile;
        this.templateFile = templateFile;
    }

    public SdkSourceFile(@NonNull SdkSourceFile source,  @NonNull SdkManifestDescriptor.ManifestHelper variableResolver) {
        super(variableResolver.resolveVariables(source.getPath()), variableResolver.resolveVariables(source.getFileMask()));
        this.type = source.type;
        this.targetPath = source.targetPath;
        this.compilerId = source.compilerId;
        this.toolchains = source.toolchains;
        this.coreType = source.coreType;
        this.deviceCoreIds = source.deviceCoreIds;
        this.variant = source.variant;
        this.excluded = source.excluded;
        this.conditionComponents = source.conditionComponents;
        this.generatedDuringBuild = source.generatedDuringBuild;
        this.configFile = source.configFile;
        this.templateFile = source.templateFile;
    }

    public @NonNull SdkSourceFile cloneToExcluded() {
        assert (!this.excluded);
        return new SdkSourceFile(this.getPath(), this.targetPath, this.getFileMask(), this.type, this.variant, this.compilerId, this.coreType, this.deviceCoreIds, this.toolchains, true, this.conditionComponents, this.generatedDuringBuild, this.configFile, this.templateFile);
    }

    public @NonNull String getVariant() {
        return this.variant;
    }

    public @NonNull String getCompilerId() {
        return this.compilerId;
    }

    public @Nullable Collection<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public boolean isForToolchain(@NonNull String toolchainId) {
        return this.toolchains != null ? this.toolchains.contains(toolchainId) : true;
    }

    public @NonNull String getCoreType() {
        return this.coreType;
    }

    public boolean isDeviceCoreSupported(@NonNull String coreId) {
        return this.deviceCoreIds != null ? this.deviceCoreIds.contains(coreId) : true;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable String getTargetPath() {
        return this.targetPath;
    }

    public boolean isExcludedFromBuild() {
        return this.excluded;
    }

    public @NonNull Collection<String> getConditionComponents() {
        return this.conditionComponents;
    }

    public boolean isGeneratedDuringBuild() {
        return this.generatedDuringBuild;
    }

    public boolean isConfigFile() {
        return this.configFile;
    }

    public boolean isTemplateFile() {
        return this.templateFile;
    }

    public static @NonNull List<@NonNull SdkSourceFile> loadComponentSourceFiles(@NonNull Element parElem, boolean applyFreeRTOSheapExcludeWorkaround) {
        List<@NonNull SdkSourceFile> list = SdkSourceFile.loadSourceFiles(parElem, applyFreeRTOSheapExcludeWorkaround, "relative_path", "project_relative_path", "toolchain");
        String srcPackBasePath = parElem.getAttribute("package_base_path");
        String tgrProjBasePath = parElem.getAttribute("project_base_path");
        return SdkSourceFile.applyBasePath(list, srcPackBasePath, tgrProjBasePath);
    }

    static @NonNull List<@NonNull SdkSourceFile> applyBasePath(@NonNull List<@NonNull SdkSourceFile> fileList, @NonNull String srcBasePath, @NonNull String tgrBasePath) {
        return fileList.stream().map(f -> {
            String srcPath = UtilsFile.toEclipsePath((String)Paths.get(srcBasePath, f.getPath()).normalize().toString());
            String tgrPath = UtilsText.isEmpty((String)f.getTargetPath()) ? f.getPath() : f.getTargetPath();
            tgrPath = UtilsFile.toEclipsePath((String)Paths.get(tgrBasePath, tgrPath).normalize().toString());
            return new SdkSourceFile(srcPath, tgrPath, f.getFileMask(), f.type, f.variant, f.compilerId, f.coreType, f.deviceCoreIds, f.toolchains, f.excluded, f.conditionComponents, f.generatedDuringBuild, f.configFile, f.templateFile);
        }).collect(Collectors.toList());
    }

    public static @NonNull List<@NonNull SdkSourceFile> loadExampleSourceFiles(@NonNull Element parElem, boolean applyFreeRTOSheapExcludeWorkaround, @NonNull Version manifestFormatVersion, @NonNull String examplePath) {
        List<@NonNull SdkSourceFile> files = SdkSourceFile.loadSourceFiles(parElem, applyFreeRTOSheapExcludeWorkaround, "path", "project_relative_path", "toolchain");
        return manifestFormatVersion.compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_10) < 0 ? files : SdkSourceFile.applyBasePath(files, examplePath, "");
    }

    public static @NonNull List<@NonNull SdkSourceFile> loadOldCompExamSourceFiles_manifest3_7(@NonNull Element parElem, Version manifestFormatVersion, boolean applyFreeRTOSheapExcludeWorkaround) {
        return SdkSourceFile.loadSourceFiles(parElem, applyFreeRTOSheapExcludeWorkaround, "path", "target_path", manifestFormatVersion.compareTo(SdkConsts.MANIFEST_FORMAT_VERSION_3_0) < 0 ? "tool" : "toolchain");
    }

    static @NonNull List<@NonNull SdkSourceFile> loadSourceFiles(@NonNull Element parElem, boolean applyFreeRTOSheapExcludeWorkaround, String pathAttrName, String targetAttrName, String toolchainAttrName) {
        ArrayList<@NonNull SdkSourceFile> result = new ArrayList<SdkSourceFile>();
        boolean containsExcludeAttr = false;
        List<Element> sourcesNodeList = ManifestLoaderUtils.getChildrenElements(parElem, "source");
        for (Element elemSource : sourcesNodeList) {
            if (elemSource.hasAttribute(pathAttrName) && elemSource.hasAttribute("type")) {
                boolean excluded;
                String type = elemSource.getAttribute("type");
                String path = elemSource.getAttribute(pathAttrName);
                String targetPath = elemSource.hasAttribute(targetAttrName) ? elemSource.getAttribute(targetAttrName) : null;
                boolean generatedDuringBuildSource = ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("generated_during_build"));
                if (elemSource.hasAttribute("excluded") || elemSource.hasAttribute("exclude")) {
                    containsExcludeAttr = true;
                    excluded = ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("excluded")) || ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("exclude"));
                } else {
                    excluded = false;
                }
                List<Element> childrenNodeList = ManifestLoaderUtils.getChildrenElements(elemSource, "files");
                for (Element elemFiles : childrenNodeList) {
                    assert (type != null && path != null);
                    String mask = elemFiles.getAttribute("mask");
                    String conditionCompsStr = elemSource.getAttribute("condition");
                    List<Object> conditionComps = conditionCompsStr.isEmpty() ? Collections.emptyList() : Arrays.asList(conditionCompsStr.split(" "));
                    List<String> deviceCoreIds = null;
                    if (elemSource.hasAttribute("device_cores")) {
                        deviceCoreIds = Arrays.asList(elemSource.getAttribute("device_cores").split(" "));
                    }
                    List<String> toolchains = null;
                    if (elemSource.hasAttribute(toolchainAttrName)) {
                        toolchains = Arrays.asList(elemSource.getAttribute(toolchainAttrName).split(" "));
                    }
                    boolean templateFile = ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("template"));
                    boolean configFile = ManifestLoaderUtils.isXmlTrue(elemFiles.getAttribute("config")) || ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("config"));
                    boolean generatedDuringBuildFile = elemFiles.hasAttribute("generated_during_build") ? ManifestLoaderUtils.isXmlTrue(elemFiles.getAttribute("generated_during_build")) : generatedDuringBuildSource;
                    SdkSourceFile componentSource = new SdkSourceFile(path, targetPath, mask, type, elemSource.getAttribute("variant"), elemSource.getAttribute("compiler"), elemSource.getAttribute("core"), deviceCoreIds, toolchains, excluded, conditionComps, generatedDuringBuildFile, configFile, templateFile);
                    result.add(componentSource);
                }
                continue;
            }
            assert (false);
        }
        if (applyFreeRTOSheapExcludeWorkaround && !containsExcludeAttr) {
            Iterator iter = result.iterator();
            ArrayList<@NonNull SdkSourceFile> excludedFiles = new ArrayList<SdkSourceFile>();
            while (iter.hasNext()) {
                SdkSourceFile file = (SdkSourceFile)iter.next();
                if (!file.getFileMask().startsWith("heap_") || !file.getFileMask().endsWith(".c") || file.getFileMask().equals("heap_4.c")) continue;
                excludedFiles.add(file.cloneToExcluded());
                iter.remove();
            }
            result.addAll(excludedFiles);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = super.toString();
        return this.excluded ? "[excluded]" + result : result;
    }
}

