/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view;

import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.ExceptionLevelType;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUUtils;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.actions.S32DSMMUPauseViewAction;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.actions.S32DSMMUSelectElAction;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.actions.S32DSMMUTranslateAddressAction;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUArmv8EntryJson;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUArmv8Json;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUInfo;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUInputListener;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.sessions.listeners.S32DSMMUInputProvider;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view.S32DSMMUContentViewer;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view.S32DSMMUTableViewer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;

public class S32DSMMUViewControl
extends AbstractDebugView
implements S32DSMMUInputListener,
IDebugContextListener {
    private S32DSMMUTableViewer viewer;
    private S32DSMMUContentViewer progressBarViewer;
    private S32DSMMUArmv8Json currentInput;
    private DsfSession currentDSfSession;
    private AtomicBoolean suspend = new AtomicBoolean(false);
    private final HashMap<String, String> session2lastError = new HashMap();
    private final S32DSMMUArmv8Json dummyMMU = new S32DSMMUArmv8Json(){

        @Override
        public List<S32DSMMUArmv8EntryJson> getMmuEntries() {
            return Collections.emptyList();
        }

        @Override
        public int getEl() {
            return ExceptionLevelType.UNKNOWN_EXCEPTION_LEVEL.getValueFromEnum();
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };

    public S32DSMMUViewControl() {
        this.registerListenerForInput();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id"));
        tbm.add(this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id"));
        tbm.add(this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id"));
    }

    protected void createActions() {
        S32DSMMUSelectElAction selectElAction = new S32DSMMUSelectElAction((IDebugView)this);
        this.setAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id", (IAction)selectElAction);
        this.getViewSite().getActionBars().setGlobalActionHandler("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id", (IAction)selectElAction);
        S32DSMMUPauseViewAction suspendViewAction = new S32DSMMUPauseViewAction(this);
        this.setAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id", (IAction)suspendViewAction);
        this.getViewSite().getActionBars().setGlobalActionHandler("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id", (IAction)suspendViewAction);
        S32DSMMUTranslateAddressAction translateViewAction = new S32DSMMUTranslateAddressAction((IDebugView)this);
        this.setAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id", (IAction)translateViewAction);
        this.getViewSite().getActionBars().setGlobalActionHandler("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id", (IAction)translateViewAction);
        selectElAction.setEnabled(false);
        suspendViewAction.setEnabled(false);
        translateViewAction.setEnabled(false);
    }

    protected Viewer createViewer(Composite composite) {
        this.viewer = new S32DSMMUTableViewer(composite, this);
        this.progressBarViewer = new S32DSMMUContentViewer(composite);
        return this.viewer;
    }

    protected String getHelpContextId() {
        return "com.nxp.s32ds.debug.ide.s32debugger.mmu.uiS32DSMMUViewControl.help.id";
    }

    protected void becomesHidden() {
        if (!this.suspend.get()) {
            this.currentInput = null;
        }
        super.becomesHidden();
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void becomesVisible() {
        S32DSMMUViewControl s32DSMMUViewControl = this;
        synchronized (s32DSMMUViewControl) {
            if (this.currentInput != null) {
                return;
            }
        }
        this.requestInput();
        super.becomesVisible();
    }

    @Override
    @ThreadSafe
    public synchronized void setInput(DsfSession session, S32DSMMUInfo mmu) {
        if (!this.saveState(session, mmu)) {
            return;
        }
        if (this.currentInput == null) {
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id").setEnabled(false);
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id").setEnabled(false);
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id").setEnabled(false);
        } else if (!this.suspend.get()) {
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id").setEnabled(true);
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id").setEnabled(true);
            this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id").setEnabled(true);
        }
        if (!this.viewer.getControl().isDisposed()) {
            this.asyncExec(() -> {
                this.showMessage("");
                this.getPageBook().showPage(this.viewer.getControl());
                this.showViewer();
                this.viewer.setInput(this.currentInput);
            });
        }
    }

    private boolean saveState(DsfSession session, S32DSMMUInfo mmu) {
        if (this.suspend.get() && session.isActive()) {
            return false;
        }
        if (session == null) {
            return false;
        }
        if (mmu != null && !mmu.getStatus().isOK()) {
            this.session2lastError.put(session.getId(), mmu.getStatus().getMessage());
        }
        if (this.currentDSfSession != null && session != this.currentDSfSession) {
            return false;
        }
        if (this.session2lastError.containsKey(session.getId())) {
            if (!session.isActive()) {
                this.session2lastError.remove(session.getId());
                Display.getDefault().asyncExec(() -> {
                    this.viewer.setInput(null);
                    this.showMessage("");
                    this.showViewer();
                });
            } else {
                Display.getDefault().asyncExec(() -> {
                    this.showMessage(this.session2lastError.get(session.getId()));
                    this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id").setEnabled(false);
                    this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id").setEnabled(false);
                    this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id").setEnabled(false);
                });
            }
            this.currentInput = null;
            if (DsfSession.getActiveSessions().length == 0) {
                this.suspend.set(false);
                this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id").setChecked(false);
                return true;
            }
            return false;
        }
        if (mmu == null) {
            this.currentInput = null;
            if (DsfSession.getActiveSessions().length == 0) {
                this.suspend.set(false);
                this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUPauseViewAction.id").setChecked(false);
            }
            return true;
        }
        if (this.currentInput == mmu.getMmu()) {
            return false;
        }
        if (this.currentInput == mmu.getMmu()) {
            return false;
        }
        if (this.currentInput != null && this.currentInput.equals(mmu.getMmu())) {
            return false;
        }
        this.currentInput = mmu.getMmu();
        return true;
    }

    public void dispose() {
        S32DSMMUInputProvider.getInstance().removeInputListeren(this);
        super.dispose();
    }

    public void registerListenerForInput() {
        S32DSMMUInputProvider.getInstance().registerInputListener(this);
    }

    public void removeListenerForInput() {
        S32DSMMUInputProvider.getInstance().removeInputListeren(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugContextChanged(DebugContextEvent event) {
        S32DSMMUViewControl s32DSMMUViewControl = this;
        synchronized (s32DSMMUViewControl) {
            if (!this.isVisible() || !this.isAvailable()) {
                return;
            }
        }
        ISelection selection = event.getContext();
        if (!(selection instanceof TreeSelection)) {
            return;
        }
        ILaunch currentLaunch = null;
        if (this.currentDSfSession != null) {
            currentLaunch = (ILaunch)this.currentDSfSession.getModelAdapter(ILaunch.class);
        }
        if (selection.isEmpty() || !(selection instanceof TreeSelection)) {
            return;
        }
        ILaunch selectedLaunch = (ILaunch)((IAdaptable)((TreeSelection)selection).getFirstElement()).getAdapter(ILaunch.class);
        if (!(selectedLaunch instanceof GdbLaunch)) {
            return;
        }
        if ((event.getFlags() & 1) > 0 && currentLaunch != selectedLaunch) {
            this.currentDSfSession = ((GdbLaunch)selectedLaunch).getSession();
            this.requestInput();
        }
    }

    private void requestInput() {
        if (this.suspend.get()) {
            return;
        }
        String sessionsId = S32DSMMUUtils.getCurrentSessionId((IDebugView)this);
        if (sessionsId != null && !sessionsId.isEmpty()) {
            S32DSMMUSelectElAction action = (S32DSMMUSelectElAction)this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id");
            this.currentDSfSession = DsfSession.getSession((String)sessionsId);
            S32DSMMUInputProvider.getInstance().requestMmuInput(this.currentDSfSession, this, action.getEl());
        } else {
            this.setInput(this.currentDSfSession, null);
        }
    }

    public void refresh() {
        this.requestInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendView() {
        this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id").setEnabled(false);
        this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id").setEnabled(false);
        this.suspend.set(true);
        S32DSMMUViewControl s32DSMMUViewControl = this;
        synchronized (s32DSMMUViewControl) {
            this.currentDSfSession = null;
            this.currentInput = this.dummyMMU;
        }
        Display.getDefault().asyncExec(() -> {
            this.showMessage("");
            this.showViewer();
            this.viewer.setInput(null);
        });
    }

    public void resumeView() {
        this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUTranslateAddressAction.id").setEnabled(true);
        this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id").setEnabled(true);
        this.suspend.set(false);
        this.requestInput();
    }

    @Override
    public ExceptionLevelType getNeedEl() {
        return ((S32DSMMUSelectElAction)this.getAction("com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUSelectElAction.id")).getEl();
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)new Action(S32DSMMUMessages.S32DSMMUViewControl_Resize_column_to_fit_content){

            public void run() {
                S32DSMMUViewControl.this.viewer.resizeToFitContent();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(DsfSession session, S32DSMMUInputListener.S32DSMMUEventType event) {
        S32DSMMUViewControl s32DSMMUViewControl = this;
        synchronized (s32DSMMUViewControl) {
            if (this.currentDSfSession != session) {
                return;
            }
        }
        switch (event) {
            case FETCH_INPUT_START: {
                this.asyncExec(() -> this.getPageBook().showPage(this.progressBarViewer.getControl()));
                break;
            }
            case FETCH_INPUT_ENDED_WITHOUT_INPUT: {
                this.asyncExec(() -> {
                    this.getPageBook().showPage(this.viewer.getControl());
                    this.showViewer();
                });
                break;
            }
            default: {
                S32DSMMUActivator.getInstance().logError(String.format(S32DSMMUMessages.S32DSMMUError_Unknown_event_type, this.getClass().toString()));
            }
        }
    }

    @Override
    public boolean isNeedMmu() {
        return !this.suspend.get();
    }
}

