/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view;

import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUArmv8Entry;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view.S32DSMMUContentProvider;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.view.S32DSMMUViewControl;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public class S32DSMMUTableViewer
extends TableViewer {
    private S32DSMMUViewControl s32dsmmuViewControl;
    private TableViewerColumn virtualStartColumn;
    private TableViewerColumn physicalStartColumn;
    private TableViewerColumn sizeColumn;
    private TableViewerColumn secureColumn;
    private TableViewerColumn globalColumn;
    private TableViewerColumn accessPermisionsColumn;
    private TableViewerColumn memoryAttributesColumn;

    public S32DSMMUTableViewer(Composite composite, S32DSMMUViewControl parent) {
        this(composite);
        this.s32dsmmuViewControl = parent;
    }

    public S32DSMMUTableViewer(Composite parent) {
        super(parent, 0x10000000);
        this.setContentProvider((IContentProvider)new S32DSMMUContentProvider(this));
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.getTable().setBackground(S32DSMMUActivator.S32DSMMU_TABLE_BLUE_COLOR);
        this.setItemCount(0);
        this.createColumns();
    }

    private void createColumns() {
        this.virtualStartColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.virtualStartColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Virtual_start_column_title);
        this.virtualStartColumn.setLabelProvider(this.createCellLabelProviderForVirtualStartColumn(this.virtualStartColumn));
        this.virtualStartColumn.getColumn().pack();
        this.physicalStartColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.physicalStartColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Physical_start_column_title);
        this.physicalStartColumn.setLabelProvider(this.createCellLabelProviderForPhysicalStartColumn(this.physicalStartColumn));
        this.physicalStartColumn.getColumn().pack();
        this.sizeColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.sizeColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Size_column);
        this.sizeColumn.setLabelProvider(this.createCellLabelProviderForSizeColumn(this.sizeColumn));
        this.sizeColumn.getColumn().pack();
        this.secureColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.secureColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Secure_column);
        this.secureColumn.setLabelProvider(this.createCellLabelProviderForSecureColumn(this.secureColumn));
        this.secureColumn.getColumn().pack();
        this.globalColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.globalColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Global_column);
        this.globalColumn.setLabelProvider(this.createCellLabelProviderForGlobalColumn(this.globalColumn));
        this.globalColumn.getColumn().pack();
        this.accessPermisionsColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.accessPermisionsColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Access_permissions);
        this.accessPermisionsColumn.setLabelProvider(this.createCellLabelProviderForAccessPermisionsColumn(this.accessPermisionsColumn));
        this.accessPermisionsColumn.getColumn().pack();
        this.memoryAttributesColumn = new TableViewerColumn((TableViewer)this, 16384);
        this.memoryAttributesColumn.getColumn().setText(S32DSMMUMessages.S32DSMMUTableViewer_Memory_attributes);
        this.memoryAttributesColumn.setLabelProvider(this.createCellLabelProviderForMemoryAttributesColumn(this.memoryAttributesColumn));
        this.memoryAttributesColumn.getColumn().pack();
    }

    private CellLabelProvider createCellLabelProviderForMemoryAttributesColumn(TableViewerColumn memoryAttributesColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setText(attributes.getMemoryAttribute());
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForAccessPermisionsColumn(TableViewerColumn accessPermisionsColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setText(attributes.getAccessPermisions());
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForGlobalColumn(TableViewerColumn globalColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setImage(attributes.getGlobal().equals("Global") ? S32DSMMUActivator.S32DSMMU_CHECK_IMAGE : S32DSMMUActivator.S32DSMMU_UNCHECK_IMAGE);
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForSecureColumn(TableViewerColumn secureColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setImage(attributes.getSecure().equals("Secure") ? S32DSMMUActivator.S32DSMMU_CHECK_IMAGE : S32DSMMUActivator.S32DSMMU_UNCHECK_IMAGE);
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForSizeColumn(TableViewerColumn sizeColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setText(String.valueOf(S32DSMMUMessages.S32DSMMU_HEX_PREFIX) + attributes.getSize().toString(16));
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForPhysicalStartColumn(TableViewerColumn physicalStartColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setText(String.valueOf(S32DSMMUMessages.S32DSMMU_HEX_PREFIX) + attributes.getPhysicalAddress().toString(16));
                }
            }
        };
    }

    private CellLabelProvider createCellLabelProviderForVirtualStartColumn(TableViewerColumn virtualStartColumn) {
        return new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof S32DSMMUArmv8Entry) {
                    S32DSMMUArmv8Entry attributes = (S32DSMMUArmv8Entry)element;
                    cell.setText(String.valueOf(S32DSMMUMessages.S32DSMMU_HEX_PREFIX) + attributes.getVirtualAddress().toString(16));
                }
            }
        };
    }

    public void refresh() {
        if (this.s32dsmmuViewControl != null) {
            this.s32dsmmuViewControl.refresh();
        } else {
            super.refresh();
        }
    }

    public void resizeToFitContent() {
        this.virtualStartColumn.getColumn().pack();
        this.physicalStartColumn.getColumn().pack();
        this.sizeColumn.getColumn().pack();
        this.secureColumn.getColumn().pack();
        this.globalColumn.getColumn().pack();
        this.accessPermisionsColumn.getColumn().pack();
        this.memoryAttributesColumn.getColumn().pack();
    }
}

