/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.sessions.listeners;

import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.ExceptionLevelType;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.gdb.S32DSMMUService;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUInfo;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUInputListener;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUTranslateAddressInfo;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public class S32DSMMUInputProvider
implements DsfSession.SessionStartedListener,
DsfSession.SessionEndedListener {
    private final Map<String, AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker>> sessionId2DsfServiceTracker = new HashMap<String, AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker>>();
    private final List<S32DSMMUInputListener> inputListeners;
    private static S32DSMMUInputProvider instance = null;
    private final List<String> sessionsIdBlackList = new CopyOnWriteArrayList<String>();

    private S32DSMMUInputProvider() {
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this);
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
        this.inputListeners = new ArrayList<S32DSMMUInputListener>();
        DsfSession[] activeSessions = DsfSession.getActiveSessions();
        if (activeSessions.length != 0) {
            this.registerListenerForAllExistingSessions(activeSessions);
        }
    }

    private void registerListenerForAllExistingSessions(DsfSession[] sessions) {
        DsfSession[] dsfSessionArray = sessions;
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            DsfSession session = dsfSessionArray[n2];
            this.registerServiceEventListener(session);
            ++n2;
        }
    }

    private void registerServiceEventListener(DsfSession session) {
        session.addServiceEventListener((Object)this, null);
        DsfServicesTracker tracker = new DsfServicesTracker(S32DSMMUActivator.getBundleContext(), session.getId());
        this.sessionId2DsfServiceTracker.put(session.getId(), new AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker>(session, tracker));
    }

    public static S32DSMMUInputProvider getInstance() {
        if (instance == null) {
            instance = new S32DSMMUInputProvider();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    @DsfServiceEventHandler
    public void handleSuspendEvent(final IRunControl.ISuspendedDMEvent event) {
        List listeners = this.inputListeners.stream().filter(S32DSMMUInputListener::isNeedMmu).collect(Collectors.toList());
        if (listeners.isEmpty() || this.sessionsIdBlackList.contains(((IRunControl.IExecutionDMContext)event.getDMContext()).getSessionId())) {
            this.updateInputForListeners(DsfSession.getSession((String)((IRunControl.IExecutionDMContext)event.getDMContext()).getSessionId()), null, ExceptionLevelType.UNKNOWN_EXCEPTION_LEVEL);
            return;
        }
        List elList = listeners.stream().map(S32DSMMUInputListener::getNeedEl).distinct().collect(Collectors.toList());
        final AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker> entry = this.sessionId2DsfServiceTracker.get(((IRunControl.IExecutionDMContext)event.getDMContext()).getSessionId());
        if (entry == null) {
            return;
        }
        this.notifyListenersFetch(entry.getKey(), S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_START);
        DsfServicesTracker tracker = entry.getValue();
        S32DSMMUService mmuService = (S32DSMMUService)tracker.getService(S32DSMMUService.class);
        if (mmuService != null) {
            for (final ExceptionLevelType el : elList) {
                mmuService.getMmuInfo(new DataRequestMonitor<S32DSMMUInfo>((Executor)entry.getKey().getExecutor(), null){

                    protected void handleSuccess() {
                        S32DSMMUInfo info = (S32DSMMUInfo)((Object)this.getData());
                        if (!info.getStatus().isOK()) {
                            S32DSMMUInputProvider.this.sessionsIdBlackList.add(((IRunControl.IExecutionDMContext)event.getDMContext()).getSessionId());
                            S32DSMMUInputProvider.this.notifyListenersFetch((DsfSession)entry.getKey(), S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
                        }
                        S32DSMMUInputProvider.this.updateInputForListeners((DsfSession)entry.getKey(), info, el);
                    }

                    protected void handleErrorOrWarning() {
                        S32DSMMUInputProvider.this.sessionsIdBlackList.add(((DsfSession)entry.getKey()).getId());
                        S32DSMMUInputProvider.this.notifyListenersFetch((DsfSession)entry.getKey(), S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
                        S32DSMMUInputProvider.this.updateInputForListeners((DsfSession)entry.getKey(), (S32DSMMUInfo)((Object)this.getData()), el);
                    }
                }, el.getValueFromEnum());
            }
            return;
        }
        this.notifyListenersFetch(entry.getKey(), S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
    }

    public void requestMmuInput(final DsfSession session, final S32DSMMUInputListener listener, ExceptionLevelType el) {
        final AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker> entry = this.sessionId2DsfServiceTracker.get(session.getId());
        if (entry == null || this.sessionsIdBlackList.contains(session.getId())) {
            this.updateInputForListeners(session, null, ExceptionLevelType.UNKNOWN_EXCEPTION_LEVEL);
            return;
        }
        this.notifyListenersFetch(session, S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_START);
        DsfServicesTracker tracker = entry.getValue();
        S32DSMMUService mmuService = (S32DSMMUService)tracker.getService(S32DSMMUService.class);
        if (mmuService != null) {
            mmuService.getMmuInfo(new DataRequestMonitor<S32DSMMUInfo>((Executor)session.getExecutor(), null){

                protected void handleSuccess() {
                    S32DSMMUInfo info = (S32DSMMUInfo)((Object)this.getData());
                    if (!info.getStatus().isOK()) {
                        S32DSMMUInputProvider.this.sessionsIdBlackList.add(session.getId());
                        listener.handleEvent(session, S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
                    }
                    listener.setInput(session, info);
                    super.handleSuccess();
                }

                protected void handleErrorOrWarning() {
                    S32DSMMUInputProvider.this.sessionsIdBlackList.add(session.getId());
                    listener.handleEvent(session, S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
                    listener.setInput((DsfSession)entry.getKey(), (S32DSMMUInfo)((Object)this.getData()));
                    super.handleErrorOrWarning();
                }
            }, el.getValueFromEnum());
            return;
        }
        this.notifyListenersFetch(session, S32DSMMUInputListener.S32DSMMUEventType.FETCH_INPUT_ENDED_WITHOUT_INPUT);
    }

    public void sessionStarted(DsfSession session) {
        this.registerServiceEventListener(session);
    }

    public void sessionEnded(DsfSession session) {
        AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker> entry = this.sessionId2DsfServiceTracker.get(session.getId());
        if (entry != null) {
            entry.getValue().dispose();
            this.sessionId2DsfServiceTracker.remove(session.getId());
            this.sessionsIdBlackList.remove(session.getId());
            this.updateInputForListeners(session, null, ExceptionLevelType.UNKNOWN_EXCEPTION_LEVEL);
        }
    }

    private void notifyListenersFetch(DsfSession session, S32DSMMUInputListener.S32DSMMUEventType event) {
        for (S32DSMMUInputListener inputListener : this.inputListeners) {
            inputListener.handleEvent(session, event);
        }
    }

    private void updateInputForListeners(DsfSession session, S32DSMMUInfo input, ExceptionLevelType el) {
        for (S32DSMMUInputListener listener : this.inputListeners) {
            if (listener.getNeedEl() != el && el != ExceptionLevelType.UNKNOWN_EXCEPTION_LEVEL) continue;
            listener.setInput(session, input);
        }
    }

    public S32DSMMUTranslateAddressInfo translateVirtualAddress(DsfSession session, final BigInteger physicalAddress, final ExceptionLevelType el) {
        S32DSMMUTranslateAddressInfo addressInfo;
        AbstractMap.SimpleEntry<DsfSession, DsfServicesTracker> entry = this.sessionId2DsfServiceTracker.get(session.getId());
        if (entry == null) {
            return null;
        }
        DsfServicesTracker tracker = entry.getValue();
        final S32DSMMUService mmuService = (S32DSMMUService)tracker.getService(S32DSMMUService.class);
        if (mmuService == null) {
            return null;
        }
        Query<S32DSMMUTranslateAddressInfo> query = new Query<S32DSMMUTranslateAddressInfo>(){

            protected void execute(DataRequestMonitor<S32DSMMUTranslateAddressInfo> rm) {
                mmuService.getPhysicalAddress(physicalAddress, rm, el.getValueFromEnum());
            }
        };
        query.run();
        try {
            addressInfo = (S32DSMMUTranslateAddressInfo)((Object)query.get(2L, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return null;
        }
        return addressInfo;
    }

    public void registerInputListener(S32DSMMUInputListener listener) {
        this.inputListeners.add(listener);
    }

    public void removeInputListeren(S32DSMMUInputListener listener) {
        this.inputListeners.remove(listener);
    }
}

