/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUAddressTranslateArmv8Json;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUAddressTranslateArmv8ListJson;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class S32DSMMUTranslateAddressInfo
extends MIInfo {
    private IStatus status;
    private static final String JSON_END = "}";
    private static final String JSON_START = "{";
    private Pattern mmuPattern = Pattern.compile(".*\"mmu\": .*, \"currentEl\": [0-3].*", 2);
    private S32DSMMUAddressTranslateArmv8Json jsonMmu;
    private S32DSMMUAddressTranslateArmv8Json dummyJsonMmu = new S32DSMMUAddressTranslateArmv8Json(){

        @Override
        public BigInteger getPhysicalAddress() {
            return BigInteger.valueOf(-1L);
        }
    };

    public S32DSMMUTranslateAddressInfo(MIOutput record) {
        super(record);
        this.parseOutput(record);
    }

    private void parseOutput(MIOutput record) {
        if (this.isError()) {
            this.jsonMmu = this.dummyJsonMmu;
            this.status = new Status(4, ((Object)((Object)this)).getClass(), this.getErrorMsg());
            return;
        }
        this.jsonMmu = null;
        MIOOBRecord[] results = record.getMIOOBRecords();
        MIConsoleStreamOutput[] streams = (MIConsoleStreamOutput[])Arrays.stream(results).filter(console -> console instanceof MIConsoleStreamOutput && this.mmuPattern.matcher(((MIConsoleStreamOutput)console).getCString()).matches()).toArray(MIConsoleStreamOutput[]::new);
        if (streams.length != 1) {
            S32DSMMUActivator.getInstance().logError(S32DSMMUMessages.S32DSMMUError_Core_is_not_supported);
            this.jsonMmu = this.dummyJsonMmu;
            this.status = new Status(4, ((Object)((Object)this)).getClass(), S32DSMMUMessages.S32DSMMUError_Too_many_responses);
            return;
        }
        MIConsoleStreamOutput output = streams[0];
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        MIConsoleStreamOutput value = streams[0];
        int startIdx = value.getCString().indexOf(JSON_START);
        int endIdx = value.getCString().lastIndexOf(JSON_END) + 1;
        if (startIdx == -1 || endIdx == 0 || startIdx > endIdx) {
            this.status = Status.error((String)S32DSMMUMessages.S32DSMMUError_Core_is_not_supported);
            S32DSMMUActivator.getInstance().logError(S32DSMMUMessages.S32DSMMUError_Cannot_find_command_output);
            return;
        }
        String json = output.getCString().substring(startIdx, endIdx);
        S32DSMMUAddressTranslateArmv8ListJson res = (S32DSMMUAddressTranslateArmv8ListJson)gson.fromJson(json, S32DSMMUAddressTranslateArmv8ListJson.class);
        if (res.getMmuEntry().size() != 1) {
            S32DSMMUActivator.getInstance().logError(S32DSMMUMessages.S32DSMMUError_Too_many_responses);
            this.jsonMmu = this.dummyJsonMmu;
            this.status = new Status(4, ((Object)((Object)this)).getClass(), S32DSMMUMessages.S32DSMMUError_Too_many_responses);
            return;
        }
        this.status = Status.OK_STATUS;
        this.jsonMmu = res.getMmuEntry().get(0);
    }

    public IStatus getStatus() {
        return this.status;
    }

    public S32DSMMUAddressTranslateArmv8Json getMMMUEntry() {
        return this.jsonMmu;
    }
}

