/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUArmv8Json;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUInfo;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class S32DSMMUInfoArmv8
extends S32DSMMUInfo {
    private S32DSMMUArmv8Json mmu;
    private IStatus status;
    private static final String JSON_END = "}";
    private static final String JSON_START = "{";
    private static final Pattern mmuPattern = Pattern.compile(".*\"mmu\": .*, \"currentEl\": [0-3].*", 2);

    public S32DSMMUInfoArmv8(MIOutput record) {
        super(record);
        this.parseOutput(record);
    }

    private void parseOutput(MIOutput output) {
        if (this.isError()) {
            String errorMessage = this.getErrorMsg().equals(S32DSMMUMessages.S32DSMMUError_Undefined_MI_command_mmu) ? S32DSMMUMessages.S32DSMMUError_Selected_debugger_is_not_supported : this.getErrorMsg();
            this.status = Status.error((String)errorMessage);
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        MIOOBRecord[] results = output.getMIOOBRecords();
        MIConsoleStreamOutput[] streams = (MIConsoleStreamOutput[])Arrays.stream(results).filter(console -> console instanceof MIConsoleStreamOutput && mmuPattern.matcher(((MIConsoleStreamOutput)console).getCString()).matches()).toArray(MIConsoleStreamOutput[]::new);
        this.status = Status.OK_STATUS;
        if (streams.length != 1) {
            this.status = Status.error((String)S32DSMMUMessages.S32DSMMUError_Core_is_not_supported);
            S32DSMMUActivator.getInstance().logError(S32DSMMUMessages.S32DSMMUError_Cannot_find_command_output);
            return;
        }
        MIConsoleStreamOutput value = streams[0];
        int startIdx = value.getCString().indexOf(JSON_START);
        int endIdx = value.getCString().lastIndexOf(JSON_END) + 1;
        if (startIdx == -1 || endIdx == 0 || startIdx > endIdx) {
            this.status = Status.error((String)S32DSMMUMessages.S32DSMMUError_Core_is_not_supported);
            S32DSMMUActivator.getInstance().logError(S32DSMMUMessages.S32DSMMUError_Cannot_find_command_output);
            return;
        }
        String mmuValue = value.getCString().substring(startIdx, endIdx);
        try {
            this.mmu = (S32DSMMUArmv8Json)gson.fromJson(mmuValue, S32DSMMUArmv8Json.class);
        }
        catch (JsonParseException jsonParseException) {
            this.status = Status.OK_STATUS;
        }
    }

    @Override
    public S32DSMMUArmv8Json getMmu() {
        return this.mmu;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }
}

