/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model;

import com.google.gson.annotations.SerializedName;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUArmv8Entry;
import java.math.BigInteger;

public class S32DSMMUArmv8EntryJson
implements S32DSMMUArmv8Entry {
    @SerializedName(value="mem_attr")
    private String memoryAttribute;
    @SerializedName(value="physical_start")
    private String physicalStart;
    @SerializedName(value="secure")
    private String secure;
    @SerializedName(value="access_permissions")
    private String accessPermisions;
    @SerializedName(value="global")
    private String global;
    @SerializedName(value="virtual_start")
    private String virtualStart;
    @SerializedName(value="size")
    private String size;

    @Override
    public BigInteger getVirtualAddress() {
        return new BigInteger(this.trimHexPrefix(this.virtualStart), 16);
    }

    @Override
    public BigInteger getSize() {
        return new BigInteger(this.trimHexPrefix(this.size), 16);
    }

    @Override
    public String getMemoryAttribute() {
        return this.memoryAttribute;
    }

    @Override
    public BigInteger getPhysicalAddress() {
        return new BigInteger(this.trimHexPrefix(this.physicalStart), 16);
    }

    @Override
    public String getSecure() {
        return this.secure;
    }

    @Override
    public String getGlobal() {
        return this.global;
    }

    @Override
    public String getAccessPermisions() {
        return this.accessPermisions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S32DSMMUArmv8EntryJson)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        S32DSMMUArmv8EntryJson entry = (S32DSMMUArmv8EntryJson)obj;
        return this.memoryAttribute.equals(entry.memoryAttribute) && this.physicalStart.equals(entry.physicalStart) && this.virtualStart.equals(entry.virtualStart) && this.accessPermisions.equals(entry.accessPermisions) && this.secure.equals(entry.secure) && this.global.equals(entry.global) && this.size.equals(entry.size);
    }

    private String trimHexPrefix(String address) {
        if (address.startsWith(S32DSMMUMessages.S32DSMMU_HEX_PREFIX)) {
            address = address.substring(S32DSMMUMessages.S32DSMMU_HEX_PREFIX.length());
        }
        return address;
    }
}

