/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.actions;

import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.ExceptionLevelType;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUActivator;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUMessages;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.S32DSMMUUtils;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.model.S32DSMMUTranslateAddressInfo;
import com.nxp.s32ds.debug.ide.s32debugger.mmu.ui.sessions.listeners.S32DSMMUInputProvider;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class S32DSMMUTranslateAddressDialog
extends Dialog {
    private static final String HEX_NUMBER_REGEX = "^(0x)?[0-9A-Fa-f]*$";
    private Pattern pattern = Pattern.compile("^(0x)?[0-9A-Fa-f]*$");
    private ExceptionLevelType el = ExceptionLevelType.CURRENT_RUNNING_EXEPTION_LEVEL;
    private IDebugView view;
    private Clipboard clipboard;

    public S32DSMMUTranslateAddressDialog(Shell parent, ExceptionLevelType el, IDebugView view) {
        super(parent);
        this.el = el;
        this.view = view;
        this.clipboard = new Clipboard(Display.getCurrent());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)new GridLayout(3, false))).create((Widget)parent);
        WidgetFactory.label((int)0).text(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Exception_level).create((Widget)container);
        final CCombo cCombo = new CCombo(container, 2048);
        cCombo.add(ExceptionLevelType.CURRENT_RUNNING_EXEPTION_LEVEL.getUserFriendlyName());
        cCombo.add(ExceptionLevelType.EXCEPTION_LEVEL_0.getUserFriendlyName());
        cCombo.add(ExceptionLevelType.EXCEPTION_LEVEL_1.getUserFriendlyName());
        cCombo.add(ExceptionLevelType.EXCEPTION_LEVEL_2.getUserFriendlyName());
        cCombo.add(ExceptionLevelType.EXCEPTION_LEVEL_3.getUserFriendlyName());
        cCombo.setEditable(false);
        cCombo.select(this.el.getValueFromEnum() + 1);
        cCombo.setLayoutData((Object)GridDataFactory.create((int)0).span(2, 1).align(4, 4).grab(true, true).create());
        cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DSMMUTranslateAddressDialog.this.el = ExceptionLevelType.getEnumFromValue(cCombo.getSelectionIndex() - 1);
            }
        });
        WidgetFactory.label((int)0).text(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Virtual_address).create((Widget)container);
        final Text virtualAddress = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)GridDataFactory.create((int)0).grab(true, true).align(4, 4).create())).create((Widget)container);
        virtualAddress.addVerifyListener(event -> {
            if (!this.pattern.matcher(String.valueOf(virtualAddress.getText()) + event.text).matches()) {
                event.doit = false;
            }
        });
        Button button = null;
        button = (Button)((ButtonFactory)WidgetFactory.button((int)8).tooltip(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Translate_address)).image(S32DSMMUActivator.S32DSMMU_TRANSLATE_BUTTON_IMAGE).create((Widget)container);
        WidgetFactory.label((int)0).text(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Physical_address).create((Widget)container);
        final Text physicalAddress = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)GridDataFactory.create((int)0).grab(true, true).align(4, 4).create())).create((Widget)container);
        physicalAddress.setEditable(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sessionId = S32DSMMUUtils.getCurrentSessionId(S32DSMMUTranslateAddressDialog.this.view);
                if (sessionId == null) {
                    return;
                }
                String address = S32DSMMUTranslateAddressDialog.this.trimHexPrefix(virtualAddress.getText());
                if (address.isEmpty() || !S32DSMMUTranslateAddressDialog.this.isHex(address)) {
                    return;
                }
                S32DSMMUTranslateAddressInfo phyAddress = S32DSMMUInputProvider.getInstance().translateVirtualAddress(DsfSession.getSession((String)sessionId), new BigInteger(address, 16), S32DSMMUTranslateAddressDialog.this.el);
                if (phyAddress == null) {
                    physicalAddress.setText(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Address_cannot_be_translated);
                    return;
                }
                if (!phyAddress.getStatus().isOK()) {
                    String message = phyAddress.getStatus().getMessage();
                    if (message.endsWith("\\n")) {
                        message = message.substring(0, message.length() - 2);
                    }
                    physicalAddress.setText(message);
                    return;
                }
                physicalAddress.setText(String.valueOf(S32DSMMUMessages.S32DSMMU_HEX_PREFIX) + phyAddress.getMMMUEntry().getPhysicalAddress().toString(16));
            }
        });
        ((ButtonFactory)WidgetFactory.button((int)8).tooltip(S32DSMMUMessages.S32DSMMUTranslateAddressDialog_Copy_to_clipboard)).image(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY")).onSelect(event -> this.clipboard.setContents(new Object[]{physicalAddress.getText()}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()})).create((Widget)container);
        return container;
    }

    private String trimHexPrefix(String address) {
        return address.startsWith(S32DSMMUMessages.S32DSMMU_HEX_PREFIX) ? address.substring(S32DSMMUMessages.S32DSMMU_HEX_PREFIX.length()) : address;
    }

    public boolean close() {
        if (!this.clipboard.isDisposed()) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    private boolean isHex(String number) {
        try {
            Integer.parseInt(number, 16);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(S32DSMMUMessages.S32DSMMUTranslateAddressAction_Action_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

