/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.mcu;

import com.nxp.swtools.common.uct.mcu.McuErrorParseStatus;
import com.nxp.swtools.common.uct.mcu.UctToolModelFile;
import com.nxp.swtools.common.uct.svd.utils.ContentProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.gtm.model.mcu.GtmMcu;
import com.nxp.swtools.gtm.model.mcu.GtmModelFile;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmRegister;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmModuleXmlConfiguration;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlConfiguration;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.simpleframework.xml.core.Persister;

public class McuFactory {
    private static final Logger LOGGER = LogManager.getLogger(McuFactory.class);
    private static final String GTM_MODEL_FILE = "gtm_model.xml";

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable IGtmMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig, McuErrorParseStatus mcuErrorParseStatus) {
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        String sdkVersion = mcuSelection.getSdkVersion();
        String mcuName = mcuSelection.getMcu();
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcuName, (String)sdkVersion, (ISupportedDerivativesForSwTools)supportedDerivatives);
        ArrayList<ProcessorCore> cores = coresInfo == null ? new ArrayList<ProcessorCore>() : coresInfo.cores;
        IProcessorMasterToolInfo masterToolInfo = supportedDerivatives.getProcessorMasterToolInfo(mcuName, sdkVersion);
        assert (masterToolInfo != null);
        String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcuSelection, (String)"gtm_model");
        if (gtmModelFolder.isEmpty()) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot load GTM configuration for: " + mcuSelection);
            }
            mcuErrorParseStatus.setErrorParseStatus(false);
            return null;
        }
        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcuName, sdkVersion, "GTM");
        String gtmModelPath = String.valueOf(dataDir) + File.separator + gtmModelFolder;
        File gtmModelFile = new File(String.valueOf(gtmModelPath) + File.separator + GTM_MODEL_FILE);
        if (!gtmModelFile.exists()) {
            String gtmConfigPath = String.valueOf(gtmModelPath) + File.separator + mcuName + ".xml";
            GtmXmlConfiguration gtmConfig = McuFactory.getGtmXmlConfig(gtmConfigPath);
            if (gtmConfig != null) {
                GtmStructSetting gtmLayoutContent = GtmUtils.getGtmLayoutContent(gtmConfig);
                GtmMcu mcu = new GtmMcu(mcuSelection, cores, masterToolInfo, gtmConfig, gtmLayoutContent);
                mcu.getAllGuiComponentSettings().addAll(GtmUtils.getAllUIComponentsSettings(gtmLayoutContent));
                GtmUtils.checkAllComponentsConstraints(gtmConfig, mcu);
                Map<String, GtmRegister> registers = GtmUtils.getGtmRegistersFromDB(supportedDerivatives, mcuSelection, cores, gtmConfig);
                mcu.getGtmRegisters().putAll(registers);
                return mcu;
            }
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot read the xml file for: " + mcuSelection);
            }
            mcuErrorParseStatus.setErrorParseStatus(true);
            return null;
        }
        try {
            Throwable gtmConfigPath = null;
            Object var14_18 = null;
            try (InputStream gtmModelFileInStr = UtilsDecryption.getFileInputStream((File)gtmModelFile);){
                String svdRegisterRelPath;
                GtmModelFile gtmFile = McuFactory.loadGtmModelFile(gtmModelFileInStr);
                if (gtmFile == null) {
                    if (SWToolsProperties.isVerificationOn()) {
                        LOGGER.severe("Cannot read the xml file for: " + mcuSelection);
                    }
                    mcuErrorParseStatus.setErrorParseStatus(true);
                    return null;
                }
                String gtmConfigPath2 = McuFactory.getFilePathByName(gtmFile, "gtm_config");
                File gtmDataModelFile = new File(gtmConfigPath2);
                if (!gtmDataModelFile.isAbsolute()) {
                    gtmDataModelFile = new File(String.valueOf(gtmModelPath) + File.separator + gtmConfigPath2);
                }
                if (!gtmDataModelFile.exists()) {
                    if (SWToolsProperties.isVerificationOn()) {
                        LOGGER.severe("Cannot find the GTM configuration file for: " + mcuSelection);
                    }
                    mcuErrorParseStatus.setErrorParseStatus(true);
                    return null;
                }
                GtmXmlConfiguration gtmConfig = McuFactory.getGtmXmlConfig(UtilsText.safeString((String)gtmDataModelFile.getAbsolutePath()));
                if (gtmConfig == null) {
                    if (SWToolsProperties.isVerificationOn()) {
                        LOGGER.severe("Cannot read the xml file for: " + mcuSelection);
                    }
                    mcuErrorParseStatus.setErrorParseStatus(true);
                    return null;
                }
                List<String> gtmModulesPath = McuFactory.getFilesPathByName(gtmFile, "gtm_module");
                Iterator<String> iterator = gtmModulesPath.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        svdRegisterRelPath = McuFactory.getFilePathByName(gtmFile, "gtm_svd");
                        if (!svdRegisterRelPath.isEmpty()) break;
                        GtmStructSetting gtmLayoutContent = GtmUtils.getGtmLayoutContent(gtmConfig);
                        GtmMcu mcu = new GtmMcu(mcuSelection, cores, masterToolInfo, gtmConfig, gtmLayoutContent);
                        mcu.getAllGuiComponentSettings().addAll(GtmUtils.getAllUIComponentsSettings(gtmLayoutContent));
                        GtmUtils.checkAllComponentsConstraints(gtmConfig, mcu);
                        Map<String, GtmRegister> registers = GtmUtils.getGtmRegistersFromDB(supportedDerivatives, mcuSelection, cores, gtmConfig);
                        mcu.getGtmRegisters().putAll(registers);
                        return mcu;
                    }
                    String gtmModulePath = iterator.next();
                    File moduleDataModelFile = new File(gtmModulePath);
                    if (!moduleDataModelFile.isAbsolute()) {
                        moduleDataModelFile = new File(String.valueOf(gtmModelPath) + File.separator + gtmModulePath);
                    }
                    if (!moduleDataModelFile.exists()) {
                        if (SWToolsProperties.isVerificationOn()) {
                            LOGGER.severe("Cannot find the GTM module configuration file for: " + mcuSelection);
                        }
                        mcuErrorParseStatus.setErrorParseStatus(true);
                        return null;
                    }
                    GtmModuleXmlConfiguration moduleConfig = McuFactory.getGtmModuleXmlConfig(UtilsText.safeString((String)moduleDataModelFile.getAbsolutePath()));
                    if (moduleConfig == null) {
                        if (SWToolsProperties.isVerificationOn()) {
                            LOGGER.severe("Cannot read the xml module file for: " + mcuSelection);
                        }
                        mcuErrorParseStatus.setErrorParseStatus(true);
                        return null;
                    }
                    McuFactory.addModuleComponentsToMainPanel(gtmConfig, moduleConfig);
                }
                File registersFile = new File(svdRegisterRelPath);
                if (!registersFile.isAbsolute()) {
                    registersFile = new File(String.valueOf(gtmModelPath) + File.separator + svdRegisterRelPath);
                }
                if (!registersFile.exists()) {
                    if (SWToolsProperties.isVerificationOn()) {
                        LOGGER.severe("Cannot find the GTM registers file for: " + mcuSelection);
                    }
                    mcuErrorParseStatus.setErrorParseStatus(true);
                    return null;
                }
                String registersFilePath = registersFile.getAbsolutePath();
                ContentProvider.getInstance().parseDocument(UtilsText.safeString((String)registersFilePath), mcuName, sdkVersion);
                @NonNull Map peripherals = ContentProvider.getInstance().getPeripheralsList();
                Map<String, GtmRegister> registers = GtmUtils.getGtmRegisters(peripherals, gtmConfig);
                GtmStructSetting gtmLayoutContent = GtmUtils.getGtmLayoutContent(gtmConfig);
                GtmMcu mcu = new GtmMcu(mcuSelection, cores, masterToolInfo, gtmConfig, gtmLayoutContent);
                mcu.getAllGuiComponentSettings().addAll(GtmUtils.getAllUIComponentsSettings(gtmLayoutContent));
                GtmUtils.checkAllComponentsConstraints(gtmConfig, mcu);
                mcu.getGtmRegisters().putAll(registers);
                return mcu;
            }
            catch (Throwable throwable) {
                if (gtmConfigPath == null) {
                    gtmConfigPath = throwable;
                    throw gtmConfigPath;
                }
                if (gtmConfigPath == throwable) throw gtmConfigPath;
                gtmConfigPath.addSuppressed(throwable);
                throw gtmConfigPath;
            }
        }
        catch (Exception e) {
            mcuErrorParseStatus.setErrorParseStatus(true);
            LOGGER.severe("Cannot load the .xml file with the GTM model" + e.getMessage());
            return null;
        }
    }

    private static @Nullable GtmXmlConfiguration getGtmXmlConfig(String filePath) {
        File gtmConfigFile = new File(filePath);
        if (!gtmConfigFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream gtmConfInStr = UtilsDecryption.getFileInputStream((File)gtmConfigFile);){
                GtmXmlConfiguration gtmConfig = GtmXmlConfiguration.loadGtmXmlConfig(gtmConfInStr);
                if (gtmConfig != null) {
                    return gtmConfig;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Cannot read the GTM config file." + e.getMessage());
        }
        return null;
    }

    private static String getFilePathByName(GtmModelFile gtmModelFile, String name) {
        for (UctToolModelFile gtmFile : gtmModelFile.getFiles()) {
            if (!gtmFile.getName().equals(name)) continue;
            return gtmFile.getPath();
        }
        return "";
    }

    private static @Nullable GtmModelFile loadGtmModelFile(InputStream xmlFile) {
        try {
            Persister serializer = new Persister();
            GtmModelFile config = (GtmModelFile)serializer.read(GtmModelFile.class, xmlFile);
            return config;
        }
        catch (Exception ex) {
            LOGGER.severe("Cannot load the .xml file with the GTM data model" + ex.getMessage());
            return null;
        }
    }

    private static void addModuleComponentsToMainPanel(GtmXmlConfiguration gtmXmlConfig, GtmModuleXmlConfiguration moduleXmlConfig) {
        gtmXmlConfig.getConstraints().getDisableStates().addAll(moduleXmlConfig.getConstraints().getDisableStates());
        gtmXmlConfig.getConstraints().getLimitValues().addAll(moduleXmlConfig.getConstraints().getLimitValues());
        gtmXmlConfig.getConstraints().getVisibleStates().addAll(moduleXmlConfig.getConstraints().getVisibleStates());
        gtmXmlConfig.getConstraints().geValidationRules().addAll(moduleXmlConfig.getConstraints().geValidationRules());
        gtmXmlConfig.getGtmEntities().getXmlInstances().addAll(moduleXmlConfig.getModuleEntities().getXmlInstances());
        GtmStructSetting gtmMainStruct = gtmXmlConfig.getLayoutComponents().getParentLayoutContent().getStructSettingById(moduleXmlConfig.getLayoutComponents().getParentLayoutContent().getId());
        if (gtmMainStruct != null) {
            gtmMainStruct.getStructSettings().addAll(moduleXmlConfig.getLayoutComponents().getParentLayoutContent().getStructSettings());
        }
    }

    private static @Nullable GtmModuleXmlConfiguration getGtmModuleXmlConfig(String filePath) {
        File gtmConfigFile = new File(filePath);
        if (!gtmConfigFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream gtmConfInStr = UtilsDecryption.getFileInputStream((File)gtmConfigFile);){
                GtmModuleXmlConfiguration gtmConfig = GtmModuleXmlConfiguration.loadGtmXmlConfig(gtmConfInStr);
                if (gtmConfig != null) {
                    return gtmConfig;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Cannot read the GTM module config file." + e.getMessage());
        }
        return null;
    }

    private static List<String> getFilesPathByName(GtmModelFile gtmModelFile, String name) {
        ArrayList<String> gtmFilesPath = new ArrayList<String>();
        for (UctToolModelFile gtmFile : gtmModelFile.getFiles()) {
            if (!gtmFile.getName().equals(name)) continue;
            gtmFilesPath.add(gtmFile.getPath());
        }
        return gtmFilesPath;
    }
}

