/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.providers.toolchains;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.internal.migration.Messages;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachData;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.runtime.migration.provider.MigrationProvider;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class ToolchainMigrationProviderBase
implements MigrationProvider {
    public IStatus checkMigrationConditions(String sourceId, String targetId, Map<String, Object> attributes) {
        ProjectContextSettings settings;
        String archetype;
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        IStatus status = this.validateArchetype(project, archetype = (settings = new ProjectContextSettings(project)).getAttributeByKey("com.nxp.s32ds.cle.runtime.component.registry.archetype.id"));
        if (!status.isOK()) {
            return status;
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.ToolchainMigrationProviderBase_the_project_0_does_not_use_managed_build, (Object)project.getName()));
        }
        IManagedProject managedProject = buildInfo.getManagedProject();
        IConfiguration[] configurations = managedProject.getConfigurations();
        Collection attachedSdks = SdkAttachDataHolder.getProjectAttachData((IProject)project);
        if (attachedSdks != null && !attachedSdks.isEmpty()) {
            return CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.ToolchainMigrationProviderBase_the_project_0_has_attached_sdks_1, (Object)project.getName(), (Object)String.join((CharSequence)",", attachedSdks.stream().map(SdkAttachData::getSdkId).collect(Collectors.toList()))));
        }
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration cfg = iConfigurationArray[n2];
            IToolChain toolChain = cfg.getToolChain();
            String toolchainBaseId = toolChain.getBaseId();
            if (toolchainBaseId.startsWith(sourceId)) {
                return Status.OK_STATUS;
            }
            ++n2;
        }
        return CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.ToolchainMigrationProviderBase_the_project_0_does_not_have_toolchain_with_base_id_started_from_1, (Object)project.getName(), (Object)sourceId));
    }

    protected abstract IStatus validateArchetype(IProject var1, String var2);
}

