/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.ISourceImporter;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.core.refactoring.RefactorContext;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameOperation;
import com.nxp.s32ds.ext.ide.internal.ui.Messages;
import com.nxp.s32ds.ext.ide.internal.ui.UiActivator;
import com.nxp.s32ds.ext.ide.ui.refactoring.SourceImporter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractRefactoringJob
extends WorkbenchJob {
    private final ProjectSet originalProjectSet;
    private final String newName;

    public AbstractRefactoringJob(ProjectSet projects, String newName, String jobName) {
        super(jobName);
        this.originalProjectSet = projects;
        this.newName = newName;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            final RefactorContext ctx = new RefactorContext(this.newName, this.originalProjectSet);
            final RenameOperation renameOperation = new RenameOperation((ISourceImporter)new SourceImporter(), ctx);
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor renameMonitor) {
                    if (AbstractRefactoringJob.this.doPreRefactoringActions(ctx).isOK()) {
                        renameOperation.perform(renameMonitor);
                        AbstractRefactoringJob.this.doPostRefactoringActions(renameMonitor);
                    }
                }
            }.run(monitor);
            return Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (InvocationTargetException e) {
            IStatus status = UiActivator.getInstance().createError("Unexpected error during rename", e.getTargetException());
            UiActivator.getInstance().log(status);
            return status;
        }
    }

    protected IStatus doPreRefactoringActions(RefactorContext ctx) {
        List projectsList = ctx.getProjects();
        if (!AbstractRefactoringJob.checkUnsavedEditors(projectsList)) {
            return Status.CANCEL_STATUS;
        }
        AbstractRefactoringJob.closeEditors(projectsList);
        return Status.OK_STATUS;
    }

    protected abstract void doPostRefactoringActions(IProgressMonitor var1);

    private static boolean checkUnsavedEditors(List<IProject> projectsList) {
        IResource[] projectsArray = projectsList.toArray(new IResource[projectsList.size()]);
        if (!IDE.saveAllEditors((IResource[])projectsArray, (boolean)true)) {
            UiActivator.getInstance().logWarning(Messages.warningRenameCanceledDueToUnsavedResources);
            return false;
        }
        return true;
    }

    private static void closeEditors(List<IProject> projectsList) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IResource resource = AbstractRefactoringJob.extractFile(editorReference.getEditorInput());
                if (resource != null && projectsList.contains(resource.getProject())) {
                    page.closeEditor(editorReference.getEditor(true), false);
                }
            }
            catch (PartInitException ex) {
                UiActivator.getInstance().logWarning(Messages.warningCloseEditorsFailed, ex);
            }
            ++n2;
        }
    }

    private static IResource extractFile(IEditorInput input) {
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    public ProjectSet getOriginalProjectSet() {
        return this.originalProjectSet;
    }
}

