/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.ui.internal.imports;

import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportExecMessages;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ImportValidator
implements IValidator {
    private final IBinaryParser binaryParser;
    private Set<String> supportedArchs;
    private static final String ATTR_ID = "type";
    private static final String ATTR_TC = "arch";

    public ImportValidator() {
        String defaultBinaryParserId = ImportValidator.getDefaultBinaryParserId();
        this.binaryParser = this.initBinaryParser(defaultBinaryParserId);
        if (this.binaryParser == null) {
            CdtUiActivator.getInstance().logError("Failed to instance binary parser: " + defaultBinaryParserId);
        }
        this.supportedArchs = new HashSet<String>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(CdtUiActivator.getInstance().getBundleId()) + ".supportedArchs");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ces;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ces = ext.getConfigurationElements();
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    String tcid;
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ATTR_TC.equals(ce.getName()) && (tcid = ce.getAttribute(ATTR_ID)) != null) {
                        this.supportedArchs.add(tcid);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.error((String)("Unexpected input: " + value));
        }
        String path = (String)value;
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return ValidationStatus.error((String)ImportExecMessages.ImportExePage3_does_not_exist);
        }
        if (!this.isBinary(path)) {
            return ValidationStatus.error((String)ImportExecMessages.ImportExePage3_not_an_exe);
        }
        try {
            String cpu = Elf.getAttributes((String)path).getCPU();
            if (!this.supportedArchs.contains(cpu)) {
                return ValidationStatus.error((String)ImportExecMessages.bind((String)ImportExecMessages.ImportExePage3_Unsupported_Architecture, (Object)cpu));
            }
        }
        catch (IOException e) {
            return ValidationStatus.error((String)e.getMessage(), (Throwable)e);
        }
        return ValidationStatus.ok();
    }

    private boolean isBinary(String f) {
        try {
            IBinaryParser.IBinaryFile bin = this.binaryParser.getBinary((IPath)new Path(f));
            if (bin != null && bin.getType() == 2) {
                return true;
            }
        }
        catch (IOException e) {
            CdtUiActivator.getInstance().logError("An exception was thrown during binary file initialization", e);
        }
        return false;
    }

    private IBinaryParser initBinaryParser(String binaryParserId) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point == null) {
            return null;
        }
        ArrayList<IExtension> extensionsInUse = new ArrayList<IExtension>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            if (ImportValidator.isExtensionVisible(ext)) {
                extensionsInUse.add(ext);
            }
            ++n2;
        }
        IExtension[] binaryParserExtensions = extensionsInUse.toArray(new IExtension[extensionsInUse.size()]);
        int j = 0;
        while (j < binaryParserExtensions.length) {
            if (binaryParserExtensions[j].getUniqueIdentifier().equals(binaryParserId)) {
                return this.instantiateBinaryParser(binaryParserExtensions[j]);
            }
            ++j;
        }
        return null;
    }

    public static String getDefaultBinaryParserId() {
        String defaultBinaryParserId = CCorePlugin.getDefault().getPluginPreferences().getDefaultString("binaryparser");
        if (defaultBinaryParserId == null || defaultBinaryParserId.isEmpty()) {
            return "org.eclipse.cdt.core.ELF";
        }
        return defaultBinaryParserId;
    }

    private static boolean isExtensionVisible(IExtension ext) {
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement element = iConfigurationElementArray[0];
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("filter");
            int n = iConfigurationElementArray2.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray2[n2];
                if ("visibility".equals(child.getAttribute("name")) && "private".equals(child.getAttribute("value"))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private IBinaryParser instantiateBinaryParser(IExtension ext) {
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("run");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                try {
                    return (IBinaryParser)child.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    CdtUiActivator.getInstance().logError("An exception was thrown during creation of executable extension", e);
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

