/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.ui.imports;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.core.imports.ImportExportConfigurationUtil;
import com.nxp.s32ds.cle.cdt.ui.imports.ImportExecConfigurationPage;
import com.nxp.s32ds.cle.cdt.ui.imports.ImportExecHardwarePage;
import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportExecMessages;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportValidator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.ValidationUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageOne;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class ImportExecWizard
extends AbstractImportExecutableWizard {
    private static final String PREFIX = "Debug_";
    private static final Set<String> LC_ATTRIBUTS_TO_IMPORT = new HashSet<String>();
    protected ImportExecHardwarePage hardwarePage;
    protected ImportExecConfigurationPage configurationPage;

    static {
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.toolchain.id");
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        LC_ATTRIBUTS_TO_IMPORT.add("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
    }

    public String getWindowTitle() {
        return ImportExecMessages.ImportExeWizard_import_exe_page_wizard_title;
    }

    public String getPageOneTitle() {
        return ImportExecMessages.ImportExeWizard_import_exe_files;
    }

    public String getPageOneDescription() {
        return ImportExecMessages.ImportExeWizard_select_file_or_dir_to_search;
    }

    public String getExecutableListLabel() {
        return ImportExecMessages.ImportExeWizard_exe_files;
    }

    public void setupFileDialog(FileDialog dialog) {
        dialog.setText(ImportExecMessages.ImportExeWizard_choose_exe);
    }

    public boolean supportsConfigurationType(ILaunchConfigurationType type) {
        return true;
    }

    public boolean userSelectsBinaryParser() {
        return false;
    }

    public void addPages() {
        this.hardwarePage = new ImportExecHardwarePage(ImportExecMessages.ImportExeWizard_Hardware_page, this);
        this.addPage((IWizardPage)this.hardwarePage);
        this.configurationPage = new ImportExecConfigurationPage(this);
        this.addPage((IWizardPage)this.configurationPage);
        this.pageOne = new ImportExecutablePageOne(this){

            public String[] getSupportedBinaryParserIds() {
                return new String[]{ImportValidator.getDefaultBinaryParserId()};
            }

            public String[] getSelectedExecutables() {
                String name = ImportExecWizard.this.hardwarePage.getSelectedExecutablePath();
                if (name == null) {
                    return new String[0];
                }
                return new String[]{name};
            }
        };
    }

    public boolean performFinish() {
        ICProject cproject;
        block6: {
            cproject = null;
            if (this.configurationPage.isCreateNewProjectSelected()) {
                IProject project = this.createCProjectForExecutable(this.configurationPage.getNewProjectName());
                cproject = CCorePlugin.getDefault().getCoreModel().create(project);
            } else {
                cproject = this.configurationPage.getExistingCProject();
            }
            if (cproject != null) break block6;
            return false;
        }
        try {
            this.addBinaryParsers(cproject.getProject());
            this.addExecutables(cproject);
            ImportExportConfigurationUtil.addProjectSettings((IProject)cproject.getProject(), (DeviceCoreDescriptor)this.hardwarePage.getDeviceCoreDescriptor(), (String)this.hardwarePage.getDeviceRevision(), (String)this.configurationPage.getToolChainId());
            if (this.configurationPage.isCreateLaunchConfigurationSelected()) {
                this.createLaunchConfiguration(cproject);
            }
        }
        catch (CoreException e) {
            CdtUiActivator.getInstance().logError("An exception was thrown during create project process", e);
        }
        return true;
    }

    public boolean canFinish() {
        return this.hardwarePage.isPageComplete() && this.configurationPage.isPageComplete() && this.getContainer().getCurrentPage().equals((Object)this.configurationPage);
    }

    public void addBinaryParsers(IProject newProject) throws CoreException {
        ICProjectDescription pd = CCorePlugin.getDefault().getProjectDescription(newProject);
        pd.getDefaultSettingConfiguration().create("org.eclipse.cdt.core.BinaryParser", ImportValidator.getDefaultBinaryParserId());
        CCorePlugin.getDefault().setProjectDescription(newProject, pd, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getDefaultProjectName() {
        String name = this.hardwarePage.getSelectedExecutablePath();
        if (name == null || name.trim().length() <= 0) {
            return "";
        }
        name = new File(name.trim()).getName();
        IValidator validator = ValidationDescriptors.getValidatorByValidatorId((String)"c.identifier");
        if (validator != null) {
            return validator.validate((Object)name).isOK() ? name : PREFIX + ValidationUtil.transformToValid((String)name, (Pattern)CIdentifierValidator.getPattern(), (Character)Character.valueOf('_'));
        }
        return "";
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.configurationPage) {
            this.configurationPage.setSettings(this.hardwarePage.getDeviceCoreDescriptor(), this.hardwarePage.getDeviceRevision());
        }
        return nextPage;
    }

    protected void addExecutables(ICProject project) {
        String executable = this.hardwarePage.getSelectedExecutablePath();
        IPath location = Path.fromOSString((String)executable);
        IFile exeFile = project.getProject().getFile(location.toFile().getName());
        try {
            exeFile.createLink(location, 256, null);
        }
        catch (Exception exception) {
            this.configurationPage.setErrorMessage(String.format(ImportExecMessages.ImportExeWizard_error_import, executable));
        }
    }

    public void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, ICProject project) {
        try {
            LaunchConfigurationCreator configurationCreator = this.configurationPage.getDebuggerLaunchConfigurationDescriptor().getLaunchConfigurationCreator();
            if (configurationCreator != null) {
                File binaryFile = new File(this.hardwarePage.getSelectedExecutablePath());
                ProjectContextSettings projectSettings = new ProjectContextSettings(project.getProject());
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put(LaunchConfigurationSupportConstants.PROJECT_KEY, project.getProject());
                attributes.put("projectExecutable", binaryFile.getPath());
                attributes.put("debuggerId", this.configurationPage.getDebuggerLaunchConfigurationDescriptor().getDebuggerId());
                LC_ATTRIBUTS_TO_IMPORT.forEach(attr -> {
                    String string = attributes.put((String)attr, projectSettings.getAttributeByKey(attr));
                });
                configurationCreator.setupLaunchConfigurationWorkingCopy(config, attributes);
                return;
            }
            String source = this.configurationPage.getSource();
            if (source != null && !source.isEmpty()) {
                this.setSource(config, source);
            }
        }
        catch (CoreException e) {
            CdtUiActivator.getInstance().logError("An exception occurred during the setup process for launch configuration", e);
        }
    }

    public void setSource(ILaunchConfigurationWorkingCopy config, String src) {
        try {
            String type = config.getType().getSourceLocatorId();
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            director.initializeDefaults((ILaunchConfiguration)config);
            ISourceContainer[] one = director.getSourceContainers();
            ISourceContainer[] two = new ISourceContainer[one.length + 1];
            System.arraycopy(one, 0, two, 0, one.length);
            two[one.length] = new DirectorySourceContainer((IPath)new Path(src), true);
            director.setSourceContainers(two);
            config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
        }
        catch (CoreException e) {
            CdtUiActivator.getInstance().logError("An exception was thrown during source locator initialization", e);
        }
    }

    public Object getInitalInput() {
        return null;
    }

    public void createLaunchConfiguration(ICProject targetProject) throws CoreException {
        ILaunchConfigurationType launchConfigurationType = this.configurationPage.getLaunchConfigurationType();
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, this.configurationPage.getLaunchConfigurationName());
        this.setConfigurationDefaults(workingCopy, targetProject);
        workingCopy.setContainer((IContainer)targetProject.getProject());
        if (workingCopy.getAttribute("createLaunchFile", true)) {
            StructuredSelection selection = new StructuredSelection((Object)workingCopy.doSave());
            UIJob openLaunchConfigJob = new UIJob(Messages.AbstractImportExecutableWizard_CreateLaunchConfiguration, (IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                    super($anonymous0);
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)CUIPlugin.getActiveWorkbenchShell(), (IStructuredSelection)this.val$selection, (String)"org.eclipse.debug.ui.launchGroup.debug");
                    return Status.OK_STATUS;
                }
            };
            openLaunchConfigJob.schedule();
        }
    }

    public ILaunchConfigurationType getSelectedLaunchConfigurationType() {
        return this.configurationPage.getLaunchConfigurationType();
    }
}

