/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model;

import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationActionDescriptor;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.EvaluationDiagnosticFactory;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SequenceAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.ast.BooleanExpression;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.reflection.MigrationReflectionSupport;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperties;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class RegularAction
implements SequenceAction {
    private final BooleanExpression assertExpression;
    private final MigrationActionDescriptor descriptor;
    private final List<MigrationProperty> properties;
    private MigrationAction action;

    public RegularAction(BooleanExpression assertExpression, MigrationActionDescriptor descriptor, List<MigrationProperty> properties) throws MigrationReflectionSupport.MigrationReflectionException {
        this.assertExpression = assertExpression;
        this.descriptor = descriptor;
        this.properties = properties;
        this.action = (MigrationAction)MigrationReflectionSupport.initialize(descriptor.getActionClass(), descriptor.getDocumentation(), properties);
    }

    public MigrationActionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public MigrationProperties getProperties() {
        return new MigrationProperties(this.properties);
    }

    @Override
    public boolean match(IProject project, MigrationDiagnostic diagnostic) {
        return EvaluationDiagnosticFactory.evaluate(EvaluationDiagnosticFactory.createRegularActionDiagnostic(diagnostic, this), d -> {
            if (this.assertExpression == null) {
                return true;
            }
            return this.assertExpression.evaluate(project, (MigrationDiagnostic)d);
        });
    }

    public MigrationAction getMigrationAction() {
        return this.action;
    }

    public BooleanExpression getAssertExpression() {
        return this.assertExpression;
    }

    @Override
    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        this.action.perform(project, monitor);
    }

    public String toString() {
        String prop = new MigrationProperties(this.properties).toString();
        return "Action id=" + this.descriptor.getId() + (prop.isEmpty() ? "" : "\n" + prop);
    }
}

