/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence;

import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.MigrationSequenceImpl;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.Sequence;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationUrlSource;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequence;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public class MigrationSequenceDescriptorElement
extends MigrationConfigurationObjectDescriptor<MigrationSequenceDescriptor>
implements MigrationSequenceDescriptor {
    public static final String ELEMENT_NAME = "sequence";
    public static final String SPACE = "space";
    public static final String PATH = "path";
    private final MigrationSequence sequence = this.createSequence();
    private final MigrationSequenceDescriptor.Space space = this.extractSpace(this.getAttribute("space"));

    public MigrationSequenceDescriptorElement(IConfigurationElement element) {
        super(element, "id", "name", "description", PATH);
    }

    private MigrationSequenceDescriptor.Space extractSpace(String value) {
        if (value == null) {
            return MigrationSequenceDescriptor.Space.USER;
        }
        try {
            return MigrationSequenceDescriptor.Space.valueOf((String)value.toUpperCase());
        }
        catch (Exception e) {
            MigrationCoreActivator.getInstance().log(this.element, NLS.bind((String)Messages.MigrationSequenceDescriptorElement_invalid_value_of_space_attribute_0, (Object)value), e);
            return null;
        }
    }

    private MigrationSequence createSequence() {
        String path = this.getPath();
        if (MigrationsAssert.isEmpty(path)) {
            return null;
        }
        try {
            return new MigrationSequenceImpl(this, Sequence.builder().source(new MigrationUrlSource(path)).build());
        }
        catch (CoreException e) {
            MigrationCoreActivator.getInstance().log(this.element, NLS.bind((String)Messages.MigrationSequenceDescriptorElement_error_loading_sequence_0, (Object)e.getStatus().getMessage()), e);
            return null;
        }
    }

    private String getPath() {
        return this.getAttribute(PATH);
    }

    public String getId() {
        return this.getIdAttribute();
    }

    public String getName() {
        return this.getNameAttribute();
    }

    public String getDescription() {
        return this.getDescriptionAttribute();
    }

    public MigrationSequence getSequence() {
        return this.sequence;
    }

    public MigrationSequenceDescriptor.Space getSpace() {
        return this.space;
    }

    @Override
    public MigrationConfigurationDiagnostic validate() {
        if (MigrationsAssert.isEmpty(this.getName())) {
            return new MigrationConfigurationDiagnostic(this.element, Messages.MigrationSequenceDescriptorElement_name_must_be_defined);
        }
        if (MigrationsAssert.isEmpty(this.getDescription())) {
            return new MigrationConfigurationDiagnostic(this.element, Messages.MigrationSequenceDescriptorElement_description_must_be_defined);
        }
        if (MigrationsAssert.isEmpty(this.getPath())) {
            return new MigrationConfigurationDiagnostic(this.element, Messages.MigrationSequenceDescriptorElement_path_must_be_defined);
        }
        if (this.sequence == null) {
            return new MigrationConfigurationDiagnostic(this.element, Messages.MigrationSequenceDescriptorElement_cannot_load_sequence_definition);
        }
        if (this.space == null) {
            return new MigrationConfigurationDiagnostic(this.element, Messages.MigrationSequenceDescriptorElement_sequence_space_is_not_defined);
        }
        return MigrationConfigurationDiagnostic.OK;
    }
}

