/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.extension;

import com.nxp.s32ds.cle.runtime.migration.MigrationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.MigrationRegistryBase;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationConfigurationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.extension.MigrationServiceWrapper;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleContext;

public class MigrationExtension<D extends MigrationObjectDescriptor, R extends MigrationRegistryBase<D>, C extends MigrationConfigurationObjectDescriptor<D>> {
    private static final String EXTENSION_BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.cle.runtime.migration";
    private static final String EXTENSION_POINT_NAME = "extension";
    private static final String[] EMPTY = new String[0];
    private final MigrationServiceWrapper<R> serviceSupport;
    private final List<C> descriptors = new ArrayList<C>();
    private final String elementName;
    private final Function<IConfigurationElement, C> function;

    public MigrationExtension(Class<R> registryClass, String elementName, Function<IConfigurationElement, C> function) {
        this.elementName = elementName;
        this.function = function;
        this.serviceSupport = new MigrationServiceWrapper<R>(registryClass);
    }

    public void start(BundleContext bundleContext) {
        this.serviceSupport.start(bundleContext);
        this.load(this.elementName, this.function);
    }

    public void stop() {
        this.serviceSupport.stop();
        this.descriptors.clear();
    }

    public R getRegistry() {
        return (R)((MigrationRegistryBase)this.serviceSupport.getService());
    }

    public List<C> getDescriptors() {
        return this.descriptors;
    }

    private void load(String elementName, Function<IConfigurationElement, C> function) {
        Extensions.getConfigrationElements((String)EXTENSION_BUNDLE_SYMBOLIC_NAME, (String)EXTENSION_POINT_NAME, (String)elementName, (String[])EMPTY).stream().map(function).peek(this.descriptors::add).filter(this::validate).forEach(e -> this.getRegistry().addDescriptor(e.getDescriptor()));
    }

    private boolean validate(C element) {
        MigrationConfigurationDiagnostic diagnostic = element.validate();
        if (diagnostic.isOK()) {
            return true;
        }
        MigrationCoreActivator.getInstance().log(diagnostic);
        return false;
    }
}

