/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.sdkmanifest.descriptors.ASdkProjectExample;
import java.util.function.Supplier;
import org.eclipse.swt.widgets.Display;

public class WizardData {
    public ISharedConfiguration newConfiguration;
    public final WizardType wizardType;
    private Mode mode;
    @Nullable
    public ASdkProjectExample clonedExample = null;
    private String path = "";

    public WizardData(WizardType wizardType, ISharedConfiguration newConfiguration) {
        this.wizardType = wizardType;
        this.newConfiguration = newConfiguration;
        this.mode = wizardType.getDefaultMode();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode selMode) {
        this.mode = selMode;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String selPath) {
        this.path = selPath;
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode IMPORT_TOOLCHAIN_PROJECT = new Mode(false, () -> Messages.get().DlgModeSelection_RadioCreateNewConfigurationInToolchainPrj);
        public static final /* enum */ Mode OPEN_EXISTING_CFG = new Mode(false, () -> Messages.get().DlgModeSelection_RadioOpenExistingMex);
        public static final /* enum */ Mode CREATE_NEW_CFG = new Mode(true, () -> Messages.get().NewConfigurationModeSelectionPage_RadioNewCfg);
        public static final /* enum */ Mode SWITCH_PROCESSOR = new Mode(true, () -> Messages.get().NewConfigDialog_TitleForSwitch);
        public static final /* enum */ Mode CLONE_EXAMPLE = new Mode(false, () -> Messages.get().NewConfigurationModeSelectionPage_RadioCloneExample);
        private final boolean selectBoardProcessor;
        private Supplier<String> modeUiCaption;
        private static final /* synthetic */ Mode[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Mode[]{IMPORT_TOOLCHAIN_PROJECT, OPEN_EXISTING_CFG, CREATE_NEW_CFG, SWITCH_PROCESSOR, CLONE_EXAMPLE};
        }

        private Mode(boolean selectBrdProcessor, Supplier<String> modeUiCaption) {
            this.selectBoardProcessor = selectBrdProcessor;
            this.modeUiCaption = modeUiCaption;
        }

        public boolean selectBoardProcessor() {
            return this.selectBoardProcessor;
        }

        public String getUiCaption() {
            assert (Display.getCurrent() != null);
            String caption = this.modeUiCaption.get();
            assert (caption != null);
            return caption;
        }

        public static Mode[] values() {
            Mode[] modeArray = ENUM$VALUES;
            int n = modeArray.length;
            Mode[] modeArray2 = new Mode[n];
            System.arraycopy(ENUM$VALUES, 0, modeArray2, 0, n);
            return modeArray2;
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    public static enum WizardType {
        STARTUP(Mode.CREATE_NEW_CFG),
        NEW_CONFIGURATION(Mode.CREATE_NEW_CFG),
        SWITCHING_PROCESSOR(Mode.SWITCH_PROCESSOR);

        private final Mode defaultMode;

        private WizardType(Mode defaultMode) {
            this.defaultMode = defaultMode;
        }

        public Mode getDefaultMode() {
            return this.defaultMode;
        }
    }
}

