/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.commands;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.commands.ToolUpdateInfo;
import com.nxp.swtools.framework.p2.P2UpdateSites;
import com.nxp.swtools.kex.api.IHttpConnectionHelper;
import com.nxp.swtools.kex.api.MfactApiFactory;
import com.nxp.swtools.kex.exceptions.MfactServerError;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.simpleframework.xml.core.Persister;

@NonNullByDefault
public class CheckForUpdates
extends AbstractHandler {
    private static final String TOOL_UPDATE_FILE_NAME = "tool_update.xml";
    private static final Logger LOGGER = LogManager.getLogger(CheckForUpdates.class);

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        CheckForUpdates.checkForAppUpdates(false, false);
        return null;
    }

    public static Update checkForAppUpdates(boolean silent, boolean showDontShowAgain) {
        P2UpdateSites helper = new P2UpdateSites();
        @NonNull String[] repositories = System.getProperty("update.site", "file://tmp/updatesite").split(",");
        Display display = silent ? null : Display.getCurrent();
        P2UpdateSites.UpdateStatus status = helper.checkForUpdates((IProgressMonitor)new NullProgressMonitor(), display, repositories, display != null ? new ConfirmUpdate(display, showDontShowAgain) : msg -> false);
        switch (status) {
            case NOTHING_TO_UPDATE: 
            case ERROR_RUNNING_IN_IDE: 
            case ERROR_OTHER: {
                if (repositories.length > 0) {
                    return CheckForUpdates.checkNewApplication(repositories[0], silent, showDontShowAgain) ? Update.NEW_VERSION : Update.NO_UPDATE;
                }
                return Update.NO_UPDATE;
            }
            case UPDATE_AVAILABLE_NOT_EXECUTED: 
            case UPDATE_AVAILABLE_EXECUTED: {
                return Update.UPDATE;
            }
        }
        return Update.NO_UPDATE;
    }

    private static @Nullable ToolUpdateInfo checkNewApplicationInfo(String repository) {
        if (repository.startsWith("file:")) {
            return null;
        }
        IHttpConnectionHelper helper = MfactApiFactory.getHttpConnectionHelper();
        String url = String.valueOf(repository) + (repository.endsWith("/") ? "" : "/") + TOOL_UPDATE_FILE_NAME;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream is = helper.getHttpBinaryResponse(url, null, null, KExProcessorsProvider.getProxyConfiguration());){
                Persister serializer = new Persister();
                ToolUpdateInfo message = new ToolUpdateInfo();
                serializer.read((Object)message, is);
                if (message.message != null && !UtilsText.isEmpty((String)message.message)) {
                    return message;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MfactServerError mfactServerError) {
            LOGGER.fine("No information available about new application");
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException connectionException) {
            LOGGER.log(Level.SEVERE, "Connection error tool_update.xml", connectionException);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Deserializing from tool_update.xml", e);
        }
        return null;
    }

    private static boolean checkNewApplication(String repository, boolean silent, boolean showDontShowAgain) {
        ToolUpdateInfo message = CheckForUpdates.checkNewApplicationInfo(repository);
        if (message == null) {
            return false;
        }
        if (!silent) {
            Display d = Display.getDefault();
            d.syncExec(() -> {
                NewAppDialogWithToggle msg = new NewAppDialogWithToggle(message, showDontShowAgain);
                msg.open();
                if (showDontShowAgain && msg.getToggleState()) {
                    KEPreferences.setCheckForNewVersionOnStartup((boolean)false);
                }
            });
        }
        return true;
    }

    static class ConfirmUpdate
    implements Predicate<String> {
        private Display display;
        private boolean showDontShowAgain;

        public ConfirmUpdate(Display display, boolean showDontShowAgain) {
            this.display = display;
            this.showDontShowAgain = showDontShowAgain;
        }

        @Override
        public boolean test(String updMessage) {
            boolean[] confirmed = new boolean[1];
            this.display.syncExec(() -> {
                if (this.showDontShowAgain) {
                    MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)this.display.getActiveShell(), (String)Messages.get().P2UpdateSites_UpdateQuestion, (String)updMessage.toString(), (String)Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoToggle, (boolean)false, null, null);
                    boolean bl = blArray[0] = dlg.getReturnCode() == 2 || dlg.getReturnCode() == 0;
                    if (!confirmed[0] && dlg.getToggleState()) {
                        KEPreferences.setCheckForNewVersionOnStartup((boolean)false);
                    }
                } else {
                    blArray[0] = MessageDialog.openQuestion((Shell)this.display.getActiveShell(), (String)Messages.get().P2UpdateSites_UpdateQuestion, (String)updMessage.toString());
                }
            });
            return confirmed[0];
        }
    }

    public static class NewAppDialogWithToggle
    extends MessageDialogWithToggle {
        final ToolUpdateInfo toolInfo;
        final boolean showToggleButton;

        public NewAppDialogWithToggle(ToolUpdateInfo toolInfo, boolean showToggleButton) {
            super(ShellProvider.getAnyShellParent(), Messages.get().CheckForUpdates_NewAppDialogTitle, null, toolInfo.message, 2, new String[]{IDialogConstants.OK_LABEL}, 0, Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoToggle, false);
            this.toolInfo = toolInfo;
            this.showToggleButton = showToggleButton;
        }

        protected @Nullable Control createCustomArea(Composite parent) {
            Link link = new Link(parent, 64);
            link.setText(MessageFormat.format("<a href=\"{0}\">{0}</a>", this.toolInfo.link));
            link.addListener(13, e -> SWTFactoryProxy.INSTANCE.openUrlInExternalBrowser(UtilsText.safeString((String)e.text)));
            return link;
        }

        protected @Nullable Button createToggleButton(@Nullable Composite parent) {
            if (this.showToggleButton) {
                return super.createToggleButton(parent);
            }
            return null;
        }

        protected void setToggleButton(@Nullable Button button) {
            if (this.showToggleButton) {
                super.setToggleButton(button);
            }
        }
    }

    public static enum Update {
        NO_UPDATE,
        UPDATE,
        NEW_VERSION;

    }
}

