/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class RecentConfigFilesMenuItems
extends ContributionItem {
    public RecentConfigFilesMenuItems() {
    }

    public RecentConfigFilesMenuItems(@Nullable String id) {
        super(id);
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void fill(Menu mainMenu, int index) {
        @NonNull List fileNames = KEPreferences.getRecentConfigFileNames();
        if (!fileNames.isEmpty()) {
            new MenuItem(mainMenu, 2, index++);
            for (String fileName : fileNames) {
                assert (mainMenu != null);
                RecentConfigFilesMenuItems.addFileNameMenuItem(fileName, mainMenu, index++);
            }
        }
    }

    private static void addFileNameMenuItem(final @NonNull String fileName, @NonNull Menu toolsMenu, int index) {
        MenuItem menuItemTool = new MenuItem(toolsMenu, 0, index);
        menuItemTool.setText(fileName);
        menuItemTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell;
                Display display = e.display;
                Shell shell2 = shell = display != null ? display.getActiveShell() : null;
                if (shell != null) {
                    int result;
                    if (SWToolsPlatform.getSharedConfigurationSingleton().isDirty() && (result = ConfigurationUtils.saveDirtyConfiguration((Shell)shell, null, null, (boolean)true)) == 256) {
                        return;
                    }
                    ConfigurationUtils.openConfiguration((Shell)shell, (String)fileName, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_CMD);
                    String perspectiveId = KEPreferences.getPerspectiveForMex((String)fileName);
                    if (perspectiveId != null && !PerspectivesHelper.isPerspectiveActive((String)perspectiveId)) {
                        UIJobHelper.runUIJobSystem(() -> Application.setSelectedPerspective(perspectiveId));
                    }
                }
            }
        });
    }
}

