/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.framework.Application;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private IMenuManager fmenuBar;
    private ActionFactory.IWorkbenchAction undo;
    private ActionFactory.IWorkbenchAction redo;
    Logger LOGGER = LogManager.getLogger(ApplicationActionBarAdvisor.class);

    public ApplicationActionBarAdvisor(@Nullable IActionBarConfigurer configurer) {
        super(configurer);
        ApplicationActionBarAdvisor.registerPerspectiveChangeListener();
    }

    protected void makeActions(IWorkbenchWindow window) {
        super.makeActions(window);
        this.undo = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undo);
        this.redo = ActionFactory.REDO.create(window);
        this.register((IAction)this.redo);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        this.fmenuBar = menuBar;
    }

    public void mainMenuFixes() {
        MenuManager editMenu = (MenuManager)this.fmenuBar.find("com.nxp.swtools.framework.edit");
        if (editMenu == null) {
            this.LOGGER.severe("Cannot find \"com.nxp.swtools.framework.edit\" menu");
            return;
        }
        ActionFactory.IWorkbenchAction[] iWorkbenchActionArray = new ActionFactory.IWorkbenchAction[]{this.undo, this.redo};
        int n = iWorkbenchActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionFactory.IWorkbenchAction action = iWorkbenchActionArray[n2];
            IContributionItem pluginXmlCommand = editMenu.find(UtilsText.safeString((String)action.getActionDefinitionId()));
            if (pluginXmlCommand != null) {
                editMenu.insertBefore(UtilsText.safeString((String)pluginXmlCommand.getId()), (IAction)action);
                editMenu.remove(pluginXmlCommand);
            }
            ++n2;
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ApplicationActionBarAdvisor.removeAllActionSets();
    }

    private static void registerPerspectiveChangeListener() {
        Objects.requireNonNull(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (Objects.nonNull(perspective)) {
                    Application.setSelectedPerspective(perspective.getId());
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        });
    }

    public static void removeAllActionSets() {
        ActionSetRegistry registry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray = registry.getActionSets();
        int n = iActionSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSet = iActionSetDescriptorArray[n2];
            registry.removeExtension(actionSet.getConfigurationElement().getDeclaringExtension(), new Object[]{actionSet});
            ++n2;
        }
    }
}

