/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsDragSourceListener;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsExplorerContentProvider;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsExplorerLabelProvider;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainIntrinsicsHolder;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainIntrinsicsParser;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainsRoot;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorer;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class IntrinsicsExplorer
extends ADnDExplorer {
    protected static ToolchainsRoot tcRoot = ToolchainIntrinsicsParser.parse();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IntrinsicsGroup && parent instanceof ToolchainIntrinsicsHolder) {
                    IntrinsicsGroup group = (IntrinsicsGroup)element;
                    return group.check(IntrinsicsExplorer.this.project);
                }
                return true;
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProject selectedProject = this.getActiveProjectFromSelection(selection);
        if (selectedProject != null) {
            this.updateTree(selectedProject);
        } else {
            this.updateTree(null);
        }
    }

    protected ToolchainsRoot getData() {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project.getProject());
        if (buildInfo == null) {
            return null;
        }
        IToolChain toolchain = buildInfo.getDefaultConfiguration().getToolChain();
        if (toolchain != null && !tcRoot.isCompatibleWithToolchain(toolchain.getSuperClass().getBaseId())) {
            this.activateToolchainIntrinsicsHolder(toolchain);
        }
        return tcRoot;
    }

    protected IntrinsicsExplorerContentProvider newContentProvider() {
        return new IntrinsicsExplorerContentProvider(this.getTreeViewer());
    }

    protected IntrinsicsExplorerLabelProvider newLabelProvider() {
        return new IntrinsicsExplorerLabelProvider();
    }

    protected ADragSourceListener newDragSourceListener() {
        return new IntrinsicsDragSourceListener((AbstractTreeViewer)this.getTreeViewer(), this.getSite());
    }

    private void activateToolchainIntrinsicsHolder(IToolChain toolchain) {
        List<ToolchainIntrinsicsHolder> holders = tcRoot.findToolchainIntrinsicsHolders(toolchain);
        if (holders.isEmpty()) {
            String tcBaseId = toolchain.getBaseId();
            ToolchainIntrinsicsHolder tcIntrinsicsHolder = new ToolchainIntrinsicsHolder(tcBaseId);
            tcIntrinsicsHolder.setToolchainName(toolchain.getName());
            tcRoot.addToolchainIntrinsicsHolder(tcIntrinsicsHolder);
            tcRoot.setActiveProjectTcId(tcBaseId);
            tcRoot.setCompatibleTcIds(Arrays.asList(tcBaseId));
        } else {
            ArrayList<String> compatibleTcIds = new ArrayList<String>();
            holders.forEach(h -> {
                boolean bl = compatibleTcIds.add(h.getToolchainId());
            });
            tcRoot.setActiveProjectTcId(toolchain.getId());
            tcRoot.setCompatibleTcIds(compatibleTcIds);
        }
    }

    static IToolChain getToolchainFromProject(IProject project) {
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configurations = bi != null ? bi.getManagedProject().getConfigurations() : null;
        return configurations != null && configurations.length > 0 ? configurations[0].getToolChain() : null;
    }
}

