/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class ProcessorData
extends ObjectData {
    private final ContextPart processorPart;
    private String deviceId = "";
    private String deviceRevision = "";
    private String platformId = "";
    private String sdkTag = "";
    private String supportedPlatform = "";
    private String processorId = "";

    public ProcessorData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
        String attrProcessorId;
        String attrSupportedPlatform;
        String attrSdkTag;
        String attrDeviceRevision;
        Set<Parameter> refs = this.getParameters();
        this.processorPart = new ContextPart(refs, this.getContextPositionType());
        String attrDevice = ce.getAttribute("deviceId");
        if (attrDevice != null) {
            this.deviceId = attrDevice;
        }
        if ((attrDeviceRevision = ce.getAttribute("revision")) != null) {
            this.deviceRevision = attrDeviceRevision;
        }
        String attrPlatform = ce.getAttribute("platform");
        if (attrDevice != null) {
            this.platformId = attrPlatform;
        }
        if ((attrSdkTag = ce.getAttribute("sdkTag")) != null) {
            this.sdkTag = attrSdkTag;
        }
        if ((attrSupportedPlatform = ce.getAttribute("supportedPlatform")) != null) {
            this.supportedPlatform = attrSupportedPlatform;
        }
        if ((attrProcessorId = ce.getAttribute("id")) != null) {
            this.processorId = attrProcessorId;
        }
    }

    public List<CoreNatureData> getCoreNatures(boolean executable) {
        return executable ? this.getCores() : this.getCoreTypes();
    }

    public List<CoreData> getCores() {
        return this.getElements("core");
    }

    public List<CoreTypeData> getCoreTypes() {
        return this.getElements("coreType");
    }

    public FamilyData getFamily() {
        return (FamilyData)this.getElement("family");
    }

    public String getDevice() {
        return this.deviceId != null ? this.deviceId : "";
    }

    public String getProcessorId() {
        return this.processorId != null ? this.processorId : "";
    }

    public String getDeviceRevision() {
        return this.deviceRevision != null ? this.deviceRevision : "";
    }

    public String getPlatform() {
        return this.platformId != null ? this.platformId : "";
    }

    public String getSdkTag() {
        return this.sdkTag != null ? this.sdkTag : "";
    }

    public String getSupportedPlatform() {
        return this.supportedPlatform != null ? this.supportedPlatform : "";
    }

    @Override
    public Set<Parameter> getParameters() {
        Set<Parameter> result = super.getParameters();
        result.addAll(this.getFamily().getParameters());
        return result;
    }

    public ContextPart getProcessorPart() {
        return this.processorPart;
    }
}

