/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.zephyrrtos.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.nxp.s32ds.tad.common.controller.TadFactoryData;
import com.nxp.s32ds.tad.common.controller.TadFactoryDataStatus;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.model.readers.MemoryReader;
import com.nxp.s32ds.tad.common.model.readers.VariableReader;
import com.nxp.s32ds.tad.common.model.view.generic.TadDataCache;
import com.nxp.s32ds.tad.zephyrrtos.Activator;
import com.nxp.s32ds.tad.zephyrrtos.Messages;
import com.nxp.s32ds.tad.zephyrrtos.controller.ZephyrRtosTadFactory;
import com.nxp.s32ds.tad.zephyrrtos.model.view.threads.ThreadState;
import com.nxp.s32ds.tad.zephyrrtos.model.view.threads.ZephyrJsonThreadObject;
import com.nxp.s32ds.tad.zephyrrtos.model.view.threads.ZephyrStack;
import com.nxp.s32ds.tad.zephyrrtos.model.view.threads.ZephyrThread;
import com.nxp.s32ds.tad.zephyrrtos.model.zephyr.ZephyrRTOS;
import com.nxp.s32ds.tad.zephyrrtos.model.zephyr.ZephyrRTOSConfig;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;

public class ZephyrThreadsFactory
extends ZephyrRtosTadFactory {
    private static final String GDB_THREAD_COMMAND = "thread-aware-read-objs --json Thread";
    private static final String JSON_ARRAY_START = "[";
    private static final String JSON_ARRAY_END = "]";
    private static final String THREAD_OUTPUT_MODEL_REGEX = ".*\\{.*\\\"Thread\\\":\\ \\[.*\\].*}.*";

    public ZephyrThreadsFactory(TadModel tadModel, MemoryReader memoryReader, VariableReader variableReader, ZephyrRTOS zephyrRTOS, TadDataCache dataCache) {
        super(tadModel, memoryReader, variableReader, zephyrRTOS, dataCache);
    }

    private TadFactoryData createEmptyData(ZephyrRTOSConfig config) {
        return new TadFactoryData(this.getTadModel(), Collections.emptyList(), TadFactoryDataStatus.INFORMATION, config == null ? null : String.format(Messages.Info_EmptyThreadsView, config.toString()));
    }

    public TadFactoryData getData() {
        ArrayList<ZephyrThread> items = new ArrayList<ZephyrThread>();
        MIConsoleStreamOutput output = this.tadModel.getGdbManager().filteredSyncQueueCommand(GDB_THREAD_COMMAND, THREAD_OUTPUT_MODEL_REGEX);
        if (output == null) {
            return this.createEmptyData(null);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Type threadListType = new TypeToken<List<ZephyrJsonThreadObject>>(){}.getType();
        String outputString = output.getCString();
        outputString = outputString.substring(outputString.indexOf(JSON_ARRAY_START), outputString.indexOf(JSON_ARRAY_END) + 1);
        String jsonFormated = outputString.replaceAll("\\s(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", "").replaceAll("\\\\n", "");
        List threadsJSON = null;
        try {
            threadsJSON = (List)gson.fromJson(jsonFormated, threadListType);
        }
        catch (JsonSyntaxException e) {
            Activator.getDefault().log((Exception)((Object)e));
            threadsJSON = null;
        }
        if (threadsJSON == null) {
            return this.createEmptyData(null);
        }
        int num = 0;
        for (ZephyrJsonThreadObject thread : threadsJSON) {
            ZephyrStack stack = new ZephyrStack(thread.getStackAddr(), thread.getStackAddr() + thread.getStackSize(), thread.getStackDelta(), thread.getStackUsage() == null ? -1.0 : thread.getStackUsage(), thread.getPeakStackUsage() == null ? -1.0 : thread.getPeakStackUsage());
            items.add(new ZephyrThread(num++, thread.getTname(), thread.getAddress(), thread.getPrio(), this.getThreadState(thread.getState()), thread.getUserOptions(), stack, thread.getName(), thread.getMetadata() == null ? null : thread.getMetadata().getType()));
        }
        return new TadFactoryData(this.getTadModel(), items, TadFactoryDataStatus.SUCCESS, null);
    }

    private ThreadState getThreadState(String value) {
        ThreadState state = ThreadState.UNKNOWN;
        return Stream.of(ThreadState.values()).filter(_state -> _state.getStateValue().equals(value)).findFirst().orElse(state);
    }
}

