/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.ui.preferences;

import com.nxp.s32ds.rcp.license.ui.LicenseUiUtils;
import com.nxp.s32ds.rcp.license.ui.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LicensePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showWarningButton;
    private Button useDefaultLicenseWarningDelayButton;
    private Button useCustomWarningDelayButton;
    private Label daysLabel;
    private Text customWarningDelayText;
    private ModifyListener modifyListener = e -> this.validate();

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.workbench_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createButtons(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    private void validate() {
        String text = this.customWarningDelayText.getText();
        Button apply = this.getApplyButton();
        if (apply == null) {
            return;
        }
        if (text != null) {
            try {
                Integer.parseInt(text.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.getString("PreferencePage_DayValueIsInvalid", null));
                apply.setEnabled(false);
                this.setValid(false);
                return;
            }
        }
        this.setErrorMessage(null);
        apply.setEnabled(true);
        this.setValid(true);
    }

    protected void createButtons(Composite composite) {
        this.showWarningButton = new Button(composite, 32);
        this.showWarningButton.setText(Messages.getString("LicensePreferencePage_1", null));
        this.showWarningButton.setSelection(LicenseUiUtils.getStore().getBoolean("booleanDisplayWarningWindow"));
        this.showWarningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setDisplayWarning(LicensePreferencePage.this.showWarningButton.getSelection());
            }
        });
        this.useDefaultLicenseWarningDelayButton = LicensePreferencePage.createRadioButton(composite, Messages.getString("LicensePreferencePage_2", null));
        this.useDefaultLicenseWarningDelayButton.setSelection(LicenseUiUtils.getStore().getString("choiceDelayType").equals("licenceDefault"));
        this.useDefaultLicenseWarningDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setDefaultLicenseWarningDelay(LicensePreferencePage.this.useDefaultLicenseWarningDelayButton.getSelection());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 20;
        this.useDefaultLicenseWarningDelayButton.setLayoutData((Object)data);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(272));
        data = new GridData();
        data.horizontalIndent = 20;
        child.setLayoutData((Object)data);
        this.useCustomWarningDelayButton = LicensePreferencePage.createRadioButton(child, Messages.getString("LicensePreferencePage_3", null));
        this.useCustomWarningDelayButton.setSelection(LicenseUiUtils.getStore().getString("choiceDelayType").equals("custom"));
        this.useCustomWarningDelayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePreferencePage.this.setCustomWarningDelay(LicensePreferencePage.this.useCustomWarningDelayButton.getSelection());
            }
        });
        this.customWarningDelayText = new Text(child, 16779268);
        this.customWarningDelayText.setText(Integer.toString(LicenseUiUtils.getStore().getInt("intNumberOfDays")));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        final ControlDecoration txtDecorator = new ControlDecoration((Control)this.customWarningDelayText, 131200);
        txtDecorator.setImage(img);
        txtDecorator.setDescriptionText(Messages.getString("PreferencePage_NotNullNumericField", null));
        txtDecorator.hide();
        this.customWarningDelayText.addModifyListener(this.modifyListener);
        this.customWarningDelayText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                txtDecorator.hide();
            }
        });
        this.customWarningDelayText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text text;
                if (e.widget instanceof Text && (text = (Text)e.widget).getText().isEmpty()) {
                    text.setFocus();
                    txtDecorator.show();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        data = new GridData();
        data.widthHint = 15;
        this.customWarningDelayText.setLayoutData((Object)data);
        this.daysLabel = new Label(child, 4);
        this.daysLabel.setText(Messages.getString("LicensePreferencePage_4", null));
        this.arrangeEnabledStates();
    }

    void arrangeEnabledStates() {
        boolean showWarning = this.showWarningButton.getSelection();
        this.useDefaultLicenseWarningDelayButton.setEnabled(showWarning);
        this.useCustomWarningDelayButton.setEnabled(showWarning);
        boolean customSelected = this.useCustomWarningDelayButton.getSelection();
        this.customWarningDelayText.setEnabled(showWarning && customSelected);
        this.daysLabel.setEnabled(showWarning);
    }

    void setCustomWarningDelay(boolean value) {
        this.useDefaultLicenseWarningDelayButton.setSelection(!value);
        this.arrangeEnabledStates();
    }

    void setDefaultLicenseWarningDelay(boolean value) {
        this.useCustomWarningDelayButton.setSelection(!value);
        this.arrangeEnabledStates();
    }

    void setDisplayWarning(boolean value) {
        this.arrangeEnabledStates();
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    public void init(IWorkbench aWorkbench) {
        this.setPreferenceStore(LicenseUiUtils.getStore());
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            this.showWarningButton.setSelection(store.getDefaultBoolean("booleanDisplayWarningWindow"));
            this.useDefaultLicenseWarningDelayButton.setSelection(store.getDefaultString("choiceDelayType").equals("licenceDefault"));
            this.useCustomWarningDelayButton.setSelection(store.getDefaultString("choiceDelayType").equals("custom"));
            this.customWarningDelayText.setText(Integer.toString(store.getDefaultInt("intNumberOfDays")));
        }
        this.arrangeEnabledStates();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            store.setValue("booleanDisplayWarningWindow", this.showWarningButton.getSelection());
            if (this.useDefaultLicenseWarningDelayButton.getSelection()) {
                store.setValue("choiceDelayType", "licenceDefault");
            } else {
                store.setValue("choiceDelayType", "custom");
            }
        }
        String text = this.customWarningDelayText.getText();
        if (store != null && text != null && !text.trim().isEmpty()) {
            store.setValue("intNumberOfDays", Integer.parseInt(text));
        }
        return super.performOk();
    }

    protected Composite createComposite(Composite parent) {
        Composite newComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        newComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(272);
        newComposite.setLayoutData((Object)gridData);
        return newComposite;
    }
}

