/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeRwxAccessRule;
import com.nxp.swtools.provider.configuration.storage.tee.AccessType;
import java.util.logging.Logger;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageTeeTrdcTemplateRwxAccess
extends AStorageTeeRwxAccessRule
implements IYamlConvertible {
    private static final Logger LOGGER = LogManager.getLogger(StorageTeeTrdcTemplateRwxAccess.class);
    private static final String SECURITY_LEVEL_YAML_ALL = "all";

    public StorageTeeTrdcTemplateRwxAccess() {
    }

    public StorageTeeTrdcTemplateRwxAccess(@Nullable String securityLevel) {
        super(securityLevel);
    }

    public void fillYamlStorable(IYamlStorable yaml) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getRead().getAbbreviation()).append(this.getWrite().getAbbreviation());
        AccessType execute = this.getExecute();
        if (execute != null) {
            stringBuilder.append(execute.getAbbreviation());
        }
        yaml.addYamlChild((IYamlStorable)new YamlStorableValue(this.getSecurityLevelYamlString(), stringBuilder.toString()));
    }

    private String getSecurityLevelYamlString() {
        String yamlString = this.getSecurityLevelString();
        if (UtilsText.isEmpty((String)yamlString)) {
            yamlString = SECURITY_LEVEL_YAML_ALL;
        }
        return UtilsText.safeString((String)yamlString);
    }

    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        this.setSecurityLevelString(yaml.getYamlId());
        String yamlValue = yaml.getYamlValue();
        if (yamlValue.length() != 3) {
            LOGGER.warning(() -> "String with exactly 3 characters is expected to be parsed as value for template access");
        }
        this.setReadByAbbreviation(String.valueOf(yamlValue.charAt(0)));
        this.setWriteByAbbreviation(String.valueOf(yamlValue.charAt(1)));
        this.setExecuteByAbbreviation(String.valueOf(yamlValue.charAt(2)));
        return true;
    }
}

