/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeDisableableMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false, name="region")
public class StorageTeeMpuRegion
extends StorageTeeDisableableMemoryRegionConfig {
    public static final String EXECUTABLE_ID = "executable";
    public static final String READ_ONLY_ID = "read_only";
    public static final String SHAREABILITY_ID = "shareability";
    public static final String MEMORY_ATTRIBUTE_ID = "attributes_index";
    public static final String SUB_REGION_DISABLE = "srd";
    @Attribute(name="executable", required=true)
    private boolean executable;
    @Attribute(name="read_only", required=true)
    private String readOnly = Boolean.toString(false);
    @Attribute(name="shareability", required=false)
    @Nullable
    private @Attribute(name="shareability", required=false) @Nullable String shareability;
    @Attribute(name="attributes_index", required=true)
    private int memoryAttribute;
    @Attribute(name="srd", required=false)
    @Nullable
    private @Attribute(name="srd", required=false) @Nullable BigInteger subRegionDisable;

    public StorageTeeMpuRegion(BigInteger start, BigInteger size, String security, int index, boolean enabled, boolean executable, String readOnly, @Nullable String shareability, @Nullable BigInteger subRegionsDisable, int memoryAttribute) {
        super(start, size, security, index, enabled);
        this.executable = executable;
        this.readOnly = readOnly;
        this.shareability = shareability;
        this.subRegionDisable = subRegionsDisable;
        this.memoryAttribute = memoryAttribute;
    }

    public StorageTeeMpuRegion() {
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue(EXECUTABLE_ID, Boolean.toString(this.isExecutable())));
        storable.add((IYamlStorable)new YamlStorableValue(READ_ONLY_ID, this.getReadOnly()));
        if (this.shareability != null) {
            storable.add((IYamlStorable)new YamlStorableValue(SHAREABILITY_ID, this.shareability));
        }
        if (this.subRegionDisable != null) {
            storable.add((IYamlStorable)new YamlStorableValue(SUB_REGION_DISABLE, this.subRegionDisable.toString()));
        }
        storable.add((IYamlStorable)new YamlStorableValue(MEMORY_ATTRIBUTE_ID, Integer.toString(this.getMemoryAttribute())));
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        boolean executableLoc = false;
        String readOnlyLoc = null;
        String shareabilityLoc = null;
        int memoryAttributeLoc = 0;
        BigInteger subRegionsDisableLoc = null;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals(EXECUTABLE_ID)) {
                executableLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                continue;
            }
            if (childYaml.getYamlId().equals(READ_ONLY_ID)) {
                readOnlyLoc = childYaml.getYamlValue();
                continue;
            }
            if (childYaml.getYamlId().equals(SHAREABILITY_ID)) {
                shareabilityLoc = childYaml.getYamlValue();
                continue;
            }
            if (childYaml.getYamlId().equals(MEMORY_ATTRIBUTE_ID)) {
                memoryAttributeLoc = Integer.parseInt(childYaml.getYamlValue());
                continue;
            }
            if (!childYaml.getYamlId().equals(SUB_REGION_DISABLE)) continue;
            subRegionsDisableLoc = NumberFormatter.getBigInteger((String)childYaml.getYamlValue());
        }
        this.setExecutable(executableLoc);
        if (readOnlyLoc != null) {
            this.setReadOnly(readOnlyLoc);
        }
        this.setShareability(shareabilityLoc);
        this.setMemoryAttribute(memoryAttributeLoc);
        this.setSubRegionsDisable(subRegionsDisableLoc);
        return true;
    }

    public int getMemoryAttribute() {
        return this.memoryAttribute;
    }

    public @Nullable String getShareability() {
        return this.shareability;
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setShareability(@Nullable String shareability) {
        this.shareability = shareability;
    }

    public void setMemoryAttribute(int memoryAttribute) {
        this.memoryAttribute = memoryAttribute;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public @Nullable BigInteger getSubRegionDisable() {
        return this.subRegionDisable;
    }

    public void setSubRegionsDisable(@Nullable BigInteger subRegionDisable) {
        this.subRegionDisable = subRegionDisable;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.executable, this.memoryAttribute, Boolean.valueOf(this.readOnly), this.shareability, this.subRegionDisable);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeMpuRegion other = (StorageTeeMpuRegion)obj;
        return this.executable == other.executable && this.memoryAttribute == other.memoryAttribute && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.shareability, other.shareability) && Objects.equals(this.subRegionDisable, other.subRegionDisable);
    }
}

