/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageTeeBaseMemoryRegionConfig
implements IYamlConvertible {
    private static final String BASE_MEMORY_REGION_ID = "base_region";
    protected static final String START_ID = "start";
    protected static final String SIZE_ID = "size";
    @Attribute(name="start")
    protected BigInteger start = BigInteger.ZERO;
    @Attribute(name="size")
    protected BigInteger size = BigInteger.ZERO;

    public StorageTeeBaseMemoryRegionConfig() {
    }

    public StorageTeeBaseMemoryRegionConfig(BigInteger start, BigInteger size) {
        this.start = start;
        this.size = size;
    }

    public BigInteger getStart() {
        return this.start;
    }

    public void setStart(BigInteger start) {
        this.start = start;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public void setSize(BigInteger size) {
        this.size = size;
    }

    protected String getYamlId() {
        return BASE_MEMORY_REGION_ID;
    }

    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue(START_ID, StorageTeeTool.getHexString(this.getStart())));
        storable.add((IYamlStorable)new YamlStorableValue(SIZE_ID, StorageTeeTool.getHexString(this.getSize())));
        return storable;
    }

    public final void fillYamlStorable(IYamlStorable yaml) {
        yaml.addYamlChild((IYamlStorable)new YamlStorableList(this.getYamlId(), this.createYamlStorable(), Boolean.TRUE));
    }

    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        BigInteger startLoc = BigInteger.ZERO;
        BigInteger sizeLoc = BigInteger.ZERO;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals(SIZE_ID)) {
                sizeLoc = NumberFormatter.getBigInteger((String)childYaml.getYamlValue());
                continue;
            }
            if (!childYaml.getYamlId().equals(START_ID)) continue;
            startLoc = NumberFormatter.getBigInteger((String)childYaml.getYamlValue());
        }
        this.setStart(startLoc);
        this.setSize(sizeLoc);
        return true;
    }

    public final boolean updateFromYamlStorable(IYamlStorable yaml) {
        return this.loadYamlConvertible(YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml));
    }

    public int hashCode() {
        return Objects.hash(this.size, this.start);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeBaseMemoryRegionConfig other = (StorageTeeBaseMemoryRegionConfig)obj;
        if (!Objects.equals(this.start, other.start)) {
            return false;
        }
        return Objects.equals(this.size, other.size);
    }

    public String toString() {
        return String.format("StorageTeeBaseMemoryRegionConfig [start=%s, size=%s]", this.start, this.size);
    }
}

