/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@NonNullByDefault
@Root(strict=false, name="pin")
public class StorageConnectorPin {
    private static final Logger LOGGER = LogManager.getLogger(StorageConnectorPin.class);
    @Attribute(name="id", required=true)
    protected int id;
    @Attribute(name="pin_num", required=false)
    @Nullable
    protected @Attribute(name="pin_num", required=false) @Nullable String procPinCoords;
    @Attribute(name="pin_signal", required=false)
    @Nullable
    protected @Attribute(name="pin_signal", required=false) @Nullable String procPinId;
    @Attribute(name="external_signal_types", required=false)
    @Nullable
    protected @Attribute(name="external_signal_types", required=false) @Nullable String externalSignalTypes;
    @Nullable
    protected List<String> externalSignalTypesList;
    @Attribute(name="name", required=false)
    @Nullable
    protected @Attribute(name="name", required=false) @Nullable String name;
    public static final String ANY_SIGNAL = "*";

    StorageConnectorPin() {
    }

    public StorageConnectorPin(int id, @Nullable String procPinId, @Nullable String procPinCoords, @Nullable String externalSignalTypes, @Nullable String name) {
        this.id = id;
        this.procPinCoords = procPinCoords;
        this.procPinId = procPinId;
        this.externalSignalTypes = externalSignalTypes;
        this.name = UtilsText.isEmpty((String)name) ? null : name;
        this.validate();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public @Nullable String getProcPinCoords() {
        return this.procPinCoords;
    }

    public void setProcPinCoords(@Nullable String pinCoords) {
        this.procPinCoords = UtilsText.isEmpty((String)pinCoords) ? null : pinCoords;
    }

    public @Nullable String getProcPinId() {
        return this.procPinId;
    }

    public void setProcPinId(@Nullable String pinId) {
        this.procPinId = UtilsText.isEmpty((String)pinId) ? null : pinId;
    }

    public @Nullable String getExternalSignalTypes() {
        return this.externalSignalTypes;
    }

    public void setExternalSignalTypes(@Nullable String externalSignalTypes) {
        this.externalSignalTypes = UtilsText.isEmpty((String)externalSignalTypes) ? null : externalSignalTypes;
        this.validate();
    }

    public @Nullable List<String> getExternalSignalTypesList() {
        return this.externalSignalTypesList;
    }

    public boolean isConnectedToExternalSignal() {
        return this.externalSignalTypes != null;
    }

    public boolean isConnectedToProcessor() {
        return this.procPinId != null && this.procPinCoords != null;
    }

    public boolean isConnected() {
        return this.isConnectedToExternalSignal() || this.isConnectedToProcessor();
    }

    public String getName() {
        return UtilsText.safeString((String)this.name);
    }

    public void setName(@Nullable String name) {
        this.name = UtilsText.isEmpty((String)name) ? null : name;
    }

    @Validate
    public void validate() {
        String externalSignalTypesLoc = this.externalSignalTypes;
        if (externalSignalTypesLoc != null) {
            if (externalSignalTypesLoc.isEmpty()) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("Invalid external_signal_types value ''{0}''", externalSignalTypesLoc));
                this.externalSignalTypes = null;
                this.externalSignalTypesList = null;
            } else {
                this.externalSignalTypesList = Arrays.asList(externalSignalTypesLoc.split(" "));
            }
        } else {
            this.externalSignalTypesList = null;
        }
    }

    public String getConfigText() {
        String procPinCoordsText = this.procPinCoords != null ? "pin_num=" + this.procPinCoords : "";
        String externalSignalTypesText = this.externalSignalTypes != null ? "external_signal_types=" + this.externalSignalTypes : "";
        String nameText = this.name != null ? "name=" + this.name : "";
        return String.join((CharSequence)", ", procPinCoordsText, externalSignalTypesText, nameText);
    }

    public String toString() {
        String procPinCoordsText = this.procPinCoords != null ? ", pin_num=" + this.procPinCoords : "";
        String externalSignalTypesText = this.externalSignalTypes != null ? ", external_signal_types=" + this.externalSignalTypes : "";
        String nameText = this.name != null ? ", name=" + this.name : "";
        return "StorageConnectorPin [id=" + this.id + procPinCoordsText + externalSignalTypesText + nameText + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageConnectorPin other = (StorageConnectorPin)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!Objects.equals(this.procPinCoords, other.procPinCoords)) {
            return false;
        }
        if (!Objects.equals(this.procPinId, other.procPinId)) {
            return false;
        }
        if (!Objects.equals(this.externalSignalTypes, other.externalSignalTypes)) {
            return false;
        }
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + Objects.hashCode(this.procPinCoords);
        result = 31 * result + Objects.hashCode(this.procPinId);
        result = 31 * result + Objects.hashCode(this.externalSignalTypes);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }
}

