/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resource.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameUtils;
import com.nxp.s32ds.ext.ide.core.searchengine.TextChangeFinder;
import com.nxp.s32ds.ext.ide.resource.internal.refactoring.ResourceRefactoringActivator;
import com.nxp.s32ds.ext.ide.validation.core.IChangeValidator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LcResourcesRefactoringParticipant
implements RefactoringParticipant,
IChangeValidator {
    private static final String AFFECTED_KEY_PATTERN = "key";
    private static final String AFFECTED_VALUE_PATTERN = "value=\"[^\"]*?%s[^\"]*?\"";
    protected static final String[] LAUNCH_FILES;
    private static final String RENAME_ATTRIBUTES_EXTENSION_POINT = "com.nxp.s32ds.ext.ide.core.renameRefactoringLaunchAttributes";
    private static final String ATTRIBUTE_CONFIGURATION_ELEMENT = "attribute";
    private static final String LAUNCH_ATTRIBUTE_NAME_KEY = "name";
    private static final String LAUNCH_TYPE_KEY = "launchConfigurationType";
    private static final String LC_MARKER_ID = "com.nxp.s32ds.ext.ide.validation.core.launch.marker";
    private static final String CONFIGURATION_PROJECT_NAME_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private static final String ATTR_MAPPED_RESOURCE = "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS";
    private static final List<IChangeValidator.AttributeLine> ATTRIBUTES_AFFECTED;
    private static final List<String> FILTER_KEYS_LIST;

    static {
        IExtension[] extensions;
        LAUNCH_FILES = new String[]{"*.launch"};
        ATTRIBUTES_AFFECTED = new ArrayList<IChangeValidator.AttributeLine>();
        FILTER_KEYS_LIST = Arrays.asList("org.eclipse.debug.core.ATTR_TARGET_PATH", "org.eclipse.cdt.launch.PROGRAM_NAME");
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(RENAME_ATTRIBUTES_EXTENSION_POINT).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                if (configElement.getName().equals(ATTRIBUTE_CONFIGURATION_ELEMENT)) {
                    String attributeName = configElement.getAttribute(LAUNCH_ATTRIBUTE_NAME_KEY);
                    String launchConfigurationTypeId = configElement.getAttribute(LAUNCH_TYPE_KEY);
                    ATTRIBUTES_AFFECTED.add(new IChangeValidator.AttributeLine(AFFECTED_KEY_PATTERN, Arrays.asList(AFFECTED_VALUE_PATTERN), attributeName, launchConfigurationTypeId));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IStatus apply(IProject tgtResources, IProject srcResource, String search, String replace, IProgressMonitor monitor) {
        if (replace != null && replace.equals(search)) {
            return Status.OK_STATUS;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.modifyLaunchConfigurationOperation((IResource)tgtResources, LAUNCH_FILES, search, replace, monitor);
    }

    protected IStatus modifyLaunchConfigurationOperation(IResource projects, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        return this.modifyLaunchConfigurationOperation(projects, filesExt, search, replace, null, monitor);
    }

    protected IStatus modifyLaunchConfigurationOperation(IResource projects, String[] filesExt, String search, String replace, List<String> launchConfigurationTypes, IProgressMonitor monitor) {
        MultiStatus mtStatus = ResourceRefactoringActivator.getInstance().createMultiStatus();
        try {
            Map mapEdit = TextChangeFinder.findInResource((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            List fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            if (!mapEdit.isEmpty()) {
                for (Map.Entry iter : mapEdit.entrySet()) {
                    IFile file = (IFile)iter.getKey();
                    if (!LcResourcesRefactoringParticipant.checkByLaunchConfigurationType(file, launchConfigurationTypes)) continue;
                    this.applyChanges(file, (List)iter.getValue(), monitor);
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    String newName = lm.generateLaunchConfigurationName(replace);
                    mtStatus.add(RenameUtils.renameFile((IFile)file, (String)search, (String)newName, (IProgressMonitor)monitor));
                    LcResourcesRefactoringParticipant.updateLaunchConfigurationsCache(lm, file);
                }
            }
            if (!fileForRenameNotMatcher.isEmpty()) {
                for (IFile file : fileForRenameNotMatcher) {
                    if (!LcResourcesRefactoringParticipant.checkByLaunchConfigurationType(file, launchConfigurationTypes)) continue;
                    mtStatus.add(RenameUtils.renameFile((IFile)file, (String)search, (String)replace, (IProgressMonitor)monitor));
                }
            }
            LcResourcesRefactoringParticipant.checkAndDeleteLcMarkers(projects);
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }

    private static void updateLaunchConfigurationsCache(ILaunchManager lm, IFile file) throws CoreException {
        ILaunchConfigurationWorkingCopy wc;
        ILaunchConfiguration lc = lm.getLaunchConfiguration(file);
        if (lc.exists() && (wc = lc.getWorkingCopy()).exists()) {
            try {
                Field f = lm.getClass().getDeclaredField("fLaunchConfigurations");
                f.setAccessible(true);
                Map registry = (Map)f.get(lm);
                registry.remove(lc);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        }
    }

    private static boolean checkByLaunchConfigurationType(IFile file, List<String> types) {
        if (types == null || types.isEmpty()) {
            return true;
        }
        try {
            String t = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(file).getType().getIdentifier();
            return types.contains(t);
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public void applyChanges(IFile fCurrentFile, List<ReplaceEdit> lstChanges, IProgressMonitor monitor) throws CoreException {
        Predicate<IChangeValidator.AttributeLine> predicate;
        try {
            String type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(fCurrentFile).getType().getIdentifier();
            predicate = e -> e.launchConfigurationType != null ? e.launchConfigurationType.equals(type) : true;
        }
        catch (CoreException coreException) {
            return;
        }
        IDocument result = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                IPath path = fCurrentFile.getFullPath();
                manager.connect(path, LocationKind.NORMALIZE, monitor);
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                result = buffer.getDocument();
                MultiTextEdit mte = new MultiTextEdit();
                List actualAttributes = ATTRIBUTES_AFFECTED.stream().filter(predicate).collect(Collectors.toList());
                for (ReplaceEdit it : lstChanges) {
                    if (this.skipChange(actualAttributes, result, it, FILTER_KEYS_LIST)) continue;
                    mte.addChild((TextEdit)it);
                }
                mte.apply(result);
                buffer.commit(monitor, true);
            }
            catch (Exception e2) {
                IStatus status = ResourceRefactoringActivator.getInstance().createError(e2.getMessage(), e2);
                throw new CoreException(status);
            }
        }
        finally {
            if (result != null) {
                manager.disconnect(fCurrentFile.getFullPath(), LocationKind.NORMALIZE, monitor);
            }
        }
        monitor.done();
    }

    private static void checkAndDeleteLcMarkers(IResource project) {
        try {
            IMarker[] markers = project.findMarkers(LC_MARKER_ID, false, 2);
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String validName;
                IFile launchFile;
                ILaunchConfiguration launchConfiguration;
                IMarker marker = iMarkerArray[n2];
                IResource resource = marker.getResource();
                if (resource instanceof IFile && LcResourcesRefactoringParticipant.isValidProjectNameAttribute(launchConfiguration = lm.getLaunchConfiguration(launchFile = (IFile)resource), validName = project.getName()) && LcResourcesRefactoringParticipant.isValidProjectMappedResources(launchConfiguration, validName)) {
                    marker.delete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ResourceRefactoringActivator.getInstance().log(e.getStatus());
        }
    }

    private static boolean isValidProjectNameAttribute(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        String projectNameAttribute = launchConfiguration.getAttribute(CONFIGURATION_PROJECT_NAME_ATTR, "");
        if (projectNameAttribute.isEmpty()) {
            return false;
        }
        return validValue.equals(projectNameAttribute);
    }

    private static boolean isValidProjectMappedResources(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        List listMapedResources = launchConfiguration.getAttribute(ATTR_MAPPED_RESOURCE, Collections.emptyList());
        if (listMapedResources.isEmpty()) {
            return true;
        }
        return listMapedResources.stream().anyMatch(e -> e.endsWith(validValue));
    }
}

