/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public abstract class AbstractMarkupDocumentBuilder
extends DocumentBuilder {
    protected Block currentBlock;
    private Stack<MarkupWriter> writerState;
    private MarkupWriter writer;
    private boolean adjacentSeparatorRequired = false;

    protected AbstractMarkupDocumentBuilder(Writer out) {
        this.writer = new MarkupWriter(out);
    }

    protected void emitContent(int c) throws IOException {
        this.maybeInsertAdjacentWhitespace(c);
        this.writer.write(c);
    }

    private void maybeInsertAdjacentWhitespace(int c) throws IOException {
        if (this.adjacentSeparatorRequired) {
            char lastChar;
            if (!this.isSeparator(c) && (lastChar = this.getLastChar()) != '\u0000' && !this.isSeparator(lastChar)) {
                this.writer.write(32);
            }
            this.adjacentSeparatorRequired = false;
        }
    }

    protected void emitContent(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return;
        }
        this.maybeInsertAdjacentWhitespace(str.charAt(0));
        this.writer.write(str);
    }

    protected void requireAdjacentSeparator() {
        this.adjacentSeparatorRequired = true;
    }

    protected void clearRequireAdjacentSeparator() {
        this.adjacentSeparatorRequired = false;
    }

    protected boolean isSeparator(int i) {
        char c = (char)i;
        boolean separator = Character.isWhitespace(c);
        if (!separator) {
            switch (c) {
                case '!': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ':': 
                case ';': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    separator = true;
                }
            }
        }
        return separator;
    }

    @Override
    public void beginDocument() {
    }

    @Override
    public void endDocument() {
        this.flush();
    }

    @Override
    public void flush() {
        while (this.currentBlock != null) {
            this.endBlock();
        }
    }

    protected void pushWriter(Writer writer) {
        if (this.writerState == null) {
            this.writerState = new Stack();
        }
        this.writerState.push(this.writer);
        this.writer = new MarkupWriter(writer);
    }

    protected Writer popWriter() {
        if (this.writerState == null || this.writerState.isEmpty()) {
            throw new IllegalStateException();
        }
        MarkupWriter markupWriter = this.writer;
        this.writer = this.writerState.pop();
        return markupWriter.getDelegate();
    }

    protected char getLastChar() {
        char c = this.writer.getLastChar();
        if (c == '\u0000' && this.writerState != null) {
            for (int x = this.writerState.size() - 1; c == '\u0000' && x >= 0; --x) {
                c = ((MarkupWriter)this.writerState.get(x)).getLastChar();
            }
        }
        return c;
    }

    protected int getTrailingNewlineCount() {
        int count = this.writer.getTrailingNewlineCount();
        if (this.writer.getCharacterCount() == count && this.writerState != null) {
            for (int x = this.writerState.size() - 1; x >= 0; --x) {
                MarkupWriter markupWriter = (MarkupWriter)this.writerState.get(x);
                int trailingNewlineCount = markupWriter.getTrailingNewlineCount();
                count += trailingNewlineCount;
                if (markupWriter.getCharacterCount() > trailingNewlineCount) break;
            }
        }
        return count;
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        try {
            if (this.currentBlock != null && this.currentBlock.isImplicitBlock()) {
                this.currentBlock.close();
                this.currentBlock = null;
            }
            Block block = this.computeBlock(type, attributes);
            block.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Block computeBlock(DocumentBuilder.BlockType var1, Attributes var2);

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.assertOpenBlock();
        Block block = this.computeSpan(type, attributes);
        try {
            block.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Block computeSpan(DocumentBuilder.SpanType var1, Attributes var2);

    @Override
    public void endSpan() {
        this.closeCurrentBlock();
    }

    protected String computePrefix(char c, int count) {
        String prefix = "";
        while (count-- > 0) {
            prefix = prefix + c;
        }
        return prefix;
    }

    protected int computeListLevel() {
        int level = 0;
        for (Block b = this.currentBlock; b != null; b = b.getPreviousBlock()) {
            if (b.getBlockType() == null) continue;
            switch (b.getBlockType()) {
                case BULLETED_LIST: 
                case NUMERIC_LIST: 
                case DEFINITION_LIST: {
                    ++level;
                }
            }
        }
        return level;
    }

    protected DocumentBuilder.BlockType computeCurrentListType() {
        for (Block b = this.currentBlock; b != null; b = b.getPreviousBlock()) {
            if (b.getBlockType() == null) continue;
            switch (b.getBlockType()) {
                case BULLETED_LIST: 
                case NUMERIC_LIST: 
                case DEFINITION_LIST: {
                    return b.getBlockType();
                }
            }
        }
        return null;
    }

    @Override
    public void endBlock() {
        this.closeCurrentBlock();
    }

    private void closeCurrentBlock() {
        if (this.currentBlock != null) {
            try {
                this.currentBlock.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        Block block = this.computeHeading(level, attributes);
        try {
            block.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endHeading() {
        this.endBlock();
    }

    protected abstract Block computeHeading(int var1, Attributes var2);

    protected void assertOpenBlock() {
        if (this.currentBlock == null) {
            Block block = this.createImplicitParagraphBlock();
            try {
                block.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void charactersUnescaped(String literal) {
        this.characters(literal);
    }

    protected int normalizeWhitespace(int c) {
        if (c == 13 || c == 10) {
            c = 32;
        }
        return c;
    }

    protected String normalizeWhitespace(String s) {
        s = s.replaceAll("(\r|\n)", " ");
        return s;
    }

    protected Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private static class MarkupWriter
    extends Writer {
        private final Writer delegate;
        private char lastChar;
        private int trailingNewlineCount;
        private int characterCount;

        public MarkupWriter(Writer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (len <= 0) {
                return;
            }
            this.delegate.write(cbuf, off, len);
            this.characterCount += len;
            int lastCharIndex = off + len - 1;
            this.lastChar = cbuf[lastCharIndex];
            int newlineCount = this.countTailingNewlines(cbuf, off, len);
            this.trailingNewlineCount = newlineCount == len ? (this.trailingNewlineCount += newlineCount) : newlineCount;
        }

        private int countTailingNewlines(char[] cbuf, int off, int len) {
            char c;
            int newlineCount = 0;
            for (int x = off + len - 1; x >= off && (c = cbuf[x]) == '\n'; --x) {
                ++newlineCount;
            }
            return newlineCount;
        }

        public char getLastChar() {
            return this.lastChar;
        }

        public int getTrailingNewlineCount() {
            return this.trailingNewlineCount;
        }

        public int getCharacterCount() {
            return this.characterCount;
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public Writer getDelegate() {
            return this.delegate;
        }
    }

    protected class ImplicitParagraphBlock
    extends Block {
        private boolean hasContent;

        public ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH);
            this.hasContent = false;
        }

        @Override
        public void write(int c) throws IOException {
            this.hasContent = true;
            AbstractMarkupDocumentBuilder.this.emitContent(this.normalizeWhitespace(c));
        }

        @Override
        public void write(String s) throws IOException {
            this.hasContent = true;
            AbstractMarkupDocumentBuilder.this.emitContent(this.normalizeWhitespace(s));
        }

        @Override
        public void close() throws IOException {
            if (this.hasContent) {
                AbstractMarkupDocumentBuilder.this.emitContent("\n\n");
            }
            super.close();
        }

        protected int normalizeWhitespace(int c) {
            return AbstractMarkupDocumentBuilder.this.normalizeWhitespace(c);
        }

        protected String normalizeWhitespace(String s) {
            return AbstractMarkupDocumentBuilder.this.normalizeWhitespace(s);
        }

        @Override
        protected boolean isImplicitBlock() {
            return true;
        }
    }

    protected class NewlineDelimitedBlock
    extends Block {
        private final int precedingNewlineCount;
        private final int trailingNewlineCount;

        public NewlineDelimitedBlock(DocumentBuilder.BlockType blockType, int precedingNewlineCount, int trailingNewlineCount) {
            super(blockType);
            this.precedingNewlineCount = precedingNewlineCount;
            this.trailingNewlineCount = trailingNewlineCount;
        }

        @Override
        public void open() throws IOException {
            super.open();
            this.emitDelimiter(this.precedingNewlineCount);
        }

        private void emitDelimiter(int newlineCount) throws IOException {
            if (AbstractMarkupDocumentBuilder.this.getLastChar() != '\u0000') {
                int delimiterSize;
                for (int x = delimiterSize = newlineCount - AbstractMarkupDocumentBuilder.this.getTrailingNewlineCount(); x > 0; --x) {
                    AbstractMarkupDocumentBuilder.this.emitContent(10);
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.emitDelimiter(this.trailingNewlineCount);
            super.close();
        }
    }

    protected class SuffixBlock
    extends Block {
        private final String suffix;

        public SuffixBlock(DocumentBuilder.BlockType blockType, String suffix) {
            super(blockType);
            this.suffix = suffix;
        }

        @Override
        public void close() throws IOException {
            AbstractMarkupDocumentBuilder.this.emitContent(this.suffix);
            super.close();
        }
    }

    protected abstract class Block {
        private Block previousBlock;
        private final DocumentBuilder.BlockType blockType;

        protected Block(DocumentBuilder.BlockType blockType) {
            this.blockType = blockType;
        }

        public void write(int c) throws IOException {
        }

        public void write(String s) throws IOException {
        }

        public void open() throws IOException {
            this.previousBlock = AbstractMarkupDocumentBuilder.this.currentBlock;
            AbstractMarkupDocumentBuilder.this.currentBlock = this;
        }

        public void close() throws IOException {
            AbstractMarkupDocumentBuilder.this.currentBlock = this.previousBlock;
        }

        public Block getPreviousBlock() {
            return this.previousBlock;
        }

        public DocumentBuilder.BlockType getBlockType() {
            return this.blockType;
        }

        protected boolean isImplicitBlock() {
            return false;
        }
    }
}

