/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd.launch;

import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class SvdLaunchParams {
    private static final String[] SUPPORTED_LAUNCH_CONFIGURATION_TYPES = new String[]{"com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType", "com.nxp.s32ds.cle.s32esz.s250.simulator.core.s250SimulatorLaunchConfigurationType"};
    private static final String EMPTY_STRING = "";
    private static final String SVD_PATH = "com.nxp.s32ds.ext.cdt.debug.svd.svd_path";
    private static final String USE_DEFAULT = "com.nxp.s32ds.ext.cdt.debug.svd.use_default";
    private static final String MERGING_STRATEGY = "com.nxp.s32ds.ext.cdt.debug.svd.merge_strategy";
    private static final String CLEAN_WATCH_VIEW = "com.nxp.s32ds.ext.cdt.debug.svd.clean_watch_view";
    private static final String ASK_BEFORE_CLEAN = "com.nxp.s32ds.ext.cdt.debug.svd.ask_before_clean";
    private static final String DEFAULT_SVD_PATH = "";
    private static final boolean DEFAULT_USE_DEFAULT = true;
    private static final String DEFAULT_MERGE_ALL_STRATEGY = MERGE_STRATEGY.ALL.name();
    private static final boolean DEFAULT_CLEAN_WATCH_VIEW = false;
    private static final boolean DEFAULT_ASK_BEFORE_CLEAN = false;
    private String svdPath = "";
    private boolean useDefault = true;
    private String mergeStrategy = DEFAULT_MERGE_ALL_STRATEGY;
    private final boolean useSystemBus;
    private boolean cleanWatchView = false;
    private boolean askBeforeClean = false;

    public SvdLaunchParams(ILaunchConfiguration configuration) throws CoreException {
        this.svdPath = configuration.getAttribute(SVD_PATH, "");
        this.useDefault = configuration.getAttribute(USE_DEFAULT, true);
        this.mergeStrategy = configuration.getAttribute(MERGING_STRATEGY, DEFAULT_MERGE_ALL_STRATEGY);
        this.cleanWatchView = configuration.getAttribute(CLEAN_WATCH_VIEW, false);
        this.askBeforeClean = configuration.getAttribute(ASK_BEFORE_CLEAN, false);
        String configurationId = configuration.getType().getIdentifier();
        this.useSystemBus = Stream.of(SUPPORTED_LAUNCH_CONFIGURATION_TYPES).filter(type -> type.equals(configurationId)).findAny().isPresent();
    }

    public String getMergeStrategy() {
        return this.mergeStrategy;
    }

    public void setMergeStrategy(MERGE_STRATEGY strategy) {
        this.mergeStrategy = strategy.name();
    }

    public String getSvdPath() {
        return this.svdPath;
    }

    public void setSvdPath(String svdPath) {
        this.svdPath = svdPath;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }

    public boolean isUseSystemBus() {
        return this.useSystemBus;
    }

    public boolean isCleanWatchView() {
        return this.cleanWatchView;
    }

    public void setCleanWatchView(boolean cleanWatchView) {
        this.cleanWatchView = cleanWatchView;
    }

    public boolean isAskBeforeClean() {
        return this.askBeforeClean;
    }

    public void setAskBeforeClean(boolean askBeforeClean) {
        this.askBeforeClean = askBeforeClean;
    }

    public static void applyDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SVD_PATH, "");
        configuration.setAttribute(USE_DEFAULT, true);
        configuration.setAttribute(MERGING_STRATEGY, DEFAULT_MERGE_ALL_STRATEGY);
        configuration.setAttribute(CLEAN_WATCH_VIEW, false);
        configuration.setAttribute(ASK_BEFORE_CLEAN, false);
    }

    public void apply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SVD_PATH, this.svdPath);
        configuration.setAttribute(USE_DEFAULT, this.useDefault);
        configuration.setAttribute(MERGING_STRATEGY, this.mergeStrategy);
        configuration.setAttribute(CLEAN_WATCH_VIEW, this.cleanWatchView);
        configuration.setAttribute(ASK_BEFORE_CLEAN, this.askBeforeClean);
    }

    public static enum MERGE_STRATEGY {
        ALL,
        NONE;

    }
}

