/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.utils.Messages;
import com.nxp.swtools.common.uct.validation.ATextfieldWidthValidator;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;

public class StringLengthValidator
extends ATextfieldWidthValidator {
    protected boolean formatValid = true;

    public StringLengthValidator(int length) {
        super(length);
    }

    @Override
    public Status validate(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        this.formatValid = true;
        if (value.isEmpty()) {
            status = new Status(4, pluginId, Messages.EmptyTextfield);
        } else if (!NumberFormatValidator.HEXADECIMAL_CHAR_REGEXP.matcher(value).matches()) {
            status = new Status(4, pluginId, Messages.ErrMsg_InvalidHexString);
            this.formatValid = false;
        } else if (value.length() != this.getWidth()) {
            status = new Status(4, pluginId, MessageFormat.format(Messages.ErrMsg_InvalidHexStringLength, String.valueOf(this.getWidth())));
        }
        return status;
    }

    @Override
    public boolean isFormatValid() {
        return this.formatValid;
    }
}

