/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.utils.AProblemsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AUctProblemsManager<@NonNull T extends AUctProblem>
extends AProblemsManager<T> {
    public void clearProblems(IProblemSource source) {
        this.clearProblems(source, null);
    }

    public void clearProblems(IProblemSource source, @Nullable AUctProblem.Type type) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, source)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, source)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblemsForContainer(IProblemUIContainer container) {
        this.clearProblemsForContainer(container, null);
    }

    public void clearProblemsForContainer(IProblemUIContainer container, @Nullable AUctProblem.Type type) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, container)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, container)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblems(AUctProblem.Type type) {
        ArrayList<@NonNull AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            if (!problem.getType().name().equals(type.name())) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public List<@NonNull T> getProblemListForSource(IProblemSource source) {
        ArrayList<@NonNull AUctProblem> problemsFound = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            IProblemSource problemSource = problem.getProblemSource();
            if (!source.equals(problemSource)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    public List<@NonNull T> getProblemListForContainer(IProblemUIContainer container) {
        ArrayList<@NonNull AUctProblem> problemsFound = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            IProblemUIContainer problemContainer = problem.getSourceContainer();
            if (!container.equals(problemContainer)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    public List<@NonNull T> getProblemsListOfLevelError() {
        ArrayList<@NonNull AUctProblem> errorProblems = new ArrayList<AUctProblem>(this.problems);
        errorProblems.removeIf(p -> p.getProblemLevel() != 2);
        return errorProblems;
    }

    public boolean hasSourceProblemOfType(IProblemSource source, AUctProblem.Type type) {
        for (AUctProblem problem : this.problems) {
            if (!problem.getType().equals((Object)type) || !problem.getProblemSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProblems(List<@NonNull T> problemsList) {
        List list = this.problems;
        synchronized (list) {
            if (!problemsList.isEmpty()) {
                ValidationEngineFactory.addAndRemoveProblems(null, problemsList, null);
                this.problems.removeAll(problemsList);
            }
        }
    }

    private boolean shouldRemove(T problem, IProblemSource source) {
        return ((AUctProblem)((Object)problem)).getProblemSource().equals(source);
    }

    private boolean shouldRemove(T problem, IProblemUIContainer container) {
        IProblemUIContainer sourceContainer = ((AUctProblem)((Object)problem)).getSourceContainer();
        return sourceContainer != null && sourceContainer.equals(container);
    }

    public void clearAllProblemsForResource(String resourceId) {
        ArrayList<AUctProblem> problemsList = new ArrayList<AUctProblem>();
        for (AUctProblem problem : this.problems) {
            if (!problem.getResource().matches(String.format("(?i).*\\b%s\\b.*", Pattern.quote(resourceId)))) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public boolean hasNoProblemForSourceAndContainer(IProblemSource source, IProblemUIContainer container) {
        List<T> sourceProblems = this.getProblemListForSource(source);
        List<T> containerProblems = this.getProblemListForContainer(container);
        return sourceProblems.isEmpty() && containerProblems.isEmpty();
    }
}

