/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.ui.xml.settings;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.SelectionSetting;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="bool", strict=false)
public class BoolSetting
extends ABaseUIComponentSetting {
    private boolean currentSelection;
    @Nullable
    private ABaseUIComponentSetting parent;
    @ElementList(inline=true, required=false)
    private List<SelectionSetting> possibleSelections = new ArrayList<SelectionSetting>();

    public BoolSetting() {
        this.parent = null;
        this.currentSelection = false;
    }

    public BoolSetting(BoolSetting boolSetting, ABaseUIComponentSetting parent) {
        super(boolSetting.getId(), boolSetting);
        this.currentSelection = boolSetting.getCurrentValue().equalsIgnoreCase("true");
        this.parent = parent;
        this.possibleSelections = new ArrayList<SelectionSetting>(boolSetting.getPossibleSelections());
    }

    public boolean getDefaultValue() {
        return this.getInitValue().equalsIgnoreCase("true");
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.currentSelection = currentSelection;
    }

    public void setParent(@Nullable ABaseUIComponentSetting parent) {
        this.parent = parent;
    }

    public boolean isSelected() {
        return this.currentSelection;
    }

    public @Nullable ABaseUIComponentSetting getParent() {
        return this.parent;
    }

    @Override
    public long getValueToWrite() {
        if (this.possibleSelections.isEmpty()) {
            return this.currentSelection ? 1L : 0L;
        }
        for (SelectionSetting selectionSetting : this.possibleSelections) {
            if (!selectionSetting.getInitValue().equals(this.getCurrentValue())) continue;
            return selectionSetting.getValueToWrite();
        }
        return 0L;
    }

    @Override
    public String getCurrentValue() {
        return this.currentSelection ? "true" : "false";
    }

    @Override
    public void setCurrentValue(String currentValue) {
        super.setCurrentValue(currentValue);
        this.setCurrentSelection(currentValue.equalsIgnoreCase("true"));
    }

    public List<SelectionSetting> getPossibleSelections() {
        return this.possibleSelections;
    }

    public @Nullable SelectionSetting getCurrentSelectionSetting() {
        return this.getSelectionSettingBasedOnValue(Boolean.parseBoolean(this.getCurrentValue()));
    }

    public @Nullable SelectionSetting getSelectionSettingBasedOnValue(boolean value) {
        for (SelectionSetting setting : this.possibleSelections) {
            if (Boolean.parseBoolean(setting.getInitValue()) != value) continue;
            return setting;
        }
        return null;
    }
}

