/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.svd.utils;

import com.nxp.swtools.common.uct.svd.utils.AccessMode;
import com.nxp.swtools.common.uct.svd.utils.BitFieldInfo;
import com.nxp.swtools.common.uct.svd.utils.ClusterInfo;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@NonNullByDefault
public class RegisterInfo {
    private String name = "";
    private String description = "";
    private String size = "";
    private String offset = "";
    private String address = "";
    private AccessMode access = AccessMode.MODE_UNITIALIZED;
    private String resetValue = "";
    private String targetModule = "";
    private boolean tripleVoting = false;
    private boolean spreadTripleVoting = false;
    private boolean secondWrite = false;
    private boolean writeOnceOnly = false;
    private boolean writeZeroOnly = false;
    private boolean writeOneOnly = false;
    private int chipSelect = -1;
    private boolean parity = false;
    private Map<String, BitFieldInfo> bitfields = new HashMap<String, BitFieldInfo>();
    @Nullable
    private ClusterInfo cluster;
    public static final Comparator<RegisterInfo> compareByAddressDescending = new Comparator<RegisterInfo>(){

        @Override
        public int compare(@NonNull RegisterInfo left, @NonNull RegisterInfo right) {
            String leftString = left.getAddress();
            String rightString = right.getAddress();
            long leftValue = 0L;
            long rightValue = 0L;
            if (!leftString.isEmpty()) {
                leftValue = Long.parseLong(leftString.substring(2), 16);
            }
            if (!rightString.isEmpty()) {
                rightValue = Long.parseLong(rightString.substring(2), 16);
            }
            return (int)(rightValue - leftValue);
        }
    };

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address.startsWith("0x") ? address : "0x" + address;
    }

    public AccessMode getAccess() {
        return this.access;
    }

    public void setAccess(AccessMode access) {
        this.access = access;
    }

    public String getResetValue() {
        return this.resetValue;
    }

    public void setResetValue(String resetValue) {
        this.resetValue = resetValue;
    }

    public String getTargetModule() {
        return this.targetModule;
    }

    public void setTargetModule(String targetModule) {
        this.targetModule = targetModule;
    }

    public boolean hasTripleVoting() {
        return this.tripleVoting;
    }

    public void setTripleVoting(boolean tripleVoting) {
        this.tripleVoting = tripleVoting;
    }

    public boolean hasSpreadTripleVoting() {
        return this.spreadTripleVoting;
    }

    public void setSpreadTripleVoting(boolean spreadTripleVoting) {
        this.spreadTripleVoting = spreadTripleVoting;
    }

    public boolean hasSecondWrite() {
        return this.secondWrite;
    }

    public void setSecondWrite(boolean secondWrite) {
        this.secondWrite = secondWrite;
    }

    public boolean isWriteOnceOnly() {
        return this.writeOnceOnly;
    }

    public void setWriteOnceOnly(boolean writeOnceOnly) {
        this.writeOnceOnly = writeOnceOnly;
    }

    public boolean isWriteZeroOnly() {
        return this.writeZeroOnly;
    }

    public void setWriteZeroOnly(boolean writeZeroOnly) {
        this.writeZeroOnly = writeZeroOnly;
    }

    public boolean isWriteOneOnly() {
        return this.writeOneOnly;
    }

    public void setWriteOneOnly(boolean writeOneOnly) {
        this.writeOneOnly = writeOneOnly;
    }

    public int getChipSelect() {
        return this.chipSelect;
    }

    public void setChipSelect(int chipSelect) {
        this.chipSelect = chipSelect;
    }

    public boolean hasParity() {
        return this.parity;
    }

    public void setParity(boolean parity) {
        this.parity = parity;
    }

    public Map<String, BitFieldInfo> getBitfields() {
        return this.bitfields;
    }

    public void setBitFields(Map<String, BitFieldInfo> bitFields) {
        this.bitfields = bitFields;
    }

    public void setCluster(@Nullable ClusterInfo cluster) {
        this.cluster = cluster;
    }

    public @Nullable ClusterInfo getCluster() {
        return this.cluster;
    }

    public boolean belongsTo(@Nullable ClusterInfo parentCluster) {
        if (this.cluster == null || parentCluster == null) {
            return false;
        }
        ClusterInfo currentCluster = this.cluster;
        while (currentCluster != null) {
            if (currentCluster == parentCluster) {
                return true;
            }
            currentCluster = currentCluster.getParentCluster();
        }
        return false;
    }
}

