/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.internal.core.parser;

import com.nxp.s32ds.cle.cdt.internal.core.Messages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommandLineInputHandler
extends DefaultHandler {
    private StringBuilder stringBuilder = new StringBuilder();
    private String core;
    private String processorId;
    private String sdkPath;
    private String toolchain;
    private String debugger;
    private String language;
    private boolean isExec = true;
    private static final String[] MANDATORY_PARAMETERS = new String[]{"processorId", "core", "toolchain", "debugger", "language"};
    private Map<String, String> globalSettings = new HashMap<String, String>();
    private Map<String, String> projectSettings = new HashMap<String, String>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.stringBuilder.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equalsIgnoreCase("core")) {
            this.core = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("processorId")) {
            this.processorId = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("sdkPath")) {
            this.sdkPath = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("toolChain")) {
            this.toolchain = this.stringBuilder.toString();
        }
        if ((qName.equalsIgnoreCase("library") || qName.equalsIgnoreCase("io") || qName.equalsIgnoreCase("fpu") || qName.equalsIgnoreCase("language") || qName.equalsIgnoreCase("opmode") || qName.equalsIgnoreCase("lsp")) && !this.stringBuilder.toString().equals("")) {
            this.projectSettings.put(qName, this.stringBuilder.toString());
            if (qName.equalsIgnoreCase("language")) {
                this.language = this.stringBuilder.toString();
            }
        }
        if (qName.equalsIgnoreCase("debugger")) {
            this.globalSettings.put(qName, this.stringBuilder.toString());
            this.projectSettings.put(qName, this.stringBuilder.toString());
            this.debugger = this.stringBuilder.toString();
        }
        if (qName.equalsIgnoreCase("isExec")) {
            this.isExec = this.stringBuilder.toString().equalsIgnoreCase("true");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.stringBuilder.append(ch, start, length);
    }

    public String getCore() {
        return this.core;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public boolean isExec() {
        return this.isExec;
    }

    public String getSdkPath() {
        return this.sdkPath;
    }

    public String getToolchain() {
        return this.toolchain;
    }

    public String getDebugger() {
        return this.debugger;
    }

    public String getLanguage() {
        return this.language;
    }

    public Map<String, String> getProjectSettings() {
        return this.projectSettings;
    }

    public Map<String, String> getGlobalSettings() {
        return this.globalSettings;
    }

    public static CommandLineInputHandler parseInputFile(String filename) throws ParserConfigurationException, SAXException, IOException, CoreException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SAXParser saxParser = factory.newSAXParser();
        CommandLineInputHandler handler = new CommandLineInputHandler();
        saxParser.parse(filename, (DefaultHandler)handler);
        CommandLineInputHandler.validateMandatoryFields(handler);
        return handler;
    }

    private static void validateMandatoryFields(CommandLineInputHandler handler) throws CoreException {
        String errorMsg = null;
        Class<?> handlerClass = handler.getClass();
        String[] stringArray = MANDATORY_PARAMETERS;
        int n = MANDATORY_PARAMETERS.length;
        int n2 = 0;
        while (n2 < n) {
            String mandatoryParameter = stringArray[n2];
            Object mandatoryParameterValue = null;
            try {
                mandatoryParameterValue = handlerClass.getDeclaredMethod(CommandLineInputHandler.assembleGetterName(mandatoryParameter), null).invoke((Object)handler, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (mandatoryParameterValue == null) {
                errorMsg = NLS.bind((String)Messages.XML_missing_mandatory_parameter, (Object)mandatoryParameter);
            } else if (mandatoryParameterValue.toString().isBlank()) {
                errorMsg = NLS.bind((String)Messages.XML_empty_value_for_mandatory_parameter, (Object)mandatoryParameter);
            }
            if (errorMsg != null) {
                throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.core", errorMsg, new Throwable(errorMsg)));
            }
            ++n2;
        }
    }

    private static String assembleGetterName(String fieldName) {
        return "get" + Pattern.compile("^.").matcher(fieldName).replaceFirst(m -> m.group().toUpperCase());
    }
}

