/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.internal.core;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.ToolchainRegistry;
import com.nxp.s32ds.cle.cdt.internal.core.CommandLineException;
import com.nxp.s32ds.cle.cdt.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class XMLFieldValidator {
    public static final String ARCH_ID = "arm";
    private static final String[] EXTENSION_NAMES = new String[]{"Language", "IO", "FPU", "Library", "OPMODE", "LSP"};
    private static final String ATTRIBUTE_ID = "id";
    private static final String IGNORED_TOOLCHAINS_PATTERN = "cdt.managedbuild.toolchain.gnu";
    private static final String ACTIVATOR_PLUGIN_ID = "com.freescale.s32ds.cross.core";
    private static XMLFieldValidator instance = null;
    private final Map<String, Set<String>> validFieldValues = new HashMap<String, Set<String>>();

    private XMLFieldValidator() throws CommandLineException {
        this.extractValidProcessorsAndCores();
        String[] stringArray = EXTENSION_NAMES;
        int n = EXTENSION_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionName = stringArray[n2];
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core." + extensionName);
            if (ep != null) {
                this.extractExtensionValues(extensionName, ep);
            }
            ++n2;
        }
        this.validFieldValues.put("toolChain".toLowerCase(), new ToolchainRegistry().toolChainMap.keySet().stream().filter(x -> !x.contains(IGNORED_TOOLCHAINS_PATTERN)).collect(Collectors.toSet()));
        this.validFieldValues.put("debugger", DebuggerDescriptors.getDebuggerDescriptors().stream().map(EntityDescriptor::getId).filter(Objects::nonNull).collect(Collectors.toSet()));
        this.validFieldValues.put("sdkPath".toLowerCase(), SdkDescriptors.getSdkDescriptors().stream().map(EntityDescriptor::getId).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static synchronized XMLFieldValidator getInstance() throws CommandLineException {
        if (instance == null) {
            instance = new XMLFieldValidator();
        }
        return instance;
    }

    private void extractValidProcessorsAndCores() throws CommandLineException {
        HWModel archModel = Hardware.instance().getModel(ARCH_ID);
        if (archModel == null) {
            throw new CommandLineException(Messages.DSCmdApplication_failed_to_init_the_command_line_application);
        }
        List processorData = archModel.getProcessors();
        Set availableProcessors = processorData.stream().map(ConfigurationData::getId).collect(Collectors.toSet());
        HashSet availableCores = new HashSet();
        for (ProcessorData pData : processorData) {
            availableCores.addAll(pData.getCores().stream().map(ConfigurationData::getId).collect(Collectors.toSet()));
        }
        this.validFieldValues.put("processorid", availableProcessors);
        this.validFieldValues.put("core", availableCores);
    }

    private void extractExtensionValues(String extensionName, IExtensionPoint ep) {
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] ets = ext.getConfigurationElements();
            ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = ets;
            int n3 = ets.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                String lcName = ce.getName().toLowerCase();
                if (!lcName.endsWith("Set".toLowerCase())) {
                    elements.add(ce);
                }
                ++n4;
            }
            List notNullOptions = elements.stream().map(e -> e.getAttribute(ATTRIBUTE_ID)).collect(Collectors.toList());
            if (!this.validFieldValues.containsKey(extensionName.toLowerCase())) {
                this.validFieldValues.put(extensionName.toLowerCase(), new HashSet(notNullOptions));
            } else {
                this.validFieldValues.get(extensionName.toLowerCase()).addAll(notNullOptions);
            }
            ++n2;
        }
    }

    public void validateFields(Map<String, String> fields) throws CoreException {
        for (String label : fields.keySet()) {
            String valueToCheck = fields.getOrDefault(label, null);
            Set<String> collectionToCheck = this.validFieldValues.get(label);
            if (label.equalsIgnoreCase("sdkPath")) {
                this.validateSdks(valueToCheck, collectionToCheck);
                continue;
            }
            if (collectionToCheck != null && !collectionToCheck.isEmpty() && (collectionToCheck.isEmpty() || collectionToCheck.contains(valueToCheck))) continue;
            String errorMsg = NLS.bind((String)Messages.XML_invalid_parameter, (Object)valueToCheck, (Object)label);
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.core", errorMsg, new Throwable(errorMsg)));
        }
    }

    private void validateSdks(String fullInputSdks, Set<String> availableSdks) throws CoreException {
        String[] stringArray = fullInputSdks.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String individualSdk = stringArray[n2];
            if (!availableSdks.contains(individualSdk)) {
                String errorMsg = NLS.bind((String)Messages.XML_invalid_parameter, (Object)individualSdk, (Object)"sdk");
                throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.core", errorMsg, new Throwable(errorMsg)));
            }
            ++n2;
        }
    }

    public String getHelpMessageForParameter(String parameter, int numOptionsPerLine) {
        if (!this.validFieldValues.containsKey(parameter.toLowerCase())) {
            return NLS.bind((String)Messages.Help_unknown_parameter, (Object)parameter);
        }
        ArrayList options = new ArrayList(this.validFieldValues.get(parameter.toLowerCase()));
        Collections.sort(options);
        StringBuilder possibleParameterValues = new StringBuilder();
        possibleParameterValues.append(String.valueOf(System.lineSeparator()) + "\t");
        int optionCounter = 0;
        for (String option : options) {
            possibleParameterValues.append(String.valueOf(option) + "\t");
            if (++optionCounter % numOptionsPerLine != 0) continue;
            possibleParameterValues.append(String.valueOf(System.lineSeparator()) + "\t");
        }
        return NLS.bind((String)Messages.Parameter_possible_options, (Object)parameter, (Object)possibleParameterValues.toString());
    }

    public boolean isValidParameter(String parameter) {
        return this.validFieldValues.containsKey(parameter.toLowerCase());
    }
}

