/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.core;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.backend.ProjectGenerationContext;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.nxp.s32ds.cle.cdt.internal.core.Activator;
import com.nxp.s32ds.cle.cdt.internal.core.CommandLineException;
import com.nxp.s32ds.cle.cdt.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.internal.core.XMLFieldValidator;
import com.nxp.s32ds.cle.cdt.internal.core.parser.CommandLineInputHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.load.SdksLoader;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.OperationModeDescriptors;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.xml.sax.SAXException;

public class DSCmdApplication
implements IApplication {
    private static final String CORE = "core";
    private static final String NEW_PROJECT_FILE = "-newProjectFile";
    private static final String PROJECT_NAME = "-projectName";
    private static final List<String> HELP_ARG = Arrays.asList("-help", "--help", "-h");
    private static final String VALID_PROJECT_NAME_REGEX = "[a-zA-Z_]\\w*";
    private static final int USAGE_DEFAULT_NUM_OPTIONS_PER_LINE = 10;
    protected static final Logger LOGGER = Logger.getGlobal();
    private GeneralContext generalContext;
    private ProjectContext projectContext;
    private CommandLineInputHandler handler;
    private String projectName;

    public Object start(IApplicationContext context) throws Exception {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_first_line));
        try {
            if (this.parseInputArgs((String[])context.getArguments().get("application.args"))) {
                return IApplication.EXIT_OK;
            }
            if (!this.projectName.matches(VALID_PROJECT_NAME_REGEX)) {
                String errorMsg = NLS.bind((String)Messages.ImportProjectXml_Error_ProjectName, (Object)this.projectName);
                throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.core", errorMsg, new Throwable(errorMsg)));
            }
            this.initCMDLineApp();
            this.createProjectFromCommandLine();
        }
        catch (Exception e) {
            Activator.getBundle().logError(e.getMessage());
            throw e;
        }
        ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_start_last_line));
        return IApplication.EXIT_OK;
    }

    public void stop() {
        Activator.getBundle().log((IStatus)new Status(1, "com.nxp.s32ds.cle.cdt.core", Messages.DSCmdApplication_stop_called));
    }

    private boolean parseInputArgs(String[] args) throws CommandLineException, ParserConfigurationException, SAXException, IOException, CoreException {
        boolean showUsage = false;
        String paramInfo = null;
        int i = 0;
        while (i < args.length) {
            if (HELP_ARG.contains(args[i])) {
                showUsage = true;
                if (i + 1 >= args.length) break;
                paramInfo = args[i + 1];
                break;
            }
            this.parseInputFile(args, i);
            this.parseProjectName(args, i);
            ++i;
        }
        if (showUsage || this.handler == null || this.projectName == null) {
            this.showUsage(paramInfo);
            return true;
        }
        return false;
    }

    private void createProjectFromCommandLine() throws CommandLineException, CoreException {
        this.updateContext();
        ProjectGenerationContext projectGenerationContext = ProjectGenerationContext.start((GeneralContext)this.generalContext, (ProjectContext)this.projectContext);
        Map<String, String> projectSettings = this.handler.getProjectSettings();
        if (this.handler.getSdkPath() != null && !this.handler.getSdkPath().isBlank()) {
            projectSettings.put("sdkPath".toLowerCase(), this.handler.getSdkPath());
        }
        projectSettings.put("toolChain".toLowerCase(), this.handler.getToolchain());
        XMLFieldValidator.getInstance().validateFields(projectSettings);
        WizardBackend wb = new WizardBackend();
        wb.setCurrentContext(this.generalContext);
        wb.wrapCreateProject(projectGenerationContext, true, this.handler.getSdkPath());
    }

    private void updateContext() throws CommandLineException {
        HWModel archModel = Hardware.instance().getModel("arm");
        if (archModel == null) {
            throw new CommandLineException(Messages.DSCmdApplication_failed_to_init_the_command_line_application);
        }
        ProcessorData processorData = archModel.getProcessors().stream().filter(p -> p.getProcessorId().equals(this.handler.getProcessorId())).findFirst().orElse(null);
        if (processorData == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        if (processorData.getCores().stream().noneMatch(c -> c.getId().equals(this.handler.getCore()))) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_core, (Object)this.handler.getProcessorId(), (Object)this.handler.getCore()));
        }
        List cConf = CoreNatureConfiguration.getDefaults((ProcessorData)processorData, (boolean)this.handler.isExec(), (String)this.handler.getToolchain());
        this.generalContext = new GeneralContext(archModel);
        this.generalContext.setCurrentProcessorConfiguration(new ProcessorConfiguration(processorData, (Collection)cConf, this.handler.isExec()));
        this.generalContext.setProjectBaseName(this.projectName);
        this.generalContext.setExecutable(this.handler.isExec());
        DSCmdApplication.setValues(this.handler.getGlobalSettings(), (AbstractContext)this.generalContext);
        this.projectContext = this.getDefaultProjectContext();
        this.projectContext.setValue("debugger", (Object)this.handler.getProjectSettings().get("debugger"));
        DSCmdApplication.setValues(this.handler.getProjectSettings(), (AbstractContext)this.projectContext);
        this.setOpmode();
    }

    private void initCMDLineApp() throws CommandLineException, InterruptedException {
        int ret = PlatformUI.createAndRunWorkbench((Display)PlatformUI.createDisplay(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "no.ui.perspective";
            }

            public void eventLoopIdle(Display display) {
                PlatformUI.getWorkbench().close();
            }

            public boolean openWindows() {
                return true;
            }
        });
        if (ret != 0) {
            throw new CommandLineException(Messages.DSCmdApplication_error_occured_when_starting_the_workbench);
        }
        SdksLoader.sdkLoaderSemaphore.acquire();
    }

    private ProjectContext getDefaultProjectContext() throws CommandLineException {
        ProcessorContext currentContext = this.generalContext.getCurrentContext();
        if (currentContext == null) {
            throw new CommandLineException(Messages.DSCmdApplication_no_processor_defined_for_the_current_input);
        }
        currentContext.initData();
        List contextsList = currentContext.getProjectContexts();
        if (contextsList != null && contextsList.isEmpty()) {
            throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_any_core, (Object)this.handler.getProcessorId()));
        }
        for (CProjectContext pc : contextsList) {
            Map lValueMap = pc.getValueMap();
            if (pc.getValueMap() == null || !this.handler.getCore().equalsIgnoreCase(lValueMap.get(CORE).toString())) continue;
            pc.setActive(true);
            return pc;
        }
        throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_processor_does_not_contain_core, (Object)this.handler.getProcessorId(), (Object)this.handler.getCore()));
    }

    private static void setValues(Map<String, String> input, AbstractContext context) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            context.setValue(entry.getKey(), (Object)entry.getValue());
        }
    }

    private void setOpmode() {
        String opmodeValue = this.handler.getProjectSettings().get("opmode");
        for (CProjectContext proj : this.generalContext.getCurrentProcessorContext().getProjectContexts()) {
            if (opmodeValue == null) continue;
            proj.setValue("opmode", (Object)opmodeValue);
        }
        if (opmodeValue == null || !opmodeValue.equalsIgnoreCase("ls")) {
            return;
        }
        String contextDeviceCoreDescriptorId = DeviceDescriptors.getDeviceCoreDescriptor((String)this.projectContext.getStringValue(CORE)).getId();
        OperationModeDescriptors.getOpModeDescriptors().stream().filter(opModeDesc -> opModeDesc.getPrimary2Secondary().containsKey(contextDeviceCoreDescriptorId)).findFirst().ifPresent(e -> this.projectContext.setContextValue("opmodeCoreId", e.getDeviceCoreLocked()));
    }

    private void showUsage(String parameterInfo) throws CommandLineException {
        if (LOGGER.isLoggable(Level.INFO)) {
            if (parameterInfo == null || !XMLFieldValidator.getInstance().isValidParameter(parameterInfo)) {
                LOGGER.log(Level.INFO, NLS.bind((String)Messages.DSCmdApplication_help, (Object)System.getProperty("eclipse.launcher", "PROGRAM")));
            } else {
                String helpMessage = XMLFieldValidator.getInstance().getHelpMessageForParameter(parameterInfo, 10);
                LOGGER.log(Level.INFO, helpMessage);
            }
        }
    }

    private void parseInputFile(String[] args, int i) throws CommandLineException, ParserConfigurationException, SAXException, IOException, CoreException {
        if (NEW_PROJECT_FILE.equals(args[i])) {
            if (i + 1 == args.length) {
                throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_argument_should_be_followed_by_a_valid_xml_file, (Object)NEW_PROJECT_FILE));
            }
            this.handler = CommandLineInputHandler.parseInputFile(args[i + 1]);
        }
    }

    private void parseProjectName(String[] args, int i) throws CommandLineException {
        if (PROJECT_NAME.equals(args[i])) {
            if (i + 1 == args.length) {
                throw new CommandLineException(NLS.bind((String)Messages.DSCmdApplication_argument_should_be_followed_by_a_valid_xml_file, (Object)NEW_PROJECT_FILE));
            }
            this.projectName = args[i + 1];
        }
    }
}

