/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.ClockConsumers;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.registers.RegistersFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.InitializationPriorities;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.mcu.Mcu;
import com.nxp.swtools.periphs.model.resources.AProcessorFilterForPeripherals;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.EmptySdkFeatures;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.provider.features.SdkFeaturesProvider;
import com.nxp.swtools.resourcetables.model.data.Category;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.resources.AProcessorFilterForResourceTable;
import com.nxp.swtools.utils.profiler.Profiler;
import com.nxp.swtools.utils.registers.EmptyRegistersDB;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.script.CompiledScript;

public class McuFactory {
    private static final String CODEGENERATOR_JS_FILENAME = "codegenerator.js";
    protected static final Logger LOGGER = LogManager.getLogger(McuFactory.class);

    public static @Nullable IMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig, AProcessorFilterForPeripherals toolFilter) {
        return McuFactory.create(supportedDerivatives, commonConfig, toolFilter, true);
    }

    public static @Nullable IMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig, AProcessorFilterForPeripherals toolFilter, boolean needsConsistentResources) {
        String sdkVersion;
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        IRegistersDatabaseAPI registers = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        Profiler profilerInstance = Profiler.getInstance((Object)"Peripherals");
        BigInteger index = profilerInstance.start(McuFactory.class, (Object)MessageFormat.format("Load SDK features of mcu \"{0}\"", commonConfig.getMcu()));
        SdkFeatures sdkFeatures = McuFactory.getSdkFeatures(supportedDerivatives, mcuSelection);
        profilerInstance.stop(index, McuFactory.class, null);
        if (sdkFeatures == null) {
            return null;
        }
        String mcuName = mcuSelection.getMcu();
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcuName, (String)(sdkVersion = mcuSelection.getSdkVersion()), (ISupportedDerivativesForSwTools)supportedDerivatives);
        ArrayList<ProcessorCore> cores = coresInfo == null ? new ArrayList<ProcessorCore>() : coresInfo.cores;
        AvailableComponents availableComponents = new AvailableComponents(mcuSelection, registers, toolFilter);
        index = profilerInstance.start(McuFactory.class, (Object)MessageFormat.format("Load resource tables of MCU \"{0}\"", commonConfig.getMcu()));
        McuResourceTables mcuResourceTables = McuResourceTables.getInstance((IMcuIdentification)mcuSelection, (AProcessorFilterForResourceTable)toolFilter);
        profilerInstance.stop(index, McuFactory.class, null);
        index = profilerInstance.start(McuFactory.class, (Object)MessageFormat.format("Load resource tables of components that are usable on MCU \"{0}\"", commonConfig.getMcu()));
        AvailableResourceTables availableResourceTables = new AvailableResourceTables(mcuResourceTables, availableComponents, toolFilter);
        profilerInstance.stop(index, McuFactory.class, null);
        if (availableComponents.getConfigCompTypeIds().isEmpty() || availableResourceTables.getResourceTables().isEmpty()) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Cannot load configuration components and/or resource tables for: {0}", mcuSelection));
            } else {
                return null;
            }
        }
        IProcessorMasterToolInfo masterToolInfo = supportedDerivatives.getProcessorMasterToolInfo(mcuName, sdkVersion);
        assert (masterToolInfo != null);
        PeripheralComponentFile clockConsumers = null;
        clockConsumers = ClockConsumers.getInstance().getPeripheralComponentFile(masterToolInfo, mcuSelection.getPackage());
        if (clockConsumers.isLegacy()) {
            LOGGER.warning("[DATA] Legacy clock consumers format");
        } else if (clockConsumers.getPeriphComponents().isEmpty() && clockConsumers.getSignalInstances().isEmpty()) {
            LOGGER.severe("[DATA] Cannot load clock consumers, because there are no components in clock consumers");
        }
        ConfigurationComponentTypeId systemComponent = McuFactory.getSystemComponent(availableComponents, mcuSelection);
        String[] scriptFileFolders = systemComponent != null ? McuFactory.getScriptFileFolders(systemComponent, (IMcuIdentification)commonConfig, toolFilter) : new String[]{};
        CompiledScript compileCodeGenerator = systemComponent != null ? McuFactory.compileCodeGenerator(systemComponent, (IMcuIdentification)commonConfig, toolFilter) : null;
        Categories loadCategories = systemComponent != null ? McuFactory.getCategories(systemComponent) : null;
        InitializationPriorities loadPriorities = systemComponent != null ? McuFactory.getInitializationPriorities(systemComponent) : null;
        Mcu mcu = new Mcu(availableComponents, mcuResourceTables, availableResourceTables, sdkFeatures, registers, mcuSelection, masterToolInfo, cores, clockConsumers, systemComponent, scriptFileFolders, compileCodeGenerator, loadCategories, loadPriorities);
        availableResourceTables.associateResources(mcu);
        return mcu;
    }

    private static String[] getScriptFileFolders(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification, AProcessorFilterForPeripherals toolFilter) {
        String componentsDir = toolFilter.getPeripheralsComponentsDir(mcuIdentification);
        String systemCompDir = String.valueOf(componentsDir) + File.separator + systemComponent.getTypeId();
        String[] folders = new String[]{systemCompDir};
        return folders;
    }

    private static @Nullable Categories getCategories(ConfigurationComponentTypeId systemComponent) {
        Path categoriesDir = systemComponent.getFileLocation();
        Categories categories = null;
        List categoriesDirFiles = UtilsFile.findAllFiles((String)UtilsText.safeString((String)categoriesDir.toString()), (boolean)false);
        for (String filePath : categoriesDirFiles) {
            String fileName;
            File file = new File(filePath);
            if (!file.exists() || !(fileName = file.getName()).matches("categories.*\\.xml")) continue;
            Categories newCategories = Categories.loadCategoriesFromFile(file);
            if (categories != null) {
                if (newCategories == null) continue;
                for (Category category : newCategories.getCategories()) {
                    if (categories.getCategories().contains(category)) continue;
                    categories.addCategory(category);
                }
                continue;
            }
            categories = newCategories;
        }
        return categories;
    }

    private static @Nullable InitializationPriorities getInitializationPriorities(ConfigurationComponentTypeId systemComponent) {
        Path prioritiesDir = systemComponent.getFileLocation();
        File prioritiesFile = prioritiesDir.resolve("initialization_priorities.xml").toFile();
        InitializationPriorities priorities = prioritiesFile.exists() ? InitializationPriorities.loadPrioritiesFromFile(prioritiesFile) : null;
        return priorities;
    }

    public static @Nullable ConfigurationComponentTypeId getSystemComponent(AvailableComponents availableComponents, IMcuIdentification mcuIdentification) {
        List<ConfigurationComponentTypeId> confCompTypeIds = availableComponents.getComponentTypeIdsByType("system");
        if (confCompTypeIds == null) {
            LOGGER.severe(String.format("[DATA] Peripherals configuration component \"%1s\" either does not exist or its version is not supported by the %2s MCU", "system", mcuIdentification.getPackage()));
            return null;
        }
        assert (!confCompTypeIds.isEmpty());
        if (confCompTypeIds.size() > 1) {
            LOGGER.severe(String.format("[DATA] Peripherals configuration component \"%1s\" exists in %2s versions for the %3s MCU", "system", String.valueOf(confCompTypeIds.size()), mcuIdentification.getPackage()));
        }
        return confCompTypeIds.get(0);
    }

    private static @Nullable CompiledScript compileCodeGenerator(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification, AProcessorFilterForPeripherals toolFilter) {
        Profiler profilerInstance = Profiler.getInstance((Object)"Peripherals");
        BigInteger index = profilerInstance.start(McuFactory.class, (Object)"Compile code generator script file");
        CompiledScript compiledScript = null;
        Object[] scriptFileFolders = McuFactory.getScriptFileFolders(systemComponent, mcuIdentification, toolFilter);
        ScriptFileProvider scriptFileProvider = new ScriptFileProvider((String[])scriptFileFolders);
        File file = scriptFileProvider.findScriptFile(CODEGENERATOR_JS_FILENAME);
        if (file != null) {
            compiledScript = JavaScriptHelper.compile((File)file);
            if (compiledScript == null) {
                LOGGER.warning("[DATA] Compilation of code generator failed!");
            }
        } else {
            LOGGER.severe(MessageFormat.format("[DATA] Code generator script \"{0}\" not found at these paths: {1}", CODEGENERATOR_JS_FILENAME, Arrays.toString(scriptFileFolders)));
        }
        profilerInstance.stop(index, McuFactory.class, null);
        return compiledScript;
    }

    protected static @Nullable IRegistersDatabaseAPI getRegisters(ISupportedDerivativesForSwTools supportedDerivatives, IMcuIdentification mcuSelection) {
        IRegistersDatabaseAPI registers = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (registers == null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("[TOOL] Cannot load registers for: {0}", mcuSelection));
            registers = EmptyRegistersDB.INSTANCE;
        }
        return registers;
    }

    protected static @Nullable SdkFeatures getSdkFeatures(ISupportedDerivativesForSwTools supportedDerivatives, IMcuIdentification mcuSelection) {
        SdkFeatures sdkFeatures = SdkFeaturesProvider.getSdkFeatures((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (sdkFeatures == null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("[TOOL] Cannot load SDK features for: {0}", mcuSelection));
            sdkFeatures = EmptySdkFeatures.INSTANCE;
        }
        return sdkFeatures;
    }
}

