/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigSetReference;
import com.nxp.swtools.periphs.model.data.XMLConstants;
import com.nxp.swtools.resourcetables.model.XSDUtils;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.FunctionDef;
import com.nxp.swtools.resourcetables.model.data.IConfigSet;
import com.nxp.swtools.resourcetables.model.data.IConfigSetReference;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.Migrations;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.OptionsMap;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.data.Script;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.UserFunctions;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.UiName;
import com.nxp.swtools.utils.profiler.Profiler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.core.Validate;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.xml.sax.SAXException;

@Root(name="config_component", strict=false)
@Namespace(prefix="component", reference="http://swtools.freescale.net/XSD/component/1.0")
@Order(attributes={"id"})
public class ConfigurationComponent
extends UiName
implements IConfigurationComponent {
    private static final Persister PERSISTER = new Persister();
    public static final String SYSTEM_COMPONENT_ID = "system";
    public static final String SYSTEM_COMPONENT_CATEGORY_ID = "System";
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationComponent.class);
    private static final String LOCAL_SCHEMA = XMLConstants.COMPONENT_SCHEMA_FILENAME;
    @Attribute(name="id")
    private String id;
    @Attribute(name="unique_id", required=false)
    @Nullable
    private @Attribute(name="unique_id", required=false) @Nullable String uniqueId;
    @Attribute(name="max_instances", required=false)
    @Nullable
    private @Attribute(name="max_instances", required=false) @Nullable String maxInstances;
    @Attribute(name="max_functional_groups", required=false)
    @Nullable
    private @Attribute(name="max_functional_groups", required=false) @Nullable String maxFunctionalGroups;
    @Attribute(name="category", required=false)
    @Nullable
    private @Attribute(name="category", required=false) @Nullable String category;
    @Attribute(name="options", required=false)
    @Nullable
    private @Attribute(name="options", required=false) @Nullable String options;
    @Attribute(name="registers_init", required=false)
    private boolean registersInit;
    @Attribute(name="no_init", required=false)
    private boolean noInit;
    @Element(type=OptionsExpr.class, name="options_expr", required=false)
    @Nullable
    private @Element(type=OptionsExpr.class, name="options_expr", required=false) @Nullable OptionsExpr optionsExpr;
    private OptionsMap optionsMap;
    @Nullable
    private Expression maxInstancesExpression;
    @Nullable
    private Expression maxFunctionalGroupsExpression;
    @ElementList(inline=true, required=false)
    private List<SWComponent> components;
    @Element(name="default_view", required=false)
    @Nullable
    private @Element(name="default_view", required=false) @Nullable String defaultViewId;
    @Element(name="description", required=false)
    @Nullable
    private @Element(name="description", required=false) @Nullable Description description;
    @ElementList(inline=true, required=false)
    private List<Mode> modes;
    @Element(name="script", required=false)
    @Nullable
    private @Element(name="script", required=false) @Nullable Script script;
    @Element(name="user_functions", required=false)
    @Nullable
    private @Element(name="user_functions", required=false) @Nullable UserFunctions userFunctions;
    @ElementList(inline=true, type=ConfigSet.class, required=false)
    private List<IConfigSet> configSets;
    @ElementList(inline=true, type=ConfigSetReference.class, required=false)
    private List<IConfigSetReference> configSetReferences = new ArrayList<IConfigSetReference>(0);
    @Element(name="global_config_set_ref", required=false)
    @Nullable
    private @Element(name="global_config_set_ref", required=false) @Nullable String globalConfigSetRef;
    @Attribute(name="global_only", required=false)
    private boolean globalOnly;
    @Attribute(name="hidden", required=false)
    private boolean hidden;
    @Attribute(name="auto_add", required=false)
    private boolean autoAdd;
    @Nullable
    private String autoAddGlobalComponents;
    @Nullable
    private String autoAddComponents;
    @Nullable
    private String autoAddOptionalComponents;
    @Nullable
    private Expression autoAddComponentsLimit;
    @Nullable
    private Expression autoAddInstances;
    @Nullable
    private Expression autoAddInstancesPerConfiguration;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @Attribute(name="automatic_migration_from", required=false)
    @Nullable
    private @Attribute(name="automatic_migration_from", required=false) @Nullable String automaticMigration;
    @Attribute(name="variant", required=false)
    private String variant = "";
    @Element(name="migrations", required=false)
    @Nullable
    private @Element(name="migrations", required=false) @Nullable Migrations migrations = null;
    @Nullable
    IConfigSet globalConfigSet;

    @Attribute(name="auto_add_global_components", required=false)
    public void setAutoAddGlobalComponents(@Nullable String input) {
        this.autoAddGlobalComponents = input;
    }

    @Attribute(name="auto_add_global_components", required=false)
    public @Attribute(name="auto_add_global_components", required=false) @Nullable String getAutoAddGlobalComponents() {
        return this.autoAddGlobalComponents;
    }

    @Attribute(name="auto_add_components", required=false)
    public void setAutoAddComponents(@Nullable String input) {
        this.autoAddComponents = input;
    }

    @Attribute(name="auto_add_components", required=false)
    public @Attribute(name="auto_add_components", required=false) @Nullable String getAutoAddComponents() {
        return this.autoAddComponents;
    }

    @Attribute(name="auto_add_optional_components", required=false)
    public void setAutoAddComponentsOptional(@Nullable String input) {
        this.autoAddOptionalComponents = input;
    }

    @Attribute(name="auto_add_optional_components", required=false)
    public @Attribute(name="auto_add_optional_components", required=false) @Nullable String getAutoAddComponentsOptional() {
        return this.autoAddOptionalComponents;
    }

    @Attribute(name="auto_add_components_limit", required=false)
    public void setAutoAddComponentsLimitString(@Nullable String input) {
        this.autoAddComponentsLimit = UtilsText.isEmpty((String)input) ? null : Expression.create((String)UtilsText.safeString((String)input));
    }

    @Attribute(name="auto_add_components_limit", required=false)
    public @Attribute(name="auto_add_components_limit", required=false) @Nullable String getAutoAddComponentsLimitString() {
        return this.autoAddComponentsLimit != null ? this.autoAddComponentsLimit.formatOutput(FormatOptions.DEFAULT) : "";
    }

    public @Nullable Expression getAutoAddComponentsLimit() {
        return this.autoAddComponentsLimit;
    }

    @Attribute(name="auto_add_instances", required=false)
    public void setAutoAddInstancesString(@Nullable String expressionString) {
        this.autoAddInstances = UtilsText.isEmpty((String)expressionString) ? null : Expression.create((String)UtilsText.safeString((String)expressionString));
    }

    @Attribute(name="auto_add_instances", required=false)
    public @Attribute(name="auto_add_instances", required=false) String getAutoAddInstancesString() {
        return this.autoAddInstances != null ? this.autoAddInstances.formatOutput(FormatOptions.DEFAULT) : "";
    }

    @Attribute(name="auto_add_instances_per_configuration", required=false)
    public void setAutoAddInstancesPerConfigurationString(@Nullable String expressionString) {
        this.autoAddInstancesPerConfiguration = UtilsText.isEmpty((String)expressionString) ? null : Expression.create((String)UtilsText.safeString((String)expressionString));
    }

    @Attribute(name="auto_add_instances_per_configuration", required=false)
    public @Attribute(name="auto_add_instances_per_configuration", required=false) String getAutoAddInstancesPerConfigurationString() {
        return this.autoAddInstancesPerConfiguration != null ? this.autoAddInstancesPerConfiguration.formatOutput(FormatOptions.DEFAULT) : "";
    }

    public @Nullable Expression getAutoAddInstancesExpression() {
        return this.autoAddInstances;
    }

    public @Nullable Expression getAutoAddInstancesPerConfigurationExpression() {
        return this.autoAddInstancesPerConfiguration;
    }

    public ConfigurationComponent(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String category, @Nullable String options, @Nullable OptionsExpr optionsExpr, List<SWComponent> components, @Nullable String globalConfigSetRef, @Nullable Description description, boolean globalOnly, @Nullable Script script, @Nullable UserFunctions userFunctions, boolean hidden, boolean autoAdd, @Nullable String maxInstances, @Nullable String maxFunctionalGroups, @Nullable Migrations migrations) {
        super(uiName, uiNameExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.schemaLocation = XMLConstants.COMPONENT_SCHEMA_LOC;
        this.id = id;
        this.category = category;
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap((String)options, (OptionsExpr)optionsExpr, (IID)this);
        this.components = components;
        this.globalConfigSetRef = globalConfigSetRef;
        this.configSets = new ArrayList<IConfigSet>(1);
        this.modes = new ArrayList<Mode>();
        this.script = script;
        this.userFunctions = userFunctions;
        this.globalConfigSet = null;
        this.description = description;
        this.globalOnly = globalOnly;
        this.hidden = hidden;
        this.autoAdd = autoAdd;
        this.maxInstances = maxInstances;
        if (maxInstances != null) {
            this.maxInstancesExpression = Expression.tryCreate((String)maxInstances);
        }
        this.maxFunctionalGroups = maxFunctionalGroups;
        if (maxFunctionalGroups != null) {
            this.maxFunctionalGroupsExpression = Expression.tryCreate((String)maxFunctionalGroups);
        }
        this.migrations = migrations;
    }

    @Deprecated
    protected ConfigurationComponent() {
        this("", null, null, null, null, null, new ArrayList<SWComponent>(), null, null, false, null, null, false, false, null, null, null);
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Component with ID \"{0}\" specifies an invalid schema location \"{1}\"", this.id, this.schemaLocation));
            }
            return "";
        }
        String loc = locPair[1];
        return loc;
    }

    public String getId() {
        return this.id;
    }

    public @Nullable String getUniqueId() {
        return this.uniqueId;
    }

    public @Nullable String getDefaultViewId() {
        return this.defaultViewId;
    }

    public Collection<String> getPresentOptions() {
        return this.optionsMap.getPresentOptions();
    }

    public @Nullable Object getOptionValue(String key, IContext context) {
        return this.optionsMap.getOptionValue(key, context);
    }

    public boolean isOptionSet(String option) {
        return this.optionsMap.isOptionSet(option);
    }

    public boolean isOptionAvailable(String option, IContext context) {
        return this.optionsMap.isAvailable(option, context);
    }

    @Commit
    public void commit() {
        if (this.options != null || this.optionsExpr != null) {
            this.optionsMap = SettingUtils.createOptionsMap((String)this.options, (OptionsExpr)this.optionsExpr, (IID)this);
        }
        if (this.maxInstances != null) {
            try {
                this.maxInstancesExpression = Expression.create((String)this.maxInstances);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Maximum instances of component \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
        if (this.maxFunctionalGroups != null) {
            try {
                this.maxFunctionalGroupsExpression = Expression.create((String)this.maxFunctionalGroups);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Maximum number of functional groups of component \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    public @Nullable String getOptions() {
        return this.options;
    }

    public @Nullable OptionsExpr getOptionsExpression() {
        return this.optionsExpr;
    }

    public void setOptions(@Nullable String options, @Nullable OptionsExpr optionsExpr) {
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap((String)this.options, (OptionsExpr)this.optionsExpr, (IID)this);
    }

    public boolean isGlobalOnly() {
        return this.globalOnly;
    }

    public boolean isRegistersInitialization() {
        return this.registersInit;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAutoAdding() {
        return this.autoAdd;
    }

    public boolean isNoInit() {
        return this.noInit;
    }

    public List<String> getListOfGlobalComponentsToBeAddedAutomatically() {
        return ConfigurationComponent.commaSeparatedStringToList(this.autoAddGlobalComponents);
    }

    public List<String> getListOfComponentsToBeAddedAutomatically() {
        return ConfigurationComponent.commaSeparatedStringToList(this.autoAddComponents);
    }

    public List<String> getListOfOptionalComponentsToBeAddedAutomatically() {
        return ConfigurationComponent.commaSeparatedStringToList(this.autoAddOptionalComponents);
    }

    private static List<String> commaSeparatedStringToList(@Nullable String input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return (List)Stream.of(input.split(",")).map(String::trim).collect(CollectorsUtils.toList());
    }

    public @Nullable IConfigSet findConfigSet(String confSetID) {
        if (this.globalConfigSet != null && this.globalConfigSet.getId().equals(confSetID)) {
            return this.globalConfigSet;
        }
        return (IConfigSet)CollectionsUtils.nullableOptionalGet(this.configSets.stream().filter(x -> x.getId().equals(confSetID)).findFirst());
    }

    public boolean addMode(Mode mode) {
        return this.modes.add(mode);
    }

    public boolean addUserFunction(FunctionDef def) {
        UserFunctions userFunctionsLoc = this.userFunctions;
        if (userFunctionsLoc == null) {
            userFunctionsLoc = this.userFunctions = new UserFunctions(new ArrayList());
        }
        return userFunctionsLoc.addFunctionDef(def);
    }

    public List<IConfigSet> getConfigSets() {
        return CollectionsUtils.unmodifiableList(this.configSets);
    }

    public List<IConfigSetReference> getConfigSetReferences() {
        return CollectionsUtils.unmodifiableList(this.configSetReferences);
    }

    public List<Mode> getScenarios() {
        return CollectionsUtils.unmodifiableList(this.modes);
    }

    public List<SWComponent> getComponents() {
        return this.components;
    }

    public @Nullable Mode getMode(String modeId) {
        for (Mode mode : this.modes) {
            if (!modeId.equals(mode.getId())) continue;
            return mode;
        }
        return null;
    }

    public @Nullable Script getScript() {
        return this.script;
    }

    public @Nullable UserFunctions getUserFunctions() {
        return this.userFunctions;
    }

    public @Nullable IConfigSet getConfigSet(String configSetId) {
        for (IConfigSet configSet : this.configSets) {
            if (!configSetId.equals(configSet.getId())) continue;
            return configSet;
        }
        return null;
    }

    public @Nullable Description getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getLabel(IContext context) {
        return this.getUIName(context);
    }

    public @Nullable String getCategory() {
        return this.category;
    }

    public List<String> getAutomaticMigrations() {
        String automaticMigrationLoc = this.automaticMigration;
        return ConfigurationComponent.commaSeparatedStringToList(automaticMigrationLoc);
    }

    public String getVariant() {
        return this.variant;
    }

    public void setAutomaticMigration(String newAutomaticMigration) {
        this.automaticMigration = newAutomaticMigration;
    }

    public void setVariant(String newVariant) {
        this.variant = newVariant;
    }

    public boolean hasAutomaticMigration() {
        return !UtilsText.isEmpty((String)this.automaticMigration);
    }

    public @Nullable Migrations getMigrations() {
        return this.migrations;
    }

    @Validate
    private void validate() {
        if (!UtilsText.isEmpty((String)this.globalConfigSetRef) && this.configSets.isEmpty() && this.configSetReferences.isEmpty()) {
            LOGGER.log(Level.SEVERE, "[DATA] At least one config set or config set reference is required in component with ID \"{0}\"", this.id);
        }
    }

    public @Nullable IConfigSet getGlobalConfigSet() {
        return this.globalConfigSet;
    }

    public void updateGlobalConfigSetFromReference() {
        if (this.globalConfigSet == null && this.globalConfigSetRef != null) {
            IConfigSet globalConfigSetLoc = (IConfigSet)CollectionsUtils.nullableOptionalGet(this.configSets.stream().filter(x -> x.getId().equals(this.globalConfigSetRef)).findFirst());
            if (globalConfigSetLoc == null) {
                LOGGER.severe(MessageFormat.format("[DATA] [{0}] Component with ID \"{1}\" references an unknown global config-set with ID \"{2}\"", this.getId(), this.id, this.globalConfigSetRef));
            }
            this.globalConfigSet = globalConfigSetLoc;
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + super.toString() + ", " + "category" + "=" + this.getCategory() + ", " + "options" + "=" + this.getOptions() + ", " + "options_expr" + "=" + this.getOptionsExpression() + ", components(fst " + 3 + ")=" + CollectionsUtils.firstN(this.components, (int)3) + ", " + "description" + "=" + this.getDescription() + ", " + "global_only" + "=" + this.isGlobalOnly() + ", " + "hidden" + "=" + this.isHidden() + ", modes(fst " + 3 + ")=" + CollectionsUtils.firstN(this.modes, (int)3) + ", " + "script" + "=" + this.getScript() + ", " + "user_functions" + "=" + this.getUserFunctions() + ", " + "global_config_set_ref" + "=" + this.getGlobalConfigSet() + ", configSets(fst " + 3 + ")=" + CollectionsUtils.firstN(this.configSets, (int)3) + ", " + "migrations" + "=" + this.getMigrations() + "]";
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.components);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Boolean.hashCode(this.globalOnly);
        result = 31 * result + Boolean.hashCode(this.hidden);
        result = 31 * result + Boolean.hashCode(this.autoAdd);
        result = 31 * result + Objects.hashCode(this.autoAddGlobalComponents);
        result = 31 * result + Objects.hashCode(this.autoAddComponents);
        result = 31 * result + Objects.hashCode(this.autoAddComponentsLimit);
        result = 31 * result + Objects.hashCode(this.autoAddInstances);
        result = 31 * result + this.configSets.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.category);
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.optionsExpr);
        result = 31 * result + this.modes.hashCode();
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.userFunctions);
        result = 31 * result + Objects.hashCode(this.globalConfigSetRef);
        result = 31 * result + Objects.hashCode(this.migrations);
        result = 31 * result + Objects.hashCode(this.maxInstances);
        result = 31 * result + Objects.hashCode(this.maxFunctionalGroups);
        result = 31 * result + Objects.hashCode(this.automaticMigration);
        result = 31 * result + Objects.hashCode(this.variant);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ConfigurationComponent other = (ConfigurationComponent)((Object)obj);
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        if (!Objects.equals(this.options, other.options)) {
            return false;
        }
        if (!Objects.equals(this.optionsExpr, other.optionsExpr)) {
            return false;
        }
        if (!Objects.equals(this.components, other.components)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (this.globalOnly != other.globalOnly) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (this.autoAdd != other.autoAdd) {
            return false;
        }
        if (!Objects.equals(this.autoAddGlobalComponents, other.autoAddGlobalComponents)) {
            return false;
        }
        if (!Objects.equals(this.autoAddComponents, other.autoAddComponents)) {
            return false;
        }
        if (!Objects.equals(this.autoAddComponentsLimit, other.autoAddComponentsLimit)) {
            return false;
        }
        if (!Objects.equals(this.autoAddInstances, other.autoAddInstances)) {
            return false;
        }
        if (!this.configSets.equals(other.configSets)) {
            return false;
        }
        if (!this.configSetReferences.equals(other.configSetReferences)) {
            return false;
        }
        if (!this.modes.equals(other.modes)) {
            return false;
        }
        if (!Objects.equals(this.script, other.script)) {
            return false;
        }
        if (!Objects.equals(this.userFunctions, other.userFunctions)) {
            return false;
        }
        if (!Objects.equals(this.globalConfigSetRef, other.globalConfigSetRef)) {
            return false;
        }
        if (!Objects.equals(this.migrations, other.migrations)) {
            return false;
        }
        if (!Objects.equals(this.maxInstances, other.maxInstances)) {
            return false;
        }
        if (!Objects.equals(this.maxFunctionalGroups, other.maxFunctionalGroups)) {
            return false;
        }
        if (!Objects.equals(this.automaticMigration, other.automaticMigration)) {
            return false;
        }
        return Objects.equals(this.variant, other.variant);
    }

    public boolean saveToFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(fileName);){
                this.saveToStream(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Error saving component file \"{0}\"", fileName), e);
            return false;
        }
        return true;
    }

    public String saveToString() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.saveToStream(out);
                return new String(out.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warning(MessageFormat.format("[TOOL] Error saving to string: {0}", e.getMessage()));
            return "";
        }
    }

    public void saveToStream(OutputStream out) throws Exception {
        Format format = new Format(4, "<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)this, out);
    }

    public static @Nullable ConfigurationComponent loadComponentFromFile(File source, LoadMode mode, @Nullable Collection<String> configSetIds) {
        ComponentLoadingStatus.getInstanceForCurrentThread().setCurrentlyLoadingComponent(source);
        try {
            ConfigurationComponent configurationComponent;
            block42: {
                Throwable throwable = null;
                Object var4_7 = null;
                InputStream is = UtilsDecryption.getFileInputStream((File)source);
                try {
                    Profiler profiler = Profiler.getInstance((Object)"Peripherals");
                    BigInteger index = profiler.start(ConfigurationComponent.class, (Object)(profiler.isEnabled() ? MessageFormat.format("Load component from file \"{0}\"", source.getName()) : ""));
                    ConfigurationComponent result = (ConfigurationComponent)((Object)PERSISTER.read(ConfigurationComponent.class, is));
                    profiler.stop(index, ConfigurationComponent.class, null);
                    if (SWToolsProperties.isVerificationOn()) {
                        try {
                            URL schema;
                            try {
                                schema = new URL(result.getSchemaLocation());
                                XSDUtils.verifySchemaVersion((URL)schema, (File)source);
                            }
                            catch (MalformedURLException e) {
                                LOGGER.log(Level.SEVERE, String.format("[DATA] Invalid schema URL in component file %1s", source.getAbsolutePath()), e);
                                schema = null;
                            }
                            Object object = null;
                            Object var11_19 = null;
                            try (InputStream streamForValidation = UtilsDecryption.getFileInputStream((File)source);){
                                UtilsXML.validXml((InputStream)streamForValidation, (URL)schema, (Path)ConfigurationComponent.getFallbackSchemaLocation());
                            }
                            catch (Throwable throwable2) {
                                if (object == null) {
                                    object = throwable2;
                                } else if (object != throwable2) {
                                    ((Throwable)object).addSuppressed(throwable2);
                                }
                                throw object;
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, String.format("[DATA] Missing schema \"%1s\" for component file %2s", result.getSchemaLocation(), source.getAbsolutePath()), e);
                        }
                        catch (SAXException e) {
                            LOGGER.log(Level.SEVERE, String.format("[DATA] Invalid component file %1s", source.getAbsolutePath()), e);
                        }
                        if (result.isGlobalOnly() && !result.getScenarios().isEmpty()) {
                            LOGGER.log(Level.WARNING, String.format("[DATA] Found '%1s' element(s) in a global component file %2s", "mode", source.getAbsolutePath()));
                        }
                    }
                    switch (mode) {
                        case DATA_UPDATE: {
                            if (configSetIds != null) {
                                for (IConfigSet set : result.getConfigSets()) {
                                    if (!configSetIds.contains(set.getId())) continue;
                                    set.removeGenTypes();
                                }
                                break;
                            }
                            result.getConfigSets().forEach(IConfigSet::removeGenTypes);
                            break;
                        }
                        case STANDARD: {
                            break;
                        }
                    }
                    configurationComponent = result;
                    if (is == null) break block42;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause != null) {
                            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Error loading component file \"{0}\" caused by exception: {1}", source.getAbsolutePath(), cause.getLocalizedMessage()));
                        } else {
                            LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Error loading component file \"{0}\"", source.getAbsolutePath()), e);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Error loading component file \"{0}\"", source.getAbsolutePath()), e);
                        return null;
                    }
                }
                is.close();
            }
            return configurationComponent;
        }
        finally {
            ComponentLoadingStatus.getInstanceForCurrentThread().clearCurrentlyLoadingComponent();
        }
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "resources", "schemas", LOCAL_SCHEMA);
    }

    public @Nullable String getResolvedDescription(IContext context) {
        if (this.description != null) {
            return this.description.getDescription(context);
        }
        return null;
    }

    public int getComponentMaxInstancesNumber(IContext context) {
        if (this.maxInstancesExpression != null) {
            IValue val = this.maxInstancesExpression.resolve((IValue)Value.of((long)-1L), context);
            return val.getBigInteger().intValue();
        }
        return -1;
    }

    public int getComponentMaxFunctionalGroupsNumber(IContext context) {
        if (this.maxFunctionalGroupsExpression != null) {
            IValue val = this.maxFunctionalGroupsExpression.resolve((IValue)Value.of((long)-1L), context);
            return val.getBigInteger().intValue();
        }
        return -1;
    }

    public boolean schemaVersionOlderThan(String textVersion) {
        if (!UtilsText.isEmpty((String)this.schemaLocation)) {
            Matcher pattern;
            block4: {
                URL schema = new URL(this.schemaLocation);
                pattern = Pattern.compile(".*-(.*).xsd").matcher(schema.getFile());
                if (pattern.matches()) break block4;
                return true;
            }
            try {
                Version currentVersion = Version.valueOf((String)UtilsText.safeString((String)pattern.group(1)));
                Version comparedVersion = Version.valueOf((String)textVersion);
                return currentVersion.compareTo(comparedVersion) < 0;
            }
            catch (MalformedURLException e) {
                LOGGER.severe(MessageFormat.format("[DATA] No schema was found at the provided URL \"{0}\": {1}", this.schemaLocation, e.getMessage()));
            }
        }
        return true;
    }

    public void addConfigSet(IConfigSet configSet) {
        this.configSets.add(configSet);
    }

    public void addConfigSetReference(IConfigSetReference reference) {
        this.configSetReferences.add(reference);
    }

    public void clearConfigSetReferences() {
        this.configSetReferences = new ArrayList<IConfigSetReference>(0);
    }

    public static enum LoadMode {
        DATA_UPDATE,
        STANDARD,
        RAW;

    }
}

