/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import java.util.Objects;

public class ComponentKey {
    private String identification;
    private KeyType type;

    private ComponentKey(String identification, KeyType type) {
        this.identification = identification;
        this.type = type;
    }

    public String getIdentification() {
        return this.identification;
    }

    public KeyType getType() {
        return this.type;
    }

    public static ComponentKey type(String identification) {
        return new ComponentKey(identification, KeyType.TYPE);
    }

    public static ComponentKey folder(String identification) {
        return new ComponentKey(identification, KeyType.FOLDER);
    }

    public static ComponentKey category(String categoryId) {
        return new ComponentKey(categoryId, KeyType.CATEGORY);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.type});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentKey)) {
            return false;
        }
        ComponentKey other = (ComponentKey)obj;
        if (!Objects.equals(this.identification, other.identification)) {
            return false;
        }
        return Objects.equals((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return String.valueOf(ComponentKey.class.getSimpleName()) + "[" + "identification: " + this.identification + ", type: " + (Object)((Object)this.type) + "]";
    }

    public static enum KeyType {
        TYPE,
        FOLDER,
        CATEGORY;

    }
}

