/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.PeriphsSettingConfigFactory;
import com.nxp.swtools.periphs.model.data.ActiveComponents;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsIgnoredComponentMigrationOffer;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.SettingConfigFactory;
import com.nxp.swtools.resourcetables.model.data.ComponentOperationTypeEnum;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

public class PeriphsProfile
implements IRoot {
    public static final String TEMPORARY_COMPONENT_KEY = "&&temp&&";
    private static final Logger LOGGER = LogManager.getLogger(PeriphsProfile.class);
    private final IMcu mcu;
    private final List<IFunctionalGroup> functionalGroups = new ArrayList<IFunctionalGroup>();
    private final StoragePeriphsTool storageProfile;
    private Map<String, IComponentConfig> configuredComponents = new LinkedHashMap<String, IComponentConfig>();
    private ChildContext childContext;
    private final ExpressionContext expressionContext;
    private boolean yamlEnabled;
    private ActiveComponents activeComponents;
    private String activeCoreId = "";
    private PeriphsSettingConfigFactory configFactoryInstance = new PeriphsSettingConfigFactory();
    private HashSet<String> otherRequiredTools = new HashSet();

    public PeriphsProfile(IMcu mcu, ISharedConfiguration sharedConfig) {
        this.storageProfile = new StoragePeriphsTool();
        this.yamlEnabled = sharedConfig.getPreferences().isYamlOutputEnabled();
        this.activeComponents = new ActiveComponents();
        this.mcu = mcu;
        this.childContext = new ChildContext((IRoot)this);
        this.expressionContext = new ExpressionContext(this.childContext, (ICommonMcu)this.mcu);
        this.storageProfile.getPeriphsProfile().setProcessorVersion(mcu.getDataVersion());
        ProcessorCore selectedCore = sharedConfig.getCommonConfig().getSelectedCore();
        if (selectedCore != null) {
            this.setActiveCoreId(selectedCore.getID());
        }
        this.addAutoAddingComponents();
    }

    public PeriphsProfile(PeriphsProfile original, boolean duplicateGroups) {
        this.storageProfile = new StoragePeriphsTool(original.storageProfile);
        this.yamlEnabled = original.yamlEnabled;
        this.activeComponents = new ActiveComponents(original.activeComponents);
        this.mcu = original.mcu;
        this.childContext = new ChildContext((IRoot)this);
        this.expressionContext = new ExpressionContext(this.childContext, (ICommonMcu)this.mcu);
        this.storageProfile.getPeriphsProfile().setProcessorVersion(this.mcu.getDataVersion());
        this.activeCoreId = original.activeCoreId;
        this.configuredComponents = new LinkedHashMap<String, IComponentConfig>(original.configuredComponents);
        if (duplicateGroups) {
            for (IFunctionalGroup group : original.functionalGroups) {
                this.functionalGroups.add(new FunctionalGroup(group, this));
            }
        } else {
            this.functionalGroups.addAll(original.functionalGroups);
        }
    }

    public PeriphsProfile(IMcu mcu, StoragePeriphsTool storagePeriphsTool, ISharedConfiguration sharedConfig) {
        this.yamlEnabled = sharedConfig.getPreferences().isYamlOutputEnabled();
        this.storageProfile = storagePeriphsTool;
        this.activeComponents = new ActiveComponents();
        this.mcu = mcu;
        this.childContext = new ChildContext((IRoot)this);
        this.expressionContext = new ExpressionContext(this.childContext, (ICommonMcu)this.mcu);
        ProcessorCore selectedCore = sharedConfig.getCommonConfig().getSelectedCore();
        if (selectedCore != null) {
            this.setActiveCoreId(selectedCore.getID());
        }
        ArrayList funcGroupsCopy = new ArrayList(storagePeriphsTool.getFuncGroups());
        PeriphsProfile.addRequiredComponents(storagePeriphsTool.getComponents(), storagePeriphsTool.getFuncGroups());
        ArrayList storageComponentsCopy = new ArrayList(storagePeriphsTool.getComponents());
        storageComponentsCopy.forEach(x -> {
            ConfigurationComponentTypeId configCompTypeId;
            String configuredCompTypeId = this.getConfiguredComponentTypeId(x.getName());
            if (configuredCompTypeId != null && !configuredCompTypeId.equals(x.getTypeId())) {
                LOGGER.severe(MessageFormat.format("[TOOL] Component type ID mismatch. It is not possible to create component with type \"{0}\" and type ID \"{1}\" because component of given type is already configured to use type ID \"{2}\"", x.getName(), x.getTypeId(), configuredCompTypeId));
            }
            if ((configCompTypeId = this.activeComponents.getConfigCompTypeId((StoragePeriphsComponent)x)) == null) {
                configCompTypeId = mcu.getAvailableComponents().getBestMatchingConfigCompTypeId((StoragePeriphsComponent)x);
            }
            if (configCompTypeId != null) {
                ComponentConfig componentConfig = new ComponentConfig(configCompTypeId, (StoragePeriphsComponent)x, this.childContext, mcu);
                this.configuredComponents.put(configCompTypeId.getConfigurationComponent().getId(), componentConfig);
                this.activeComponents.addConfigurationComponent(componentConfig);
            } else {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Component \"{0}\" not found.", x.getName()));
            }
        });
        this.addAutoAddingComponents();
        funcGroupsCopy.forEach(x -> {
            boolean bl = this.functionalGroups.add(new FunctionalGroup(this.childContext, (StoragePeriphsFuncGroup)x, mcu));
        });
        this.configuredComponents.values().forEach(comp -> comp.initializeGlobalConfigSet());
        this.functionalGroups.forEach(g -> g.initializeAfterCreatedFromStorage());
        this.clearCache();
        this.storageProfile.getPeriphsProfile().setProcessorVersion(mcu.getDataVersion());
        this.updateStorage();
    }

    public boolean addAutoAddingComponents() {
        ConfigurationComponentTypeId systemComp;
        boolean somethingWasAdded = false;
        if (!(this.getMcu() instanceof EmptyMcu) && this.getComponent("system") == null && (systemComp = this.getMcu().getSystemComponent()) != null) {
            this.addComponent(new ComponentConfig(systemComp, this.getChildContext(), this.mcu));
            somethingWasAdded = true;
        }
        List componentsToAdd = (List)this.getMcu().getAvailableComponents().getConfigCompTypeIds().stream().filter(x -> x.getConfigurationComponent().isAutoAdding()).filter(x -> this.getConfiguredComponentTypeId(x.getType()) == null).collect(CollectorsUtils.toList());
        componentsToAdd.forEach(x -> this.addComponent(new ComponentConfig((ConfigurationComponentTypeId)x, this.getChildContext(), this.getMcu())));
        if (!componentsToAdd.isEmpty()) {
            somethingWasAdded = true;
        }
        return somethingWasAdded;
    }

    private static void addRequiredComponents(List<StoragePeriphsComponent> availableComponents, List<StoragePeriphsFuncGroup> functionalGroups) {
        functionalGroups.stream().flatMap(fg -> fg.getInstances().stream()).forEach(i -> {
            if (availableComponents.stream().noneMatch(c -> c.getName().equals(i.getType()))) {
                StoragePeriphsComponent comp = new StoragePeriphsComponent();
                comp.setName(i.getType());
                comp.setTypeId(i.getType_id());
                availableComponents.add(comp);
            }
        });
    }

    public ActiveComponents getActiveComponents() {
        return this.activeComponents;
    }

    public StoragePeriphsTool getStoragePeripheralsTool() {
        return this.storageProfile;
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public List<IFunctionalGroup> getFunctionalGroups() {
        return this.functionalGroups;
    }

    public void addFunctionalGroup(IFunctionalGroup functionalGroup) {
        if (!this.functionalGroups.contains(functionalGroup)) {
            this.functionalGroups.add(functionalGroup);
            this.storageProfile.getFuncGroups().add(functionalGroup.getStorageFuncGroup());
        }
    }

    public @Nullable IComponentConfig getComponent(String type) {
        return this.configuredComponents.get(type);
    }

    public boolean makeComponentTemporary(String type) {
        IComponentConfig temp = this.configuredComponents.get(type);
        if (temp != null) {
            this.configuredComponents.put(TEMPORARY_COMPONENT_KEY, temp);
            this.configuredComponents.remove(type);
            return true;
        }
        return false;
    }

    public Map<String, IComponentConfig> getConfiguredComponents() {
        return CollectionsUtils.unmodifiableMap(this.configuredComponents);
    }

    public Map<String, IConfigSetConfig> getGlobalConfigSets() {
        HashMap<String, IConfigSetConfig> result = new HashMap<String, IConfigSetConfig>();
        this.getConfiguredComponents().values().stream().filter(component -> component.getGlobalConfigSet() != null).forEach(x -> {
            IConfigSetConfig iConfigSetConfig = result.put(x.getName(), Objects.requireNonNull(x.getGlobalConfigSet()));
        });
        return result;
    }

    public void addComponent(IComponentConfig componentConfig) {
        this.configuredComponents.put(componentConfig.getId(), componentConfig);
        this.activeComponents.addConfigurationComponent(componentConfig);
        this.updateStorage();
    }

    public boolean removeComponent(String component) {
        @Nullable IComponentConfig componentConfig = this.configuredComponents.remove(component);
        if (componentConfig != null) {
            this.activeComponents.removeConfigurationComponent(componentConfig.getComponent());
            StoragePeriphsIgnoredComponentMigrationOffer ignoredMigrationComponents = this.storageProfile.getPeriphsProfile().getIgnoredMigrationComponents();
            if (ignoredMigrationComponents != null) {
                Set ignoredMigrationComponentsSet = ignoredMigrationComponents.getIgnoredMigrationComponents();
                ignoredMigrationComponentsSet.remove(component);
                ignoredMigrationComponents.setIgnoredMigrationComponents(ignoredMigrationComponentsSet);
            }
            this.updateStorage();
            return true;
        }
        return false;
    }

    private void updateStorage() {
        this.storageProfile.setVersion(StoragePeriphsTool.VERSION);
        ArrayList newGroups = new ArrayList();
        ArrayList newComponents = new ArrayList();
        this.functionalGroups.forEach(x -> {
            boolean bl = newGroups.add(x.getStorageFuncGroup());
        });
        this.configuredComponents.values().forEach(x -> {
            boolean bl = newComponents.add(x.getStorageComponent());
        });
        this.storageProfile.setFuncGroups(newGroups);
        this.storageProfile.setComponents(newComponents);
    }

    public String getId() {
        return "$root";
    }

    public Object getValue() {
        return this;
    }

    public String getName() {
        return this.getId();
    }

    public String getUiName() {
        return this.getId();
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public ChildContext getChildContext() {
        return this.childContext;
    }

    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative((IChildProvidable)this, (String)id);
    }

    public @Nullable IChild getChild(String name) {
        return (IChild)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getName().equals(name)).findFirst());
    }

    public List<? extends IChild> getChildren() {
        return CollectionsUtils.unmodifiableList(this.functionalGroups);
    }

    public boolean removeFunctionalGroup(IFunctionalGroup group) {
        boolean result = this.functionalGroups.remove(group);
        this.getStoragePeripheralsTool().getFuncGroups().remove(group.getStorageFuncGroup());
        return result;
    }

    public boolean isComponentConfigured(String componentType) {
        return this.configuredComponents.containsKey(componentType);
    }

    public @Nullable String getConfiguredComponentTypeId(String componentType) {
        @Nullable IComponentConfig componentConfig = this.configuredComponents.get(componentType);
        return componentConfig == null ? null : componentConfig.getComponentTypeId();
    }

    public List<IFunctionalGroup> getFunctionalGroupsWithPrefix(String prefix) {
        ArrayList<IFunctionalGroup> groups = new ArrayList<IFunctionalGroup>();
        for (IFunctionalGroup group : this.functionalGroups) {
            if (!group.getIdPrefix().equals(prefix)) continue;
            groups.add(group);
        }
        return groups;
    }

    public int countSameIdentifierOccurences(String prefix, String identifier) {
        List<IFunctionalGroup> functionalGroupsWithPrefix = this.getFunctionalGroupsWithPrefix(prefix);
        if (!functionalGroupsWithPrefix.isEmpty()) {
            ArrayList finalNames = new ArrayList();
            for (IFunctionalGroup group : functionalGroupsWithPrefix) {
                finalNames.addAll(group.getListOfFinalInstanceNames());
            }
            List sameFinalNames = (List)finalNames.stream().filter(x -> x.equals(identifier)).collect(CollectorsUtils.toList());
            return sameFinalNames.size();
        }
        return 0;
    }

    public List<IFunctionalGroup> getGroupsContainingIdentifier(String prefix, String identifier) {
        List<IFunctionalGroup> functionalGroupsWithPrefix = this.getFunctionalGroupsWithPrefix(prefix);
        HashMap<IFunctionalGroup, List> groupsFinalNames = new HashMap<IFunctionalGroup, List>();
        for (IFunctionalGroup group : functionalGroupsWithPrefix) {
            groupsFinalNames.put(group, group.getListOfFinalInstanceNames());
        }
        return (List)groupsFinalNames.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(identifier)).map(entry -> (IFunctionalGroup)entry.getKey()).collect(CollectorsUtils.toList());
    }

    public void clearFunctionalGroups() {
        this.functionalGroups.clear();
        this.getStoragePeripheralsTool().getFuncGroups().clear();
    }

    public void updateStorageAvailability() {
        this.functionalGroups.stream().forEach(fg -> fg.updateStorageAvailability());
        ArrayList componentStoragesWithConfigSet = (ArrayList)this.configuredComponents.values().stream().map(c -> c.getStorageComponent()).filter(storage -> storage.getConfig_set_global() != null).collect(CollectorsUtils.toList());
        this.configuredComponents.values().forEach(c -> c.updateStorageAvailability());
        this.storageProfile.setComponents(componentStoragesWithConfigSet);
    }

    public @Nullable IFunctionalGroup getFunctionalGroup(String name) {
        return (IFunctionalGroup)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getName().equals(name)).findAny());
    }

    public @Nullable IFunctionalGroup getFunctionalGroupWithUUID(String uuid) {
        return (IFunctionalGroup)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getStorageFuncGroup().getUUID().equals(uuid)).findAny());
    }

    public boolean isYamlEnabled() {
        return this.yamlEnabled;
    }

    public void setYamlEnabled(boolean generateYaml) {
        this.yamlEnabled = generateYaml;
    }

    public List<IComponentInstanceConfig> getAllInstances() {
        ArrayList<IComponentInstanceConfig> result = new ArrayList<IComponentInstanceConfig>();
        this.functionalGroups.stream().forEach(group -> {
            Map instances = group.getInstances();
            instances.values().stream().forEach(value -> {
                boolean bl = result.add((IComponentInstanceConfig)value);
            });
        });
        return result;
    }

    public List<IComponentInstanceConfig> getAllInstances(String type) {
        ArrayList<IComponentInstanceConfig> result = new ArrayList<IComponentInstanceConfig>();
        this.functionalGroups.stream().forEach(group -> {
            Map instances = group.getInstances();
            instances.values().stream().filter(i -> i.getComponent().getId().equals(type)).forEach(value -> {
                boolean bl = result.add((IComponentInstanceConfig)value);
            });
        });
        return result;
    }

    public void clearCache() {
        this.configuredComponents.values().forEach(x -> x.clearCache());
        this.getAllInstances().forEach(c -> c.clearCache());
        this.otherRequiredTools.clear();
    }

    public void clearCacheForValueChange(IChild config) {
        List<String> idsToRemove = Arrays.asList(String.valueOf(config.getId()) + "*value", String.valueOf(config.getId()) + "*value*error");
        this.clearCacheInternal(config, idsToRemove);
    }

    private void clearCacheInternal(IChild config, List<String> idsToRemove) {
        if (config instanceof ICacheable) {
            ICacheable configCacheable = (ICacheable)config;
            Stack<CollectionsUtils.Pair> toClear = new Stack<CollectionsUtils.Pair>();
            for (String id : idsToRemove) {
                toClear.add(new CollectionsUtils.Pair((Object)id, (Object)configCacheable));
            }
            while (!toClear.isEmpty()) {
                CollectionsUtils.Pair element = (CollectionsUtils.Pair)toClear.pop();
                String idToClear = (String)element.getFirst();
                ICacheable cacheable = (ICacheable)element.getSecond();
                cacheable.getCache().remove(idToClear);
                Collection dependants = cacheable.getDependencyMap().get((Object)idToClear);
                cacheable.getDependencyMap().remove((Object)idToClear);
                if (dependants == null) continue;
                toClear.addAll(dependants);
            }
        } else {
            this.clearCache();
        }
    }

    public void clearCacheForChildrenChange(IChild config) {
        List<String> idsToRemove = Arrays.asList(String.valueOf(config.getId()) + "*children", String.valueOf(config.getId()) + "*all_children");
        this.clearCacheInternal(config, idsToRemove);
    }

    public String getActiveCoreId() {
        return this.activeCoreId;
    }

    public void setActiveCoreId(String activeCoreId) {
        this.activeCoreId = activeCoreId;
    }

    public @Nullable ConfigurationComponentTypeId getComponentTypeIdByType(String type) {
        return this.getActiveComponents().getComponentTypeIdByType(type);
    }

    public @Nullable List<ConfigurationComponentTypeId> getAvailableComponentTypeIdsByType(String type) {
        return this.mcu.getAvailableComponents().getComponentTypeIdsByType(type);
    }

    public List<ConfigurationComponentTypeId> getAvailableComponentsTypeIds(String type, String version, @Nullable String matchType, @Nullable String untilVersion) {
        List<ConfigurationComponentTypeId> components = this.getAvailableComponentTypeIdsByType(type);
        if (components == null) {
            return Collections.emptyList();
        }
        Version upperLimitVersion = untilVersion == null ? null : new Version(untilVersion);
        matchType = matchType == null ? SWComponent.Match.EQUIVALENT.getName() : matchType;
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        for (ConfigurationComponentTypeId component : components) {
            List swComps = component.getConfigurationComponent().getComponents();
            ComputeScoreWrapper componentWrapper = ComputeScoreWrapper.from(((SWComponent)swComps.get(0)).getVersion());
            ComputeScoreWrapper requiredWrapper = ComputeScoreWrapper.from(new Version(version));
            BigInteger matchScore = Components.computeMatchScore(requiredWrapper, componentWrapper, matchType, upperLimitVersion);
            if (matchScore == null) continue;
            result.add(component);
        }
        return result;
    }

    public @Nullable ConfigurationComponentTypeId getActiveComponentTypeIdByType(String type) {
        return this.getActiveComponents().getComponentTypeIdByType(type);
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId, String component) {
        return this.getMcu().getAvailableResourceTables().getResource(tableId, definitionId, component);
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId) {
        return this.getMcu().getAvailableResourceTables().getResource(tableId, definitionId);
    }

    public @NonNull SettingConfigFactory getConfigFactory() {
        return this.configFactoryInstance;
    }

    public boolean isDriverDefined(String driverName) {
        SdkComponentsTable sdkComponentsTable = this.getSdkComponentsTable();
        if (sdkComponentsTable == null) {
            return false;
        }
        return sdkComponentsTable.findById(driverName).findAny().isPresent();
    }

    public List<ConfigurationComponentTypeId> getAvailableComponentForSdkComponent(String sdkComponentId) {
        return (List)this.getMcu().getAvailableComponents().getConfigCompTypeIds().stream().filter(c -> c.getComponentReferences().stream().anyMatch(r -> r.getName().equals(sdkComponentId))).collect(CollectorsUtils.toList());
    }

    public List<ConfigurationComponentTypeId> getConfiguredComponentForSdkComponent(String sdkComponentId, String functionalGroupName) {
        IFunctionalGroup functionalGroup = this.getFunctionalGroup(functionalGroupName);
        if (functionalGroup == null) {
            return Collections.emptyList();
        }
        return (List)functionalGroup.getInstances().values().stream().map(i -> i.getConfigCompTypeId()).filter(c -> c.getComponentReferences().stream().anyMatch(r -> r.getName().equals(sdkComponentId))).collect(CollectorsUtils.toList());
    }

    public List<SupportedSdkComponent> getDefinedDrivers(String driverName) {
        SdkComponentsTable sdkComponentsTable = this.getSdkComponentsTable();
        if (sdkComponentsTable == null) {
            return Collections.emptyList();
        }
        return (List)sdkComponentsTable.findById(driverName).collect(CollectorsUtils.toList());
    }

    private @Nullable SdkComponentsTable getSdkComponentsTable() {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(this.mcu.getMcu(), this.mcu.getSdkVersion());
        if (info == null) {
            return null;
        }
        SdkComponentsTable sdkComponentsTable = derivatives.getSdkComponentsTable(info);
        return sdkComponentsTable;
    }

    public @Nullable IChild getSynchronizedSettingByChild(IChild child) {
        List instances;
        IComponentInstanceConfig childComponent = child.getChildContext().getComponentInstanceConfig();
        if (childComponent != null && !(instances = this.getAllInstances().stream().filter(component -> {
            IChild setting;
            return childComponent.getType().equals(component.getType()) && !childComponent.getId().equals(component.getId()) && (setting = component.getChildById(child.getId())) != null && setting.isSynchronizationEnabled();
        }).collect(Collectors.toList())).isEmpty()) {
            IComponentInstanceConfig instance = (IComponentInstanceConfig)instances.get(0);
            return instance.getChildById(child.getId());
        }
        return null;
    }

    public List<IChild> getSettingsToSyncByChild(IChild setting) {
        List<IComponentInstanceConfig> instances;
        ArrayList<IChild> settings = new ArrayList<IChild>();
        IComponentInstanceConfig childComponent = setting.getChildContext().getComponentInstanceConfig();
        if (childComponent != null && !(instances = this.getAllInstances().stream().filter(x -> childComponent.getType().equals(x.getType()) && (!childComponent.getId().equals(x.getId()) || this.isFunctionalGroupSynchronizationEnabled())).collect(Collectors.toList())).isEmpty()) {
            String settingId = setting.getId();
            instances.forEach(child -> {
                IChild config = child.getChildById(settingId);
                if (config != null && config.isSynchronizationEnabled()) {
                    settings.add(config);
                }
            });
        }
        return settings;
    }

    public boolean isFunctionalGroupSynchronizationEnabled() {
        IComponentConfig systemComponentConfig = this.getSystemComponentConfig();
        if (systemComponentConfig != null) {
            return systemComponentConfig.getComponent().isOptionAvailable("SYNC_FUNCTIONAL_GROUPS", systemComponentConfig.getExpressionContext());
        }
        return false;
    }

    public IComponentInstanceConfig createComponentInstanceCopy(IComponentInstanceConfig baseComponent, IFunctionalGroup group) {
        StoragePeriphsComponentInstance baseComponentStorage = baseComponent.getStorageComponent();
        StoragePeriphsComponentInstance componentStorage = new StoragePeriphsComponentInstance(baseComponentStorage);
        componentStorage.setComment(baseComponentStorage.getComment());
        componentStorage.setEditingLockState(baseComponentStorage.isEditingLocked());
        componentStorage.setUUID(UUID.randomUUID().toString());
        ComponentInstanceConfig copyInstance = new ComponentInstanceConfig(baseComponent.getComponent(), group, componentStorage, group.getChildContext(), this.mcu);
        return copyInstance;
    }

    public void synchronizeFunctionalGroups(IFunctionalGroup functionalGroup, @Nullable String instanceName, @Nullable String newName, ComponentOperationTypeEnum operationType) {
        if (this.isFunctionalGroupSynchronizationEnabled()) {
            Collection instances = functionalGroup.getInstances().values();
            switch (operationType) {
                case ADD: {
                    this.functionalGroups.forEach(group -> {
                        for (IComponentInstanceConfig instance : instances) {
                            if (group.getInstance(instance.getName()) != null) continue;
                            this.createComponentInstanceCopy(instance, (IFunctionalGroup)group);
                        }
                    });
                    break;
                }
                case REMOVE: {
                    this.functionalGroups.forEach(group -> {
                        if (instanceName != null && group.getInstance(instanceName) != null) {
                            group.removeInstance(instanceName);
                        }
                    });
                    break;
                }
                case RENAME: {
                    this.functionalGroups.forEach(group -> {
                        if (instanceName != null && newName != null && !group.getName().equals(functionalGroup.getName())) {
                            group.renameInstance(instanceName, newName);
                        }
                    });
                    break;
                }
                case ENABLE_DISABLE: {
                    this.functionalGroups.forEach(group -> {
                        if (!group.getName().equals(functionalGroup.getName())) {
                            for (IComponentInstanceConfig instance : instances) {
                                IComponentInstanceConfig componentInstance = group.getInstance(instance.getName());
                                if (componentInstance == null) continue;
                                componentInstance.setEnabled(instance.isEnabled());
                            }
                        }
                    });
                }
            }
        }
    }

    public void dispose() {
    }

    public @Nullable IComponentConfig getSystemComponentConfig() {
        return this.getComponent("system");
    }

    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump((StringBuilder)builder, (DumpFormatOptions)options, (IChildProvidable)this);
    }

    public Set<String> getOtherRequiredTools() {
        return CollectionsUtils.unmodifiableSet(this.otherRequiredTools);
    }

    public void addRequiredTool(String tool) {
        this.otherRequiredTools.add(tool);
    }

    public String toString() {
        return MessageFormat.format("{0}[mcu={1}, functionalGroups={2}]", this.getClass().getSimpleName(), this.mcu, this.functionalGroups);
    }

    public void clearAllCacheEntriesFor(IChild child) {
        if (child instanceof ICacheable) {
            Map cache = ((ICacheable)child).getCache();
            List<String> idToRem = cache.keySet().stream().filter(key -> key.startsWith(child.getId()) || key.startsWith("pinSignalProvider")).collect(Collectors.toList());
            this.clearCacheInternal(child, idToRem);
            this.otherRequiredTools.clear();
        }
    }
}

