/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.orbit.strings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SeparatedStrings {
    public static final SeparatedStrings COMMA_SEPARATED = new SeparatedStrings(",");
    private final CharSequence delimiter;

    public SeparatedStrings(CharSequence delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Parameter delimiter is null!");
        }
        this.delimiter = delimiter;
    }

    public String toString(List<String> strings) {
        return String.join(this.delimiter, strings);
    }

    public String toString(String[] strings) {
        return this.toString(Arrays.asList(strings));
    }

    public String[] asArray(String value) {
        List<String> asList = this.asList(value);
        return asList.toArray(new String[asList.size()]);
    }

    public List<String> asList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] split = value.split(this.delimiter.toString());
        return Arrays.asList(split).stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.toList());
    }
}

