/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="option", strict=false)
public class Option
implements IID {
    private static final Logger LOGGER = LogManager.getLogger(Option.class);
    @Attribute(name="id", required=true)
    private String id;
    @Nullable
    private Expression expr;
    @Nullable
    private Expression availableExpr;

    public Option(String id, @Nullable String expr) {
        this.id = id;
        this.setExprString(expr);
    }

    public Option(String id, @Nullable Expression expr) {
        this.id = id;
        this.setExpr(expr);
    }

    @Deprecated
    public Option() {
        this.id = "";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Attribute(name="expr", required=false)
    public @Attribute(name="expr", required=false) @Nullable String getExprString() {
        return this.expr != null ? this.expr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="expr", required=false)
    public void setExprString(@Nullable String expressionString) {
        if (expressionString != null) {
            if (!expressionString.isEmpty()) {
                try {
                    this.expr = Expression.create((String)expressionString);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Expression of option \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
                }
            } else {
                LOGGER.log(Level.WARNING, MessageFormat.format("[DATA] [OPTION] [{0}] Expression for option is empty!", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
            }
        }
    }

    @Attribute(name="available", required=false)
    public @Attribute(name="available", required=false) @Nullable String getAvailableExprString() {
        return this.availableExpr != null ? this.availableExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="available", required=false)
    public void setAvailableExprString(@Nullable String expressionString) {
        if (expressionString != null) {
            if (!expressionString.isEmpty()) {
                try {
                    this.availableExpr = Expression.create((String)expressionString);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Available condition of option \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
                }
            } else {
                LOGGER.log(Level.WARNING, MessageFormat.format("[DATA] [OPTION] [{0}] Available expression for option is empty!", ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent()));
            }
        }
    }

    public @Nullable Expression getExpr() {
        return this.expr;
    }

    public final void setExpr(@Nullable Expression expression) {
        this.expr = expression;
    }

    public @Nullable Expression getAvailableExpr() {
        return this.availableExpr;
    }

    public boolean isAvailable(IContext context) {
        return this.availableExpr != null ? this.availableExpr.resolve(context).getBoolean() : true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.expr);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (!other.id.equals(this.id)) {
            return false;
        }
        return Objects.equals(other.expr, this.expr);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.id);
        result.append("=");
        result.append(this.expr);
        result.append("]");
        return result.toString();
    }
}

