/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.data.documentation.Contents;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class ConfigurationComponentTypeId {
    private static final String DOCUMENTATION_MENU_GENERATOR = "menuGenerator.js";
    private static final String DOCUMENTATION_CONTENTS_XML = "contents.xml";
    public static final String DOCUMENTATION_SUBFOLDER_NAME = "doc";
    private static final String DOCUMENTATION_INDEX_FILE_NAME = "index.md";
    private IConfigurationComponent configurationComponent;
    private String typeId;
    private String sdkVersion;
    private File locationOnDisk;
    private boolean containsDocumentation;
    private boolean isHidden;

    public static ConfigurationComponentTypeId create(IConfigComponentInfo componentInfo, IConfigurationComponent component) {
        return ConfigurationComponentTypeId.create(componentInfo.getName(), componentInfo.getSdkVersion(), componentInfo.getComponentDir(), component);
    }

    private ConfigurationComponentTypeId(String typeId, String sdkVersion, File locationOnDisk, IConfigurationComponent component) {
        this.typeId = typeId;
        this.sdkVersion = sdkVersion;
        this.locationOnDisk = locationOnDisk;
        this.configurationComponent = component;
        this.containsDocumentation = ConfigurationComponentTypeId.getDocIndexFile(locationOnDisk).exists();
    }

    public IConfigurationComponent getConfigurationComponent() {
        return this.configurationComponent;
    }

    public List<SWComponent> getComponentReferences() {
        return this.getConfigurationComponent().getComponents();
    }

    public String getType() {
        return this.getConfigurationComponent().getId();
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public boolean isDocumentationPresent() {
        return this.containsDocumentation;
    }

    public boolean isHidden() {
        return this.isHidden || this.configurationComponent.isHidden();
    }

    public @Nullable String getDocumentationLocation() {
        if (!this.isDocumentationPresent()) {
            return null;
        }
        return ConfigurationComponentTypeId.getDocIndexFile(this.locationOnDisk).getAbsolutePath();
    }

    public @Nullable Contents getDocumentationMenuContent() {
        if (!this.isDocumentationPresent()) {
            return null;
        }
        File menuContentFile = ConfigurationComponentTypeId.getDocumentationMenuContentFile(this.locationOnDisk);
        if (!menuContentFile.exists()) {
            return null;
        }
        return Contents.loadContent(menuContentFile);
    }

    public @Nullable File getDocumentationMenuGeneratorScript() {
        File generatorFile = ConfigurationComponentTypeId.getDocumentationMenuGeneratorScript(this.locationOnDisk);
        if (!generatorFile.exists()) {
            return null;
        }
        return generatorFile;
    }

    public Path getFileLocation() {
        return this.locationOnDisk.toPath();
    }

    public Path resolveDocumentationPath(Path other) {
        return Paths.get(this.getFileLocation().toString(), DOCUMENTATION_SUBFOLDER_NAME).resolve(other);
    }

    private static File getDocIndexFile(File componentFolder) {
        return new File(new File(componentFolder, DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_INDEX_FILE_NAME);
    }

    private static File getDocumentationMenuContentFile(File componentFolder) {
        return new File(new File(componentFolder, DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_CONTENTS_XML);
    }

    private static File getDocumentationMenuGeneratorScript(File componentFolder) {
        return new File(new File(componentFolder, DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_MENU_GENERATOR);
    }

    public static ConfigurationComponentTypeId create(String typeId, String sdkVersion, File locationOnDisk, IConfigurationComponent component) {
        return new ConfigurationComponentTypeId(typeId, sdkVersion, locationOnDisk, component);
    }

    public static ConfigurationComponentTypeId createFromComponentInfo(IConfigComponentInfo componentInfo, IConfigurationComponent component) {
        return ConfigurationComponentTypeId.create(componentInfo, component);
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getTypeId().hashCode();
        result = 31 * result + this.getSdkVersion().hashCode();
        result = 31 * result + this.getFileLocation().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationComponentTypeId other = (ConfigurationComponentTypeId)obj;
        if (!this.getTypeId().equals(other.getTypeId())) {
            return false;
        }
        if (!this.getSdkVersion().equals(other.getSdkVersion())) {
            return false;
        }
        return this.getFileLocation().equals(other.getFileLocation());
    }

    public String toString() {
        return "ConfigurationComponentTypeId [Type='" + this.getType() + "' TypeId='" + this.getTypeId() + "']";
    }
}

