/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.config.IChild;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.core.Commit;

public class AMigrationDescriptionBase {
    private static final Logger LOGGER = LogManager.getLogger(AMigrationDescriptionBase.class);
    @Attribute(name="description", required=false)
    @Nullable
    private @Attribute(name="description", required=false) @Nullable String description;
    @Attribute(name="description_expr", required=false)
    @Nullable
    private @Attribute(name="description_expr", required=false) @Nullable String descriptionExpressionString;
    @Attribute(name="description_when_expr", required=false)
    @Nullable
    private @Attribute(name="description_when_expr", required=false) @Nullable String descriptionWhenExpressionString;
    @Nullable
    private Expression descriptionExpression;
    @Nullable
    private Expression descriptionWhenExpression;
    @Attribute(name="description_severity", required=false)
    @Nullable
    private @Attribute(name="description_severity", required=false) @Nullable String descriptionSeverity;
    @Attribute(name="description_show_mode", required=false)
    @Nullable
    private @Attribute(name="description_show_mode", required=false) @Nullable String showDescriptionMode;

    public @Nullable String getDescriptionString() {
        return this.description;
    }

    public @Nullable String getDescriptionExpressionString() {
        return this.descriptionExpressionString;
    }

    public @Nullable Expression getDescriptionWhenExpression() {
        return this.descriptionWhenExpression;
    }

    public @Nullable String getDescriptionWhenExpressionString() {
        return this.descriptionWhenExpressionString;
    }

    public @Nullable String getDescription(IContext context, @Nullable IChild targetSetting, @Nullable IChild sourceSetting) {
        if (this.descriptionWhenExpression != null) {
            IValue resolvedDescriptionWhenExpressionValue = AMigrationDescriptionBase.getResolvedExpressionValue(this.descriptionWhenExpression, context, targetSetting, sourceSetting);
            if (resolvedDescriptionWhenExpressionValue == null) {
                return null;
            }
            boolean valueIsBoolean = resolvedDescriptionWhenExpressionValue.getType().equals((Object)IValue.Type.BOOLEAN);
            if (valueIsBoolean) {
                boolean shouldDisplayDescription = resolvedDescriptionWhenExpressionValue.getBoolean();
                if (!shouldDisplayDescription) {
                    return null;
                }
            } else {
                LOGGER.log(Level.SEVERE, "[DATA] Value of expression is not a boolean: {0}. The description message will be displayed", resolvedDescriptionWhenExpressionValue);
            }
        }
        if (this.descriptionExpression != null) {
            IValue resolvedDescriptionExpressionValue = AMigrationDescriptionBase.getResolvedExpressionValue(this.descriptionExpression, context, targetSetting, sourceSetting);
            if (resolvedDescriptionExpressionValue == null) {
                return null;
            }
            return resolvedDescriptionExpressionValue.getString();
        }
        return this.description;
    }

    private static @Nullable IValue getResolvedExpressionValue(Expression expression, IContext context, @Nullable IChild targetSetting, @Nullable IChild sourceSetting) {
        IValue value = expression.resolve(context);
        if (value.getType().equals((Object)IValue.Type.FUNCTION)) {
            if (targetSetting == null || sourceSetting == null) {
                LOGGER.log(Level.FINE, "Source setting or target setting is null. Returning null as description");
                return null;
            }
            IFunction lambdaFunction = value.getFunctionReference();
            IValue result = lambdaFunction.invokeOn(context, new Object[]{targetSetting, sourceSetting});
            return result;
        }
        return value;
    }

    public @Nullable String getDescriptionSeverity() {
        return this.descriptionSeverity;
    }

    public @Nullable String getShowDescriptionMode() {
        return this.showDescriptionMode;
    }

    @Commit
    public void commit() {
        String descriptionWhenExpressionStringLoc;
        String descriptionExpressionStringLoc = this.descriptionExpressionString;
        if (descriptionExpressionStringLoc != null && !descriptionExpressionStringLoc.isEmpty()) {
            this.setDescriptionExpression(descriptionExpressionStringLoc);
        }
        if ((descriptionWhenExpressionStringLoc = this.descriptionWhenExpressionString) != null && !descriptionWhenExpressionStringLoc.isEmpty()) {
            this.setDescriptionWhenExpression(descriptionWhenExpressionStringLoc);
        }
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setDescriptionExpressionString(@Nullable String descriptionExpressionString) {
        this.descriptionExpressionString = descriptionExpressionString;
        if (descriptionExpressionString != null) {
            this.setDescriptionExpression(descriptionExpressionString);
        }
    }

    private void setDescriptionExpression(String expressionString) {
        this.descriptionExpression = Expression.tryCreate((String)expressionString);
    }

    public void setDescriptionWhenExpressionString(@Nullable String descriptionWhenExpressionString) {
        this.descriptionWhenExpressionString = descriptionWhenExpressionString;
        if (descriptionWhenExpressionString != null) {
            this.setDescriptionWhenExpression(descriptionWhenExpressionString);
        }
    }

    private void setDescriptionWhenExpression(String expressionString) {
        this.descriptionWhenExpression = Expression.tryCreate((String)expressionString);
    }

    public void setDescriptionSeverity(@Nullable String severity) {
        this.descriptionSeverity = severity;
    }

    public void setShowDescriptionMode(@Nullable String mode) {
        this.showDescriptionMode = mode;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.descriptionExpressionString, this.descriptionWhenExpressionString, this.descriptionSeverity, this.showDescriptionMode);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMigrationDescriptionBase other = (AMigrationDescriptionBase)obj;
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.descriptionExpressionString, other.descriptionExpressionString)) {
            return false;
        }
        if (!Objects.equals(this.descriptionWhenExpressionString, other.descriptionWhenExpressionString)) {
            return false;
        }
        if (!Objects.equals(this.descriptionSeverity, other.descriptionSeverity)) {
            return false;
        }
        return Objects.equals(this.showDescriptionMode, other.showDescriptionMode);
    }
}

