/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IChildProvidable
extends IChild {
    public @Nullable IChild getChildById(String var1);

    public @Nullable IChild getChild(String var1);

    public List<? extends IChild> getChildren();

    default public @Nullable String getNestedProblems(Level level) {
        return this.isEnabled() ? ChildValidationHelper.getChildrenProblemsWithPrefix(this, level) : null;
    }

    default public List<IValidationProblem> getNestedValidationProblems(int level) {
        ArrayList<IValidationProblem> result = new ArrayList<IValidationProblem>();
        for (IChild iChild : this.getChildren()) {
            result.addAll(iChild.getOwnValidationProblems(level));
        }
        return result;
    }

    default public List<IValidationProblem> getValidationProblems(int level) {
        List<IValidationProblem> ownValidationProblems = this.getOwnValidationProblems(level);
        List<IValidationProblem> nestedValidationProblems = this.getNestedValidationProblems(level);
        ArrayList<IValidationProblem> result = new ArrayList<IValidationProblem>(ownValidationProblems.size() + nestedValidationProblems.size());
        result.addAll(ownValidationProblems);
        result.addAll(nestedValidationProblems);
        return result;
    }

    @Override
    default public @Nullable String getProblems(Level level) {
        return this.isEnabled() ? ChildValidationHelper.mergeProblems(ChildValidationHelper.mergeProblems((String[])CollectionsUtils.toNullableTypeArrayUnchecked((Object[])this.getOwnProblems(level))), this.getNestedProblems(level)) : null;
    }

    @Override
    default public boolean isOptionSet(String option) {
        return false;
    }

    @Override
    default public boolean isOptionAvailable(String option) {
        return false;
    }

    @Override
    default public @Nullable Object getOptionValue(String option) {
        return null;
    }

    @Override
    default public @Nullable IBaseModel getModelData() {
        return null;
    }

    @Override
    default public List<String> getProblemsPaths(Level level) {
        return ChildValidationHelper.getProblemsPaths(this, level);
    }

    default public Map<String, String> getAllValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        String prefix = String.valueOf(this.getId()) + ".";
        List<IChild> allChildren = ChildProviderHelper.getAllChildren(this);
        for (IChild child : allChildren) {
            if (child instanceof IChildProvidable) continue;
            result.put(String.valueOf(prefix) + child.getId(), String.valueOf(child.getValue()));
        }
        return result;
    }
}

