/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.data.Constraint;
import com.nxp.swtools.resourcetables.model.data.Dependency;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.properties.Properties;
import com.nxp.swtools.resourcetables.settings.checker.ISettingsChecker;
import com.nxp.swtools.resourcetables.settings.checker.SettingsCheckerSingleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ChildValidationHelper {
    private static final String CHILD_PROBLEM_DESCRIPTION_PREFIX = "\u2013 See setting: ";

    public static @Nullable String getChildrenProblemsWithPrefix(IChildProvidable childProvidable, Level level) {
        if (childProvidable.isSettingVisible()) {
            return ChildValidationHelper.getChildrenProblems(childProvidable, level);
        }
        return null;
    }

    public static @Nullable String getChildrenProblems(IChildProvidable childProvidable, Level level) {
        StringJoiner result = new StringJoiner("\n");
        List<String> childrenProblemsList = ChildValidationHelper.getChildrenProblemsList(childProvidable, level);
        if (childrenProblemsList != null) {
            for (String problem : childrenProblemsList) {
                result.add(ChildValidationHelper.createChildProblemPathString(problem));
            }
            return result.toString();
        }
        return null;
    }

    private static String createChildProblemPathString(String problemPath) {
        StringBuilder result = new StringBuilder();
        result.append(CHILD_PROBLEM_DESCRIPTION_PREFIX);
        result.append("(");
        result.append(problemPath);
        result.append(")");
        return UtilsText.safeToString((Object)result);
    }

    public static @Nullable List<String> getChildrenProblemsList(IChildProvidable childProvidable, Level level) {
        if (childProvidable.isSettingVisible()) {
            List result = (List)childProvidable.getChildren().stream().filter(x -> x.getProblems(level) != null).map(x -> x.getProblemsPaths(level)).flatMap(list -> list.stream()).collect(CollectorsUtils.toList());
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public static String @Nullable [] getSettingProblems(ISettingConfig child, Level level) {
        if (child.isSettingVisible()) {
            String invalidValueError;
            String[] validationProblems;
            Object[] result = new String[]{};
            ISetting modelData = child.getModelData();
            assert (modelData != null) : "Given model is null";
            Validation validation = modelData.getValidation();
            IContext exprContext = child.getExpressionContext();
            String[] stringArray = validationProblems = validation == null ? null : ChildValidationHelper.getValidationProblems(validation, exprContext, level);
            if (validationProblems != null) {
                result = validationProblems;
            }
            String string = invalidValueError = level == Level.ERROR ? child.getValueError() : null;
            if (invalidValueError != null) {
                result = (String[])ArraysUtils.append((Object[])result, (Object)invalidValueError);
            }
            if (child.isOptionSet("FEATURE_PERIPHERAL_SELECT") && level == Level.ERROR) {
                String peripheralError = null;
                IFunctionalGroup functionalGroup = ChildValidationHelper.getFunctionalGroup(child);
                if (functionalGroup != null) {
                    IFunctionalGroup nonNullFunctionalGroup = functionalGroup;
                    Map<String, IComponentInstanceConfig> instances = nonNullFunctionalGroup.getInstances();
                    HashSet<String> conflictPeripherals = new HashSet<String>();
                    HashSet<IComponentInstanceConfig> conflictInstances = new HashSet<IComponentInstanceConfig>();
                    String selectedPeripheral = UtilsText.safeString((String)child.getValueName());
                    for (IComponentInstanceConfig instance : instances.values()) {
                        if (child.getChildContext().getComponentInstanceConfig() == instance || !instance.isEnabled() || !instance.isPeripheralUsedExlusively(selectedPeripheral)) continue;
                        conflictPeripherals.add(selectedPeripheral);
                        conflictInstances.add(instance);
                    }
                    if (!conflictPeripherals.isEmpty()) {
                        String instancesString = CollectionsUtils.formatList(conflictInstances, (String)", ", c -> UtilsText.safeString((String)c.getName()));
                        String peripheralsString = CollectionsUtils.formatList(conflictPeripherals, (String)", ", null);
                        String unformatedMessage = Messages.get().ComponentInstanceConfig_MultipleInstancesOnPeripheral;
                        peripheralError = MessageFormat.format(UtilsText.safeString((String)unformatedMessage), peripheralsString, instancesString);
                    }
                }
                if (peripheralError != null) {
                    result = (String[])ArraysUtils.append((Object[])result, peripheralError);
                }
            }
            if (level == Level.ERROR) {
                SettingsCheckerSingleton settingsCheckerInstance = SettingsCheckerSingleton.getInstance();
                for (ISettingsChecker checker : settingsCheckerInstance.getCheckers()) {
                    List<String> violatedConfigClasses = checker.getAdditionalSettingProblems(child);
                    if (violatedConfigClasses == null) continue;
                    result = (String[])ArraysUtils.join((Object[])result, (Object[])CollectionsUtils.toStringArr(violatedConfigClasses));
                }
            }
            return ArraysUtils.isEmpty((Object[])result) ? null : result;
        }
        return null;
    }

    public static String @Nullable [] getValidationProblems(Validation validation, IContext exprContext, Level level) {
        List<Constraint> violated = validation.collectViolatedConstraints(exprContext, level.toString());
        String[] result = (String[])violated.stream().map(x -> x.getDescription(exprContext)).toArray(String[]::new);
        return result.length == 0 ? null : result;
    }

    public static @Nullable String mergeProblems(String ... problems) {
        StringBuilder resultBuilder = null;
        if (problems != null) {
            String[] stringArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                String problem = stringArray[n2];
                if (!UtilsText.isEmpty((String)problem)) {
                    if (resultBuilder == null) {
                        assert (problem != null);
                        resultBuilder = new StringBuilder(problem);
                    } else {
                        resultBuilder.append("\n").append(problem);
                    }
                }
                ++n2;
            }
        }
        return resultBuilder == null ? null : resultBuilder.toString();
    }

    public static IDependency @Nullable [] getDependencies(@Nullable Validation validation, IContext expressionContext, String source, String originatorId) {
        if (validation == null) {
            return null;
        }
        ArrayList<StorageDependency> result = new ArrayList<StorageDependency>();
        for (Dependency dep : validation.getDependencies()) {
            StorageDependency stg;
            if (!Properties.isVerificationOn() && dep.getLevel().equalsIgnoreCase("Verification") || (stg = dep.resolve(expressionContext, source, originatorId)) == null) continue;
            result.add(stg);
        }
        return result.toArray(new IDependency[0]);
    }

    public static List<String> getProblemsPaths(IChildProvidable childProvidable, Level level) {
        String prefix;
        String name;
        if (childProvidable.isOptionSet("UI_LABEL_HIDDEN") && !(childProvidable instanceof IConfigSetConfig)) {
            prefix = name = "";
        } else {
            name = UtilsText.safeString((String)childProvidable.getUiName());
            prefix = String.valueOf(name) + " / ";
        }
        List<String> childrenProblemsList = ChildValidationHelper.getChildrenProblemsList(childProvidable, level);
        if (childrenProblemsList != null) {
            return (List)childrenProblemsList.stream().flatMap(problem -> Arrays.asList(problem.split("\\R")).stream()).map(splitProblem -> String.valueOf(prefix) + splitProblem).collect(CollectorsUtils.toList());
        }
        return CollectionsUtils.asList((Object)name);
    }

    private static @Nullable IFunctionalGroup getFunctionalGroup(ISettingConfig config) {
        IFunctionalGroup group = config.getChildContext().getFunctionalGroup();
        if (group != null) {
            return group;
        }
        return null;
    }
}

